/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable;

import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.factmodel.ModelNameHelper;
import org.drools.guvnor.client.decisiontable.DTCellValueWidgetFactory;
import org.drools.guvnor.client.decisiontable.Validator;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.widgets.drools.wizards.assets.NewAssetWizardContext;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.AbstractGuidedDecisionTableWizardPage;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.ActionSetFieldsPageView;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.ActionSetFieldsPageViewImpl;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.AvailableField;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.events.ActionSetFieldsDefinedEvent;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.events.DuplicatePatternsEvent;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.events.PatternRemovedEvent;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;
import org.drools.ide.common.client.modeldriven.dt52.DTDataTypes52;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class ActionSetFieldsPage
extends AbstractGuidedDecisionTableWizardPage
implements ActionSetFieldsPageView.Presenter,
PatternRemovedEvent.Handler,
DuplicatePatternsEvent.Handler,
ActionSetFieldsDefinedEvent.Handler {
    private final ModelNameHelper modelNameHelper = new ModelNameHelper();
    private ActionSetFieldsPageView view;
    private Map<Pattern52, List<ActionSetFieldCol52>> patternToActionsMap = new IdentityHashMap<Pattern52, List<ActionSetFieldCol52>>();

    public ActionSetFieldsPage(NewAssetWizardContext context, GuidedDecisionTable52 dtable, EventBus eventBus, Validator validator) {
        super(context, dtable, eventBus, validator);
        this.getValidator().setPatternToActionSetFieldsMap(this.patternToActionsMap);
        this.view = new ActionSetFieldsPageViewImpl(this.getValidator());
        eventBus.addHandler(PatternRemovedEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(DuplicatePatternsEvent.TYPE, (EventHandler)this);
        eventBus.addHandler(ActionSetFieldsDefinedEvent.TYPE, (EventHandler)this);
    }

    @Override
    public void onPatternRemoved(PatternRemovedEvent event) {
        if (event.getSource() != this.context) {
            return;
        }
        this.patternToActionsMap.remove(event.getPattern());
    }

    public String getTitle() {
        return Constants.INSTANCE.DecisionTableWizardActionSetFields();
    }

    public void initialise() {
        if (this.sce == null) {
            return;
        }
        this.view.setPresenter(this);
        this.view.setDTCellValueWidgetFactory(DTCellValueWidgetFactory.getInstance(this.dtable, this.sce, false, this.allowEmptyValues()));
        for (ActionCol52 a : this.dtable.getActionCols()) {
            if (!(a instanceof ActionSetFieldCol52)) continue;
            ActionSetFieldCol52 asf = (ActionSetFieldCol52)a;
            Pattern52 p = this.dtable.getConditionPattern(asf.getBoundName());
            if (!this.patternToActionsMap.containsKey(p)) {
                this.patternToActionsMap.put(p, new ArrayList());
            }
            List<ActionSetFieldCol52> actions = this.patternToActionsMap.get(p);
            actions.add(asf);
        }
        this.content.setWidget((IsWidget)this.view);
    }

    public void prepareView() {
        this.view.setAvailablePatterns(this.dtable.getPatterns());
    }

    public boolean isComplete() {
        boolean areActionSetFieldsDefined = true;
        block0: for (List<ActionSetFieldCol52> actions : this.patternToActionsMap.values()) {
            for (ActionSetFieldCol52 a : actions) {
                if (this.getValidator().isActionValid((ActionCol52)a)) continue;
                areActionSetFieldsDefined = false;
                continue block0;
            }
        }
        ActionSetFieldsDefinedEvent event = new ActionSetFieldsDefinedEvent(areActionSetFieldsDefined);
        this.eventBus.fireEventFromSource((GwtEvent)event, (Object)this.context);
        return areActionSetFieldsDefined;
    }

    @Override
    public void onDuplicatePatterns(DuplicatePatternsEvent event) {
        if (event.getSource() != this.context) {
            return;
        }
        this.view.setArePatternBindingsUnique(event.getArePatternBindingsUnique());
    }

    @Override
    public void onActionSetFieldsDefined(ActionSetFieldsDefinedEvent event) {
        if (event.getSource() != this.context) {
            return;
        }
        this.view.setAreActionSetFieldsDefined(event.getAreActionSetFieldsDefined());
    }

    @Override
    public void selectPattern(Pattern52 pattern) {
        if (pattern == null) {
            return;
        }
        String type = pattern.getFactType();
        String[] fieldNames = this.sce.getFieldCompletions(type);
        ArrayList<AvailableField> availableFields = new ArrayList<AvailableField>();
        for (String fieldName : fieldNames) {
            String fieldType = this.sce.getFieldType(type, fieldName);
            String fieldDisplayType = this.modelNameHelper.getUserFriendlyTypeName(fieldType);
            AvailableField field = new AvailableField(fieldName, fieldType, fieldDisplayType, 1);
            availableFields.add(field);
        }
        this.view.setAvailableFields(availableFields);
        List<ActionSetFieldCol52> actionsForPattern = this.patternToActionsMap.get(pattern);
        if (actionsForPattern == null) {
            actionsForPattern = new ArrayList<ActionSetFieldCol52>();
            this.patternToActionsMap.put(pattern, actionsForPattern);
        }
        this.view.setChosenFields(actionsForPattern);
    }

    @Override
    public void makeResult(GuidedDecisionTable52 dtable) {
        for (Map.Entry<Pattern52, List<ActionSetFieldCol52>> ps : this.patternToActionsMap.entrySet()) {
            Pattern52 p = ps.getKey();
            if (p.getChildColumns().size() <= 0) continue;
            String binding = p.getBoundName();
            for (ActionSetFieldCol52 a : ps.getValue()) {
                a.setBoundName(binding);
                dtable.getActionCols().add(a);
            }
        }
    }

    @Override
    public GuidedDecisionTable52.TableFormat getTableFormat() {
        return this.dtable.getTableFormat();
    }

    @Override
    public boolean hasEnums(ActionSetFieldCol52 selectedAction) {
        for (Map.Entry<Pattern52, List<ActionSetFieldCol52>> e : this.patternToActionsMap.entrySet()) {
            if (!e.getValue().contains(selectedAction)) continue;
            String factType = e.getKey().getFactType();
            String factField = selectedAction.getFactField();
            return this.sce.hasEnums(factType, factField);
        }
        return false;
    }

    @Override
    public void assertDefaultValue(Pattern52 selectedPattern, ActionSetFieldCol52 selectedAction) {
        List<String> valueList = Arrays.asList(this.dtable.getValueList((BaseColumn)selectedAction));
        if (valueList.size() > 0) {
            String defaultValue = this.utilities.asString(selectedAction.getDefaultValue());
            if (!valueList.contains(defaultValue)) {
                selectedAction.getDefaultValue().clearValues();
            }
        } else {
            DTCellValue52 defaultValue = selectedAction.getDefaultValue();
            DTDataTypes52 dataType = this.utilities.getDataType(selectedPattern, selectedAction);
            this.utilities.assertDTCellValue(dataType, defaultValue);
        }
    }
}

