/*
 * Decompiled with CFR 0.152.
 */
package org.drools.repository;

import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import org.drools.repository.Item;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateItem
extends Item {
    private Logger log = LoggerFactory.getLogger(StateItem.class);
    public static final String DRAFT_STATE_NAME = "Draft";
    public static final String STATE_NODE_TYPE_NAME = "drools:stateNodeType";

    public StateItem(RulesRepository rulesRepository, Node node) throws RulesRepositoryException {
        super(rulesRepository, node);
        try {
            if (!this.node.getPrimaryNodeType().getName().equals(STATE_NODE_TYPE_NAME)) {
                String message = this.node.getName() + " is not a node of type " + STATE_NODE_TYPE_NAME + ". It is a node of type: " + this.node.getPrimaryNodeType().getName();
                this.log.error(message);
                throw new RulesRepositoryException(message);
            }
        }
        catch (Exception e) {
            this.log.error("Caught exception: " + e);
            throw new RulesRepositoryException(e);
        }
    }

    @Override
    public boolean equals(Object in) {
        if (!(in instanceof StateItem)) {
            return false;
        }
        if (in == this) {
            return true;
        }
        StateItem other = (StateItem)in;
        return this.getName().equals(other.getName());
    }

    public String toString() {
        return "Current status: [" + this.getName() + "]  (" + super.toString() + ")";
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    public void remove() {
        try {
            PropertyIterator pi = this.node.getReferences();
            if (pi.hasNext()) {
                throw new RulesRepositoryException("The status still has some assets linked to it. You will need to remove the links so you can delete the status.");
            }
            this.node.remove();
        }
        catch (RepositoryException e) {
            this.log.error("Unable to remove state item.", (Throwable)e);
        }
    }
}

