/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.common;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.enterprise.context.ApplicationScoped;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FileManager {
    private static final Logger logger = LoggerFactory.getLogger(FileManager.class);
    private static final String XML_EXTENSION = ".xml";
    private static final String BIN_DIR = "bin";
    private static final String MODULES_FILE = "modules.xml";
    private static final String CATEGORIES_FILE = "categories.xml";
    private File tempDir;
    private File binDir;

    public void setExportTempDir(File tempDir) {
        this.tempDir = tempDir;
        this.binDir = new File(tempDir, BIN_DIR);
        this.binDir.mkdirs();
    }

    public PrintWriter createModuleExportFileWriter() {
        return this.createFileWriter(MODULES_FILE);
    }

    public File getModulesExportFile() throws FileNotFoundException {
        return this.getFile(MODULES_FILE);
    }

    public PrintWriter createCategoryExportFileWriter() {
        return this.createFileWriter(CATEGORIES_FILE);
    }

    public File getCategoriesExportFile() throws FileNotFoundException {
        return this.getFile(CATEGORIES_FILE);
    }

    public PrintWriter createAssetExportFileWriter(String fileName) throws FileNotFoundException {
        return this.createFileWriter(this.getFile(fileName + XML_EXTENSION));
    }

    public boolean createAssetExportFile(String fileName) {
        return this.doCreateFile(new File(this.tempDir, fileName + XML_EXTENSION));
    }

    public File getAssetExportFile(String fileName) throws FileNotFoundException {
        return this.getFile(fileName + XML_EXTENSION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeBinaryContent(String fileName, byte[] bytes) {
        if (fileName == null) {
            return false;
        }
        File bFile = new File(this.binDir, fileName);
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(bFile));
            bos.write(bytes);
        }
        catch (Exception e) {
            logger.error("Error while creating binary file " + fileName + "; " + e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBinaryContent(String fileName) {
        if (fileName == null) {
            return null;
        }
        BufferedInputStream bis = null;
        try {
            int offset;
            File bFile = this.getBinaryFile(fileName);
            bis = new BufferedInputStream(new FileInputStream(bFile));
            byte[] bytes = new byte[(int)bFile.length()];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = bis.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                logger.warn("Binary file {} was not completely read!", (Object)fileName);
            }
            byte[] byArray = bytes;
            return byArray;
        }
        catch (Exception e) {
            logger.error("Error while creating binary file {}!", (Object)fileName, (Object)e);
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean doCreateFile(File file) {
        boolean success = false;
        try {
            success = file.createNewFile();
        }
        catch (IOException ioe) {
            logger.error("Error while creating file {}!", (Object)file.getName(), (Object)ioe);
        }
        return success;
    }

    private PrintWriter createFileWriter(String fileName) {
        PrintWriter pw = null;
        File f = new File(this.tempDir, fileName);
        this.doCreateFile(f);
        pw = this.createFileWriter(f);
        return pw;
    }

    private PrintWriter createFileWriter(File file) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(file);
        }
        catch (FileNotFoundException fnfe) {
            logger.error("Error creating file writer for  {}!", (Object)file.getName(), (Object)fnfe);
        }
        return pw;
    }

    private File getFile(String fileName) throws FileNotFoundException {
        File f = new File(this.tempDir, fileName);
        if (!f.exists()) {
            throw new FileNotFoundException("File " + fileName + " not found");
        }
        return f;
    }

    private File getBinaryFile(String fileName) throws FileNotFoundException {
        File f = new File(this.binDir, fileName);
        if (!f.exists()) {
            throw new FileNotFoundException("Binary file " + fileName + " not found");
        }
        return f;
    }
}

