/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.persistence.Entity;
import org.drools.core.base.ClassTypeResolver;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.guvnor.common.services.backend.exceptions.ExceptionUtilities;
import org.guvnor.common.services.backend.validation.GenericValidator;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.common.services.shared.metadata.model.Metadata;
import org.guvnor.common.services.shared.metadata.model.Overview;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.guvnor.messageconsole.events.PublishBatchMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.kie.workbench.common.screens.datamodeller.backend.server.DataModelerServiceHelper;
import org.kie.workbench.common.screens.datamodeller.backend.server.file.DataModelerCopyHelper;
import org.kie.workbench.common.screens.datamodeller.backend.server.file.DataModelerRenameHelper;
import org.kie.workbench.common.screens.datamodeller.backend.server.handler.DomainHandler;
import org.kie.workbench.common.screens.datamodeller.backend.server.helper.DataModelerRenameWorkaroundHelper;
import org.kie.workbench.common.screens.datamodeller.backend.server.helper.DataModelerSaveHelper;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectCreatedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectDeletedEvent;
import org.kie.workbench.common.screens.datamodeller.events.DataObjectRenamedEvent;
import org.kie.workbench.common.screens.datamodeller.model.DataModelerError;
import org.kie.workbench.common.screens.datamodeller.model.EditorModelContent;
import org.kie.workbench.common.screens.datamodeller.model.GenerationResult;
import org.kie.workbench.common.screens.datamodeller.model.TypeInfoResult;
import org.kie.workbench.common.screens.datamodeller.service.DataModelerService;
import org.kie.workbench.common.screens.datamodeller.service.ServiceException;
import org.kie.workbench.common.services.backend.project.ProjectClassLoaderHelper;
import org.kie.workbench.common.services.backend.service.KieService;
import org.kie.workbench.common.services.datamodel.backend.server.service.DataModelService;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationContext;
import org.kie.workbench.common.services.datamodeller.codegen.GenerationEngine;
import org.kie.workbench.common.services.datamodeller.core.Annotation;
import org.kie.workbench.common.services.datamodeller.core.AnnotationDefinition;
import org.kie.workbench.common.services.datamodeller.core.DataModel;
import org.kie.workbench.common.services.datamodeller.core.DataObject;
import org.kie.workbench.common.services.datamodeller.core.ElementType;
import org.kie.workbench.common.services.datamodeller.core.PropertyType;
import org.kie.workbench.common.services.datamodeller.core.impl.DataObjectImpl;
import org.kie.workbench.common.services.datamodeller.core.impl.PropertyTypeFactoryImpl;
import org.kie.workbench.common.services.datamodeller.driver.FilterHolder;
import org.kie.workbench.common.services.datamodeller.driver.ModelDriverException;
import org.kie.workbench.common.services.datamodeller.driver.impl.JavaRoasterModelDriver;
import org.kie.workbench.common.services.datamodeller.driver.impl.ProjectDataModelOracleUtils;
import org.kie.workbench.common.services.datamodeller.driver.impl.UpdateInfo;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationDefinitionRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationDefinitionResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationParseResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceRequest;
import org.kie.workbench.common.services.datamodeller.driver.model.AnnotationSourceResponse;
import org.kie.workbench.common.services.datamodeller.driver.model.DriverError;
import org.kie.workbench.common.services.datamodeller.driver.model.ModelDriverResult;
import org.kie.workbench.common.services.datamodeller.util.DriverUtils;
import org.kie.workbench.common.services.datamodeller.util.NamingUtils;
import org.kie.workbench.common.services.refactoring.model.query.RefactoringPageRow;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.RefactoringQueryService;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.services.refactoring.service.impact.QueryOperationRequest;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.commons.data.Pair;
import org.uberfire.ext.editor.commons.service.CopyService;
import org.uberfire.ext.editor.commons.service.DeleteService;
import org.uberfire.ext.editor.commons.service.RenameService;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.base.SegmentedPath;
import org.uberfire.java.nio.base.options.CommentedOption;
import org.uberfire.java.nio.file.CopyOption;
import org.uberfire.java.nio.file.FileAlreadyExistsException;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.FileAttribute;

@Service
@ApplicationScoped
public class DataModelerServiceImpl
extends KieService<EditorModelContent>
implements DataModelerService {
    private static final Logger logger = LoggerFactory.getLogger(DataModelerServiceImpl.class);
    @Inject
    @Named(value="ioStrategy")
    IOService ioService;
    @Inject
    private User identity;
    @Inject
    private DataModelService dataModelService;
    @Inject
    private DataModelerServiceHelper serviceHelper;
    @Inject
    private ProjectClassLoaderHelper classLoaderHelper;
    @Inject
    private Event<DataObjectCreatedEvent> dataObjectCreatedEvent;
    @Inject
    private Event<DataObjectDeletedEvent> dataObjectDeletedEvent;
    @Inject
    private Event<DataObjectRenamedEvent> dataObjectRenamedEvent;
    @Inject
    private RefactoringQueryService queryService;
    @Inject
    private Event<PublishBatchMessagesEvent> publishBatchMessagesEvent;
    @Inject
    private DeleteService deleteService;
    @Inject
    private CopyService copyService;
    @Inject
    private RenameService renameService;
    @Inject
    private DataModelerCopyHelper copyHelper;
    @Inject
    private DataModelerRenameHelper renameHelper;
    @Inject
    private Instance<DataModelerSaveHelper> saveHelperInstance;
    @Inject
    private Instance<DataModelerRenameWorkaroundHelper> renameHelperInstance;
    @Inject
    private GenericValidator genericValidator;
    @Inject
    @Any
    private Instance<DomainHandler> domainHandlers;
    @Inject
    private FilterHolder filterHolder;
    private static final String DEFAULT_COMMIT_MESSAGE = "Data modeller generated action.";

    public EditorModelContent loadContent(org.uberfire.backend.vfs.Path path) {
        return this.loadContent(path, true);
    }

    public EditorModelContent loadContent(org.uberfire.backend.vfs.Path path, boolean includeTypesInfo) {
        EditorModelContent editorModelContent = (EditorModelContent)super.loadContent(path);
        if (includeTypesInfo) {
            editorModelContent.setPropertyTypes(this.getBasePropertyTypes());
            editorModelContent.setAnnotationDefinitions(this.getAnnotationDefinitions());
        }
        return editorModelContent;
    }

    public DataModel loadModel(KieProject project) {
        Pair<DataModel, ModelDriverResult> resultPair = this.loadModel(project, true);
        return resultPair != null ? (DataModel)resultPair.getK1() : null;
    }

    public org.uberfire.backend.vfs.Path createJavaFile(org.uberfire.backend.vfs.Path context, String fileName, String comment) {
        return this.createJavaFile(context, fileName, comment, null);
    }

    public org.uberfire.backend.vfs.Path createJavaFile(org.uberfire.backend.vfs.Path context, String fileName, String comment, Map<String, Object> options) {
        Path nioPath = Paths.convert((org.uberfire.backend.vfs.Path)context).resolve(fileName);
        org.uberfire.backend.vfs.Path newPath = Paths.convert((Path)nioPath);
        if (this.ioService.exists(nioPath)) {
            throw new FileAlreadyExistsException(nioPath.toString());
        }
        try {
            Iterator it;
            Package currentPackage = this.projectService.resolvePackage(context);
            String packageName = currentPackage.getPackageName();
            String className = fileName.substring(0, fileName.indexOf(".java"));
            KieProject currentProject = (KieProject)this.projectService.resolveProject(context);
            DataObjectImpl dataObject = new DataObjectImpl(packageName, className);
            Iterator iterator = it = this.domainHandlers != null ? this.domainHandlers.iterator() : null;
            while (it != null && it.hasNext()) {
                ((DomainHandler)it.next()).setDefaultValues((DataObject)dataObject, options);
            }
            String source = this.createJavaSource((DataObject)dataObject);
            this.ioService.write(nioPath, source, new OpenOption[]{this.serviceHelper.makeCommentedOption(comment)});
            this.dataObjectCreatedEvent.fire((Object)new DataObjectCreatedEvent((Project)currentProject, (DataObject)dataObject));
            return newPath;
        }
        catch (Exception e) {
            logger.error("It was not possible to create Java file, for path: " + context.toURI() + ", fileName: " + fileName, (Throwable)e);
            throw new ServiceException("It was not possible to create Java file, for path: " + context.toURI() + ", fileName: " + fileName, (Throwable)e);
        }
    }

    protected EditorModelContent constructContent(org.uberfire.backend.vfs.Path path, Overview overview) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading editor model from path: " + path.toURI());
        }
        Long startTime = System.currentTimeMillis();
        EditorModelContent editorModelContent = new EditorModelContent();
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                return editorModelContent;
            }
            Pair<DataModel, ModelDriverResult> resultPair = this.loadModel(project, false);
            String className = this.calculateClassName((Project)project, path);
            editorModelContent.setCurrentProject(project);
            editorModelContent.setPath(path);
            editorModelContent.setCurrentProjectPackages(this.serviceHelper.resolvePackages(project));
            editorModelContent.setDataModel((DataModel)resultPair.getK1());
            editorModelContent.setDataObject(((DataModel)resultPair.getK1()).getDataObject(className));
            editorModelContent.setDataObjectPaths(((ModelDriverResult)resultPair.getK2()).getClassPaths());
            editorModelContent.setOriginalClassName(className);
            editorModelContent.setOriginalPackageName(NamingUtils.extractPackageName((String)className));
            if (this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)path))) {
                String source = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
                editorModelContent.setSource(source);
            }
            if (((ModelDriverResult)resultPair.getK2()).hasErrors()) {
                editorModelContent.setErrors(this.serviceHelper.toDataModelerError(((ModelDriverResult)resultPair.getK2()).getErrors()));
            }
            editorModelContent.setOverview(overview);
            editorModelContent.setElapsedTime(System.currentTimeMillis() - startTime);
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when loading editor model from:" + path + " : " + editorModelContent.getElapsedTime() + " ms");
            }
            return editorModelContent;
        }
        catch (Exception e) {
            logger.error("Editor model couldn't be loaded from path: " + (path != null ? path.toURI() : path) + ".", (Throwable)e);
            throw new ServiceException("Editor model couldn't be loaded from path: " + (path != null ? path.toURI() : path) + ".", (Throwable)e);
        }
    }

    private Pair<DataModel, ModelDriverResult> loadModel(KieProject project, boolean processErrors) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading data model from path: " + project.getRootPath());
        }
        Long startTime = System.currentTimeMillis();
        DataModel dataModel = null;
        org.uberfire.backend.vfs.Path projectPath = null;
        Package defaultPackage = null;
        try {
            projectPath = project.getRootPath();
            defaultPackage = this.projectService.resolveDefaultPackage((Project)project);
            if (logger.isDebugEnabled()) {
                logger.debug("Current project path is: " + projectPath);
            }
            ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(project);
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, Paths.convert((org.uberfire.backend.vfs.Path)defaultPackage.getPackageMainSrcPath()), classLoader, this.filterHolder);
            ModelDriverResult result = modelDriver.loadModel();
            dataModel = result.getDataModel();
            if (processErrors && result.hasErrors()) {
                this.processErrors(project, result);
            }
            ProjectDataModelOracle projectDataModelOracle = this.dataModelService.getProjectDataModel(projectPath);
            ProjectDataModelOracleUtils.loadExternalDependencies((DataModel)dataModel, (ProjectDataModelOracle)projectDataModelOracle, (ClassLoader)classLoader);
            Long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when loading " + projectPath.getFileName() + ": " + (endTime - startTime) + " ms");
            }
            return new Pair((Object)dataModel, (Object)result);
        }
        catch (Exception e) {
            logger.error("Data model couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
            throw new ServiceException("Data model couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
        }
    }

    public TypeInfoResult loadJavaTypeInfo(String source) {
        try {
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
            TypeInfoResult result = new TypeInfoResult();
            org.kie.workbench.common.services.datamodeller.driver.TypeInfoResult driverResult = modelDriver.loadJavaTypeInfo(source);
            result.setJavaTypeInfo(driverResult.getTypeInfo());
            if (driverResult.hasErrors()) {
                result.setErrors(this.serviceHelper.toDataModelerError(driverResult.getErrors()));
            }
            return result;
        }
        catch (Exception e) {
            logger.error("JavaTypeInfo object couldn't be loaded for source: " + source, (Throwable)e);
            throw new ServiceException("JavaTypeInfo object couldn't be loaded for source.", (Throwable)e);
        }
    }

    public GenerationResult loadDataObject(org.uberfire.backend.vfs.Path projectPath, String source, org.uberfire.backend.vfs.Path sourcePath) {
        if (logger.isDebugEnabled()) {
            logger.debug("Loading data object from projectPath: " + projectPath.toURI());
        }
        DataObject dataObject = null;
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(projectPath);
            if (project == null) {
                return new GenerationResult(null, null, new ArrayList());
            }
            ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(project);
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, null, classLoader, this.filterHolder);
            ModelDriverResult driverResult = modelDriver.loadDataObject(source, Paths.convert((org.uberfire.backend.vfs.Path)sourcePath));
            if (!driverResult.hasErrors()) {
                if (driverResult.getDataModel().getDataObjects().size() > 0) {
                    dataObject = (DataObject)driverResult.getDataModel().getDataObjects().iterator().next();
                }
                return new GenerationResult(source, dataObject, new ArrayList());
            }
            return new GenerationResult(source, null, this.serviceHelper.toDataModelerError(driverResult.getErrors()));
        }
        catch (Exception e) {
            logger.error("Data object couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
            throw new ServiceException("Data object couldn't be loaded, path: " + projectPath + ", projectPath: " + projectPath + ".", (Throwable)e);
        }
    }

    public GenerationResult updateSource(String source, org.uberfire.backend.vfs.Path path, DataObject dataObject) {
        GenerationResult result = new GenerationResult();
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                result.setSource(source);
                return result;
            }
            ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(project);
            Pair<String, List<DataModelerError>> updateResult = this.updateJavaSource(source, dataObject, new HashMap<String, String>(), new ArrayList<String>(), classLoader);
            result.setSource((String)updateResult.getK1());
            result.setDataObject(dataObject);
            result.setErrors((List)updateResult.getK2());
            return result;
        }
        catch (Exception e) {
            logger.error("Source file for data object: " + dataObject.getClassName() + ", couldn't be updated", (Throwable)e);
            throw new ServiceException("Source file for data object: " + dataObject.getClassName() + ", couldn't be updated", (Throwable)e);
        }
    }

    public GenerationResult updateDataObject(DataObject dataObject, String source, org.uberfire.backend.vfs.Path path) {
        GenerationResult result = new GenerationResult();
        try {
            result.setSource(source);
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                result.setSource(source);
                return result;
            }
            ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(project);
            JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, Paths.convert((org.uberfire.backend.vfs.Path)path), classLoader, this.filterHolder);
            ModelDriverResult driverResult = modelDriver.loadDataObject(source, Paths.convert((org.uberfire.backend.vfs.Path)path));
            if (driverResult.hasErrors()) {
                result.setErrors(this.serviceHelper.toDataModelerError(driverResult.getErrors()));
            } else if (driverResult.getDataModel().getDataObjects().size() > 0) {
                result.setDataObject((DataObject)driverResult.getDataModel().getDataObjects().iterator().next());
            }
            return result;
        }
        catch (Exception e) {
            logger.error("Source file for data object: " + dataObject.getClassName() + ", couldn't be parsed", (Throwable)e);
            throw new ServiceException("Source file for data object: " + dataObject.getClassName() + ", couldn't be parsed", (Throwable)e);
        }
    }

    public GenerationResult saveSource(String source, org.uberfire.backend.vfs.Path path, DataObject dataObject, Metadata metadata, String commitMessage) {
        return this.saveSource(source, path, dataObject, metadata, commitMessage, null, null);
    }

    public GenerationResult saveSource(String source, org.uberfire.backend.vfs.Path path, DataObject dataObject, Metadata metadata, String commitMessage, String newPackageName, String newFileName) {
        boolean onBatch = false;
        try {
            Package currentPackage;
            GenerationResult result = this.resolveSaveSource(source, path, dataObject);
            Package targetPackage = currentPackage = this.projectService.resolvePackage(path);
            String targetName = path.getFileName();
            Path targetPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
            boolean packageChanged = false;
            boolean nameChanged = false;
            if (!(newPackageName == null || currentPackage != null && newPackageName.equals(currentPackage.getPackageName()))) {
                targetPackage = this.serviceHelper.ensurePackageStructure(this.projectService.resolveProject(path), newPackageName);
                packageChanged = true;
            }
            if (newFileName != null && !(newFileName + ".java").equals(path.getFileName())) {
                targetName = newFileName + ".java";
                nameChanged = true;
            }
            this.fireMetadataSocialEvents(path, this.metadataService.getMetadata(path), metadata);
            this.ioService.startBatch(targetPath.getFileSystem());
            onBatch = true;
            if (packageChanged) {
                targetPath = Paths.convert((org.uberfire.backend.vfs.Path)targetPackage.getPackageMainSrcPath()).resolve(targetName);
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), result.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                this.ioService.move(Paths.convert((org.uberfire.backend.vfs.Path)path), targetPath, new CopyOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                result.setPath(Paths.convert((Path)targetPath));
            } else if (nameChanged) {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), result.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                org.uberfire.backend.vfs.Path newPath = this.renameService.rename(path, newFileName, commitMessage);
                result.setPath(newPath);
            } else {
                this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), result.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(commitMessage)});
                result.setPath(path);
            }
            if (this.saveHelperInstance != null) {
                for (DataModelerSaveHelper saveHelper : this.saveHelperInstance) {
                    saveHelper.postProcess(path, result.getPath());
                }
            }
            GenerationResult generationResult = result;
            return generationResult;
        }
        catch (Exception e) {
            logger.error("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObject != null ? dataObject.getClassName() : null) + ".", (Throwable)e);
            throw new ServiceException("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObject != null ? dataObject.getClassName() : null) + ".", (Throwable)e);
        }
        finally {
            if (onBatch) {
                this.ioService.endBatch();
            }
        }
    }

    private GenerationResult resolveSaveSource(String source, org.uberfire.backend.vfs.Path path, DataObject dataObject) {
        GenerationResult result = new GenerationResult();
        try {
            String updatedSource;
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                result.setSource(source);
                return result;
            }
            if (dataObject != null) {
                result = this.updateSource(source, path, dataObject);
                updatedSource = result.getSource();
            } else {
                updatedSource = source;
            }
            if (dataObject == null) {
                ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(project);
                JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.ioService, Paths.convert((org.uberfire.backend.vfs.Path)path), classLoader, this.filterHolder);
                ModelDriverResult driverResult = modelDriver.loadDataObject(source, Paths.convert((org.uberfire.backend.vfs.Path)path));
                if (driverResult.hasErrors()) {
                    result.setErrors(this.serviceHelper.toDataModelerError(driverResult.getErrors()));
                } else if (driverResult.getDataModel().getDataObjects().size() > 0) {
                    result.setDataObject((DataObject)driverResult.getDataModel().getDataObjects().iterator().next());
                }
            }
            result.setSource(updatedSource);
            return result;
        }
        catch (Exception e) {
            logger.error("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObject != null ? dataObject.getClassName() : null) + ".", (Throwable)e);
            throw new ServiceException("Source file couldn't be updated, path: " + path.toURI() + ", dataObject: " + (dataObject != null ? dataObject.getClassName() : null) + ".", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path copy(org.uberfire.backend.vfs.Path path, String newName, String newPackageName, org.uberfire.backend.vfs.Path targetDirectory, String comment, boolean refactor) {
        org.uberfire.backend.vfs.Path targetPath = null;
        if (refactor) {
            try {
                GenerationResult refactoringResult = this.refactorClass(path, newPackageName, newName);
                if (!refactoringResult.hasErrors()) {
                    targetPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)targetDirectory).resolve(newName + ".java"));
                    this.copyHelper.addRefactoredPath(targetPath, refactoringResult.getSource(), comment);
                    KieProject project = (KieProject)this.projectService.resolveProject(targetPath);
                    if (project != null) {
                        this.dataObjectCreatedEvent.fire((Object)new DataObjectCreatedEvent((Project)project, refactoringResult.getDataObject()));
                    }
                }
            }
            catch (Exception e) {
                logger.error("An error was produced during class refactoring at file copying for file: " + path + ". The file copying will continue without class refactoring", (Throwable)e);
            }
        }
        try {
            org.uberfire.backend.vfs.Path path2 = this.copyService.copy(path, newName, targetDirectory, comment);
            return path2;
        }
        finally {
            if (targetPath != null) {
                this.copyHelper.removeRefactoredPath(targetPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public org.uberfire.backend.vfs.Path rename(org.uberfire.backend.vfs.Path path, String newName, String comment, boolean refactor, boolean saveCurrentChanges, String source, DataObject dataObject, Metadata metadata) {
        org.uberfire.backend.vfs.Path path2;
        block11: {
            String newContent;
            org.uberfire.backend.vfs.Path targetPath;
            block9: {
                org.uberfire.backend.vfs.Path e2;
                block10: {
                    String sourceToRefactor;
                    GenerationResult saveResult = null;
                    if (saveCurrentChanges) {
                        saveResult = this.resolveSaveSource(source, path, dataObject);
                        this.ioService.write(Paths.convert((org.uberfire.backend.vfs.Path)path), saveResult.getSource(), this.metadataService.setUpAttributes(path, metadata), new OpenOption[]{this.serviceHelper.makeCommentedOption(comment)});
                    }
                    targetPath = null;
                    newContent = null;
                    if (refactor && (sourceToRefactor = saveCurrentChanges ? (saveResult != null && !saveResult.hasErrors() ? saveResult.getSource() : null) : source) != null) {
                        try {
                            GenerationResult refactoringResult = this.refactorClass(sourceToRefactor, path, null, newName);
                            if (!refactoringResult.hasErrors()) {
                                targetPath = Paths.convert((Path)Paths.convert((org.uberfire.backend.vfs.Path)path).resolveSibling(newName + ".java"));
                                this.renameHelper.addRefactoredPath(targetPath, refactoringResult.getSource(), comment);
                                newContent = refactoringResult.getSource();
                            }
                        }
                        catch (Exception e2) {
                            logger.error("An error was produced during class refactoring at file renaming for file: " + path + ". The file renaming will continue without class refactoring", (Throwable)e2);
                        }
                    }
                    try {
                        boolean workaround = true;
                        if (workaround) break block9;
                        e2 = this.renameService.rename(path, newName, comment);
                        if (targetPath == null) break block10;
                    }
                    catch (Throwable throwable) {
                        if (targetPath != null) {
                            this.renameHelper.removeRefactoredPath(targetPath);
                        }
                        throw throwable;
                    }
                    this.renameHelper.removeRefactoredPath(targetPath);
                }
                return e2;
            }
            org.uberfire.backend.vfs.Path updatedPath = this.renameWorkaround(path, newName, newContent, comment);
            this.dataObjectRenamedEvent.fire((Object)((DataObjectRenamedEvent)new DataObjectRenamedEvent().withPath(updatedPath)));
            path2 = updatedPath;
            if (targetPath == null) break block11;
            this.renameHelper.removeRefactoredPath(targetPath);
        }
        return path2;
    }

    public org.uberfire.backend.vfs.Path renameWorkaround(org.uberfire.backend.vfs.Path path, String newName, String newContent, String comment) {
        try {
            Path _path = Paths.convert((org.uberfire.backend.vfs.Path)path);
            String originalFileName = _path.getFileName().toString();
            String extension = originalFileName.substring(originalFileName.lastIndexOf("."));
            Path _target = _path.resolveSibling(newName + extension);
            org.uberfire.backend.vfs.Path targetPath = Paths.convert((Path)_target);
            try {
                if (newContent != null) {
                    this.ioService.write(_path, newContent, new OpenOption[]{this.serviceHelper.makeCommentedOption(comment)});
                }
                this.ioService.startBatch(new FileSystem[]{_target.getFileSystem()});
                this.ioService.move(_path, _target, new CopyOption[]{this.serviceHelper.makeCommentedOption("File [" + path.toURI() + "] renamed to [" + targetPath.toURI() + "].")});
                if (this.renameHelperInstance != null) {
                    for (DataModelerRenameWorkaroundHelper renameHelper : this.renameHelperInstance) {
                        renameHelper.postProcess(path, targetPath);
                    }
                }
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                this.ioService.endBatch();
            }
            return Paths.convert((Path)_target);
        }
        catch (Exception e) {
            throw ExceptionUtilities.handleException((Exception)e);
        }
    }

    public String getSource(org.uberfire.backend.vfs.Path path) {
        Path convertedPath = Paths.convert((org.uberfire.backend.vfs.Path)path);
        return this.ioService.readAllString(convertedPath);
    }

    private void processErrors(KieProject project, ModelDriverResult result) {
        PublishBatchMessagesEvent publishEvent = new PublishBatchMessagesEvent();
        publishEvent.setCleanExisting(true);
        publishEvent.setUserId(this.identity != null ? this.identity.getIdentifier() : null);
        publishEvent.setMessageType("DataModeler");
        for (DriverError error : result.getErrors()) {
            SystemMessage systemMessage = new SystemMessage();
            systemMessage.setMessageType("DataModeler");
            systemMessage.setLevel(Level.ERROR);
            systemMessage.setId(error.getId());
            systemMessage.setText(error.getMessage());
            systemMessage.setColumn(error.getColumn());
            systemMessage.setLine(error.getLine());
            systemMessage.setPath(error.getFile());
            publishEvent.getMessagesToPublish().add(systemMessage);
        }
        this.publishBatchMessagesEvent.fire((Object)publishEvent);
    }

    public GenerationResult saveModel(DataModel dataModel, KieProject project, boolean overwrite, String commitMessage) {
        Long startTime = System.currentTimeMillis();
        boolean onBatch = false;
        try {
            CommentedOption option = this.serviceHelper.makeCommentedOption(commitMessage);
            this.ioService.startBatch(Paths.convert((org.uberfire.backend.vfs.Path)project.getRootPath()).getFileSystem());
            onBatch = true;
            this.generateModel(dataModel, project, option);
            onBatch = false;
            this.ioService.endBatch();
            Long endTime = System.currentTimeMillis();
            if (logger.isDebugEnabled()) {
                logger.debug("Time elapsed when saving " + project.getProjectName() + ": " + (endTime - startTime) + " ms");
            }
            GenerationResult result = new GenerationResult();
            result.setGenerationTime(endTime - startTime);
            return result;
        }
        catch (Exception e) {
            logger.error("An error was produced during data model adf, dataModel: " + dataModel + ", path: " + project.getRootPath(), (Throwable)e);
            if (onBatch) {
                try {
                    logger.warn("IOService batch method is still on, trying to end batch processing.");
                    this.ioService.endBatch();
                    logger.warn("IOService batch method is was successfully finished. The user will still get the exception, but the batch processing was finished.");
                }
                catch (Exception ex) {
                    logger.error("An error was produced when the IOService.endBatch processing was executed.", (Throwable)ex);
                }
            }
            throw new ServiceException("Data model couldn't be generated due to the following error. " + e);
        }
    }

    public GenerationResult saveModel(DataModel dataModel, KieProject project) {
        return this.saveModel(dataModel, project, false, DEFAULT_COMMIT_MESSAGE);
    }

    public void delete(org.uberfire.backend.vfs.Path path, String comment) {
        try {
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                return;
            }
            this.deleteService.delete(path, comment);
            String className = this.calculateClassName((Project)project, path);
            DataObjectImpl dataObject = new DataObjectImpl(NamingUtils.extractPackageName((String)className), NamingUtils.extractClassName((String)className));
            this.dataObjectDeletedEvent.fire((Object)new DataObjectDeletedEvent((Project)project, (DataObject)dataObject));
        }
        catch (Exception e) {
            logger.error("File: " + path.toURI() + " couldn't be deleted due to the following error. ", (Throwable)e);
            throw new ServiceException("File: " + path.toURI() + " couldn't be deleted due to the following error. " + e.getMessage());
        }
    }

    public GenerationResult refactorClass(org.uberfire.backend.vfs.Path path, String newPackageName, String newClassName) {
        String source = this.ioService.readAllString(Paths.convert((org.uberfire.backend.vfs.Path)path));
        return this.refactorClass(source, path, newPackageName, newClassName);
    }

    private GenerationResult refactorClass(String source, org.uberfire.backend.vfs.Path path, String newPackageName, String newClassName) {
        GenerationResult result = this.loadDataObject(path, source, path);
        if ((result.getErrors() == null || result.getErrors().isEmpty()) && result.getDataObject() != null) {
            DataObject dataObject = result.getDataObject();
            if (newPackageName != null) {
                dataObject.setPackageName(newPackageName);
            }
            if (newClassName != null) {
                dataObject.setName(newClassName);
            }
            return this.updateSource(source, path, dataObject);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<ValidationMessage> validate(String source, org.uberfire.backend.vfs.Path path, DataObject dataObject) {
        try {
            String validationSource = null;
            ArrayList<ValidationMessage> validations = new ArrayList<ValidationMessage>();
            KieProject project = (KieProject)this.projectService.resolveProject(path);
            if (project == null) {
                logger.warn("File : " + path.toURI() + " do not belong to a valid project");
                ValidationMessage validationMessage = new ValidationMessage();
                validationMessage.setPath(path);
                validationMessage.setText("File do no belong to a valid project");
                validationMessage.setLevel(Level.ERROR);
                validations.add(new ValidationMessage());
                return validations;
            }
            if (dataObject != null) {
                GenerationResult result = this.updateSource(source, path, dataObject);
                if (result.hasErrors()) return this.serviceHelper.toValidationMessage(result.getErrors());
                validationSource = result.getSource();
                return this.genericValidator.validate(path, validationSource != null ? validationSource : "");
            } else {
                validationSource = source;
            }
            return this.genericValidator.validate(path, validationSource != null ? validationSource : "");
        }
        catch (Exception e) {
            logger.error("An error was produced during validation", (Throwable)e);
            throw new ServiceException("An error was produced during validation", (Throwable)e);
        }
    }

    private void generateModel(DataModel dataModel, KieProject project, CommentedOption option) throws Exception {
        org.uberfire.backend.vfs.Path projectPath = project.getRootPath();
        Path javaRootPath = this.ensureProjectJavaPath(Paths.convert((org.uberfire.backend.vfs.Path)projectPath));
        for (DataObject dataObject : dataModel.getDataObjects()) {
            Path targetFile = this.calculateFilePath(dataObject.getClassName(), javaRootPath);
            if (logger.isDebugEnabled()) {
                logger.debug("Data object: " + dataObject.getClassName() + " java source code will be generated from scratch and written into file: " + targetFile);
            }
            String newSource = this.createJavaSource(dataObject);
            this.ioService.write(targetFile, newSource, new OpenOption[]{option});
        }
    }

    private Pair<String, List<DataModelerError>> updateJavaSource(String originalSource, DataObject dataObject, Map<String, String> renames, List<String> deletions, ClassLoader classLoader) throws Exception {
        String newSource;
        JavaType javaType;
        ArrayList<DataModelerError> errors = new ArrayList<DataModelerError>();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting java source update for class: " + dataObject.getClassName());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("original source is: " + originalSource);
        }
        if ((javaType = Roaster.parse((String)originalSource)).isClass()) {
            if (javaType.getSyntaxErrors() != null && !javaType.getSyntaxErrors().isEmpty()) {
                errors.addAll(this.serviceHelper.toDataModelerError(javaType.getSyntaxErrors(), null));
                newSource = originalSource;
            } else {
                JavaClassSource javaClassSource = (JavaClassSource)javaType;
                ClassTypeResolver classTypeResolver = DriverUtils.createClassTypeResolver((JavaSource)javaClassSource, (ClassLoader)classLoader);
                this.updateJavaClassSource(dataObject, javaClassSource, renames, deletions, classTypeResolver);
                newSource = javaClassSource.toString();
            }
        } else {
            logger.debug("No Class definition was found for source: " + originalSource + ", original source won't be modified.");
            newSource = originalSource;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("updated source is: " + newSource);
        }
        return new Pair((Object)newSource, errors);
    }

    private void updateJavaClassSource(DataObject dataObject, JavaClassSource javaClassSource, Map<String, String> renames, List<String> deletions, ClassTypeResolver classTypeResolver) throws Exception {
        if (javaClassSource == null || !javaClassSource.isClass()) {
            logger.warn("A null javaClassSource or javaClassSouce is not a Class, no processing will be done. javaClassSource: " + javaClassSource + " className: " + (javaClassSource != null ? javaClassSource.getName() : null));
            return;
        }
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver(this.filterHolder);
        UpdateInfo updateInfo = new UpdateInfo();
        if (renames != null) {
            for (Map.Entry entry : renames.entrySet()) {
                updateInfo.addClassRename((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (deletions != null) {
            for (String string : deletions) {
                updateInfo.addDeletedClass(string);
            }
        }
        modelDriver.updateSource(javaClassSource, dataObject, updateInfo, classTypeResolver);
    }

    private String createJavaSource(DataObject dataObject) throws Exception {
        String source;
        GenerationContext generationContext = new GenerationContext(null);
        try {
            GenerationEngine engine = GenerationEngine.getInstance();
            source = engine.generateJavaClassString(generationContext, dataObject);
        }
        catch (Exception e) {
            logger.error("Java source for dataObject: " + dataObject.getClassName() + " couldn't be created.", (Throwable)e);
            throw e;
        }
        return source;
    }

    public List<org.uberfire.backend.vfs.Path> findClassUsages(org.uberfire.backend.vfs.Path currentPath, String className) {
        KieProject project = (KieProject)this.projectService.resolveProject(currentPath);
        String branch = "master";
        if (currentPath instanceof SegmentedPath) {
            branch = ((SegmentedPath)currentPath).getSegmentId();
        }
        QueryOperationRequest request = (QueryOperationRequest)QueryOperationRequest.references((String)className, (ResourceType)ResourceType.JAVA).inProjectRootPathURI(project.getRootPath().toURI()).onBranch(branch);
        return this.executeReferencesQuery(request);
    }

    public List<org.uberfire.backend.vfs.Path> findFieldUsages(org.uberfire.backend.vfs.Path currentPath, String className, String fieldName) {
        KieProject project = (KieProject)this.projectService.resolveProject(currentPath);
        String branch = "master";
        if (currentPath instanceof SegmentedPath) {
            branch = ((SegmentedPath)currentPath).getSegmentId();
        }
        QueryOperationRequest request = (QueryOperationRequest)QueryOperationRequest.referencesPart((String)className, (String)fieldName, (PartType)PartType.FIELD).inProjectRootPathURI(project.getRootPath().toURI()).onBranch(branch);
        return this.executeReferencesQuery(request);
    }

    public List<String> findPersistableClasses(org.uberfire.backend.vfs.Path path) {
        DataModel dataModel;
        ArrayList<String> classes = new ArrayList<String>();
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        if (project != null && (dataModel = this.loadModel(project)) != null) {
            for (DataObject dataObject : dataModel.getDataObjects()) {
                if (dataObject.getAnnotation(Entity.class.getName()) == null) continue;
                classes.add(dataObject.getClassName());
            }
        }
        return classes;
    }

    public Boolean isPersistableClass(String className, org.uberfire.backend.vfs.Path path) {
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        if (project != null) {
            ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(project);
            try {
                classLoader.loadClass(className);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private List<org.uberfire.backend.vfs.Path> executeReferencesQuery(QueryOperationRequest request) {
        ArrayList<org.uberfire.backend.vfs.Path> results = new ArrayList<org.uberfire.backend.vfs.Path>();
        try {
            List queryResults = this.queryService.queryToList(request);
            if (queryResults != null) {
                for (RefactoringPageRow row : queryResults) {
                    results.add((org.uberfire.backend.vfs.Path)row.getValue());
                }
            }
            return results;
        }
        catch (Exception e) {
            String msg = "Unable to query lucene index for resource references: " + e.getMessage();
            logger.error(msg);
            throw new ServiceException(msg, (Throwable)e);
        }
    }

    public List<PropertyType> getBasePropertyTypes() {
        ArrayList<PropertyType> types = new ArrayList<PropertyType>();
        types.addAll(PropertyTypeFactoryImpl.getInstance().getBasePropertyTypes());
        return types;
    }

    public Map<String, AnnotationDefinition> getAnnotationDefinitions() {
        HashMap<String, AnnotationDefinition> annotations = new HashMap<String, AnnotationDefinition>();
        Iterator it = this.domainHandlers != null ? this.domainHandlers.iterator() : null;
        ArrayList<List> allDomainsAnnotations = new ArrayList<List>();
        while (it != null && it.hasNext()) {
            DomainHandler domainHandler = (DomainHandler)it.next();
            allDomainsAnnotations.add(domainHandler.getManagedAnnotations());
        }
        List coreAnnotationDefinitions = new JavaRoasterModelDriver().getConfiguredAnnotations();
        allDomainsAnnotations.add(coreAnnotationDefinitions);
        for (List annotationDefinitionList : allDomainsAnnotations) {
            if (annotationDefinitionList == null) continue;
            for (AnnotationDefinition annotationDefinition : annotationDefinitionList) {
                annotations.put(annotationDefinition.getClassName(), annotationDefinition);
            }
        }
        return annotations;
    }

    public Boolean exists(org.uberfire.backend.vfs.Path path) {
        return this.ioService.exists(Paths.convert((org.uberfire.backend.vfs.Path)path));
    }

    public AnnotationSourceResponse resolveSourceRequest(AnnotationSourceRequest sourceRequest) {
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        return modelDriver.resolveSourceRequest(sourceRequest);
    }

    public List<ValidationMessage> validateValuePair(String annotationClassName, ElementType target, String valuePairName, String literalValue) {
        ArrayList<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        Pair parseResult = modelDriver.parseAnnotationWithValuePair(annotationClassName, target, valuePairName, literalValue);
        if (parseResult.getK2() != null && ((List)parseResult.getK2()).size() > 0) {
            for (DriverError driverError : (List)parseResult.getK2()) {
                ValidationMessage validationMessage = new ValidationMessage();
                validationMessage.setText(driverError.getMessage());
                validationMessage.setColumn(driverError.getColumn());
                validationMessage.setLine(driverError.getLine());
                validationMessage.setLevel(Level.ERROR);
                validationMessages.add(validationMessage);
            }
        }
        return validationMessages;
    }

    public AnnotationParseResponse resolveParseRequest(AnnotationParseRequest parseRequest, KieProject kieProject) {
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        Pair driverResult = modelDriver.parseAnnotationWithValuePair(parseRequest.getAnnotationClassName(), parseRequest.getTarget(), parseRequest.getValuePairName(), parseRequest.getValuePairLiteralValue(), this.classLoaderHelper.getProjectClassLoader(kieProject));
        AnnotationParseResponse response = new AnnotationParseResponse((Annotation)driverResult.getK1());
        response.withErrors((List)driverResult.getK2());
        return response;
    }

    public AnnotationDefinitionResponse resolveDefinitionRequest(AnnotationDefinitionRequest definitionRequest, KieProject kieProject) {
        JavaRoasterModelDriver modelDriver = new JavaRoasterModelDriver();
        ClassLoader classLoader = this.classLoaderHelper.getProjectClassLoader(kieProject);
        ClassTypeResolver classTypeResolver = DriverUtils.createClassTypeResolver((ClassLoader)classLoader);
        AnnotationDefinitionResponse definitionResponse = new AnnotationDefinitionResponse();
        try {
            AnnotationDefinition annotationDefinition = modelDriver.buildAnnotationDefinition(definitionRequest.getClassName(), classTypeResolver);
            definitionResponse.withAnnotationDefinition(annotationDefinition);
        }
        catch (ModelDriverException e) {
            DriverError driverError = new DriverError(e.getMessage());
            definitionResponse.addError(driverError);
        }
        return definitionResponse;
    }

    private Path ensureProjectJavaPath(Path projectPath) {
        Path javaPath = projectPath.resolve("src");
        if (!this.ioService.exists(javaPath)) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        if (!this.ioService.exists(javaPath = javaPath.resolve("main"))) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        if (!this.ioService.exists(javaPath = javaPath.resolve("java"))) {
            javaPath = this.ioService.createDirectory(javaPath, new FileAttribute[0]);
        }
        return javaPath;
    }

    private String calculateClassName(Project project, org.uberfire.backend.vfs.Path path) {
        String rootPathURI = project.getRootPath().toURI();
        String pathURI = path.toURI();
        String strPath = null;
        if (!pathURI.startsWith(rootPathURI)) {
            return null;
        }
        if ((pathURI = pathURI.substring(rootPathURI.length() + 1, pathURI.length())).startsWith("src/main/java")) {
            strPath = pathURI.substring("src/main/java".length() + 1, pathURI.length());
        } else if (pathURI.startsWith("src/test/java")) {
            strPath = pathURI.substring("src/test/java".length() + 1, pathURI.length());
        }
        if (strPath == null) {
            return null;
        }
        strPath = strPath.replace("/", ".");
        strPath = strPath.substring(0, strPath.indexOf(".java"));
        return strPath;
    }

    private Path calculateFilePath(String className, Path javaPath) {
        String name = NamingUtils.extractClassName((String)className);
        String packageName = NamingUtils.extractPackageName((String)className);
        Path filePath = javaPath;
        if (packageName != null) {
            List<String> packageNameTokens = this.tokenizePackageName(packageName);
            for (String token : packageNameTokens) {
                filePath = filePath.resolve(token);
            }
        }
        filePath = filePath.resolve(name + ".java");
        return filePath;
    }

    public List<String> tokenizePackageName(String packageName) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (packageName != null) {
            StringTokenizer st = new StringTokenizer(packageName, ".");
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
        }
        return tokens;
    }
}

