/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleContentText;

public class DefaultRuleContentWidget
extends DirtyableComposite
implements EditorWidget {
    private TextArea text;
    private final RuleContentText data;

    public DefaultRuleContentWidget(Asset a, RuleViewer v, ClientFactory clientFactory, EventBus eventBus) {
        this(a);
    }

    public DefaultRuleContentWidget(Asset a) {
        this(a, -1);
    }

    public DefaultRuleContentWidget(Asset a, int visibleLines) {
        this.data = (RuleContentText)a.getContent();
        if (this.data.content == null) {
            this.data.content = "";
        }
        this.text = new TextArea();
        this.text.setWidth("100%");
        this.text.setVisibleLines(visibleLines == -1 ? 16 : visibleLines);
        this.text.setText(this.data.content);
        this.text.getElement().setAttribute("spellcheck", "false");
        this.text.setStyleName("default-text-Area");
        this.text.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                ((DefaultRuleContentWidget)DefaultRuleContentWidget.this).data.content = DefaultRuleContentWidget.this.text.getText();
                DefaultRuleContentWidget.this.makeDirty();
            }
        });
        this.text.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                if (event.getNativeKeyCode() == 9) {
                    int pos = DefaultRuleContentWidget.this.text.getCursorPos();
                    DefaultRuleContentWidget.this.insertText("\t");
                    DefaultRuleContentWidget.this.text.setCursorPos(pos + 1);
                    DefaultRuleContentWidget.this.text.cancelKey();
                    DefaultRuleContentWidget.this.text.setFocus(true);
                }
            }
        });
        this.initWidget((Widget)this.text);
    }

    public void insertText(String ins) {
        int i = this.text.getCursorPos();
        String left = this.text.getText().substring(0, i);
        String right = this.text.getText().substring(i, this.text.getText().length());
        this.text.setText(left + ins + right);
        this.data.content = this.text.getText();
    }
}

