/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.lang.descr.RuleDescr;
import org.drools.repository.utils.IOUtils;

public class ClassicDRLImporter {
    private String source;
    private String packageName;
    private static final Pattern functionPattern = Pattern.compile("function\\s+.*\\s+(.*)\\(.*\\).*");
    private static final Pattern declarationNamePattern = Pattern.compile("declare\\s+(\\w+)\\s*.*");
    private static final Pattern declarationCompletePattern = Pattern.compile("declare\\s+(\\w+).*\\s+end");
    private static final Pattern endPattern = Pattern.compile("\\s*end");
    private final List<Asset> declaredTypes = new ArrayList<Asset>();
    private final List<Asset> assets = new ArrayList<Asset>();
    private StringBuilder header;
    private boolean usesDSL;

    public ClassicDRLImporter(InputStream in) throws DroolsParserException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        try {
            String line;
            StringBuilder drl = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                drl.append("\n").append(line);
            }
            this.source = drl.toString();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read DRL inputStream.", e);
        }
        finally {
            IOUtils.closeQuietly((Reader)reader);
        }
        this.parse();
    }

    private void parse() throws DroolsParserException {
        StringTokenizer lines = new StringTokenizer(this.source, "\r\n");
        this.header = new StringBuilder();
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.startsWith("package")) {
                this.packageName = this.getPackage(line);
                continue;
            }
            if (line.startsWith("rule")) {
                String ruleName = ClassicDRLImporter.getRuleName(line);
                StringBuilder currentRule = new StringBuilder();
                this.laConsumeToEnd(lines, currentRule, "end", false);
                this.addRule(ruleName, currentRule);
                continue;
            }
            if (line.startsWith("function")) {
                String functionName = this.getFuncName(line);
                StringBuilder currentFunc = new StringBuilder();
                int counter = 0;
                currentFunc.append(line).append("\n");
                counter = this.countBrackets(counter, line);
                if (counter > 0) {
                    this.laConsumeBracketsToEnd(counter, lines, currentFunc);
                }
                this.addFunction(functionName, currentFunc);
                continue;
            }
            if (line.startsWith("declare")) {
                String declarationName = this.getDeclarationName(line);
                StringBuilder currentDeclaration = new StringBuilder();
                currentDeclaration.append(line).append("\n");
                if (!this.isDeclarationComplete(line)) {
                    this.laConsumeDeclarationToEnd(lines, currentDeclaration);
                }
                this.addDeclaredModel(declarationName, currentDeclaration);
                continue;
            }
            if (line.startsWith("/*")) {
                StringBuilder comment = new StringBuilder();
                comment.append(line).append("\n");
                this.laConsumeToEnd(lines, comment, "*/", true);
                this.header.append((CharSequence)comment);
                continue;
            }
            if (line.startsWith("expander")) {
                this.usesDSL = true;
                continue;
            }
            this.header.append(line);
            this.header.append("\n");
        }
        this.addDeclaredModels();
    }

    private void addFunction(String functionName, StringBuilder currentFunc) {
        this.assets.add(new Asset(functionName, currentFunc.toString(), "function"));
    }

    private void addDeclaredModel(String declarationName, StringBuilder currentDeclaration) {
        this.declaredTypes.add(new Asset(declarationName, currentDeclaration.toString(), "model.drl"));
    }

    private void addDeclaredModels() {
        StringBuilder types = new StringBuilder();
        if (this.declaredTypes.size() > 0) {
            for (Asset declaredType : this.declaredTypes) {
                types.append(declaredType.content);
            }
            this.assets.add(new Asset("model", types.toString(), "model.drl"));
        }
    }

    private String getFuncName(String line) {
        Matcher m = functionPattern.matcher(line);
        m.matches();
        return m.group(1);
    }

    private String getDeclarationName(String line) {
        Matcher m = declarationNamePattern.matcher(line);
        m.matches();
        return m.group(1);
    }

    private boolean isDeclarationComplete(String line) {
        Matcher m = declarationCompletePattern.matcher(line);
        return m.matches();
    }

    private boolean isEnd(String line) {
        Matcher m = endPattern.matcher(line);
        return m.matches();
    }

    private void laConsumeBracketsToEnd(int counter, StringTokenizer lines, StringBuilder currentFunc) {
        boolean multilineIsOpen = false;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            currentFunc.append(line);
            currentFunc.append("\n");
            if (multilineIsOpen) {
                int commentEnd = line.indexOf("*/");
                if (commentEnd != -1) {
                    multilineIsOpen = false;
                    line = line.substring(commentEnd);
                }
            } else {
                multilineIsOpen = this.checkIfMultilineCommentStarts(line);
                line = this.removeComments(line);
            }
            if (!multilineIsOpen) {
                counter = this.countBrackets(counter, line);
            }
            if (counter != 0) continue;
            break;
        }
    }

    private void laConsumeDeclarationToEnd(StringTokenizer lines, StringBuilder currentDeclaration) {
        boolean multilineIsOpen = false;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            currentDeclaration.append(this.removeComments(line));
            currentDeclaration.append("\n");
            if (multilineIsOpen) {
                int commentEnd = line.indexOf("*/");
                if (commentEnd != -1) {
                    multilineIsOpen = false;
                    line = line.substring(commentEnd);
                }
            } else {
                multilineIsOpen = this.checkIfMultilineCommentStarts(line);
                line = this.removeComments(line);
            }
            if (!this.isEnd(line)) continue;
            break;
        }
    }

    private boolean checkIfMultilineCommentStarts(String line) {
        int commentMultiLineStart = line.indexOf("/*");
        int commentMultiLineEnd = line.indexOf("*/");
        return commentMultiLineStart != -1 && commentMultiLineEnd == -1;
    }

    private int countBrackets(int counter, String line) {
        char[] chars;
        for (char aChar : chars = line.toCharArray()) {
            if (aChar == '{') {
                ++counter;
                continue;
            }
            if (aChar != '}') continue;
            --counter;
        }
        return counter;
    }

    private String removeComments(String line) {
        int commentMultiLineStart = line.indexOf("/*");
        int commentMultiLineEnd = line.indexOf("*/");
        int commentSingleLine = line.indexOf("//");
        if (commentSingleLine != -1 && commentMultiLineStart > commentSingleLine) {
            return line.substring(0, commentSingleLine);
        }
        if (commentMultiLineStart != -1 && commentMultiLineEnd == -1) {
            return line.substring(0, commentMultiLineStart);
        }
        if (commentMultiLineStart != -1 && commentMultiLineEnd != -1) {
            line = line.substring(0, commentMultiLineStart) + line.substring(commentMultiLineEnd + "*/".length());
            return line;
        }
        return line;
    }

    private void laConsumeToEnd(StringTokenizer lines, StringBuilder currentRule, String end, boolean addLastLine) {
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.trim().startsWith(end)) {
                if (!addLastLine) break;
                currentRule.append(line).append("\n");
                break;
            }
            currentRule.append(line);
            currentRule.append("\n");
        }
    }

    private void addRule(String ruleName, StringBuilder currentRule) {
        ruleName = ruleName.replace('\'', ' ');
        if (this.isDSLEnabled()) {
            this.assets.add(new Asset(ruleName, currentRule.toString(), "dslr"));
        } else {
            this.assets.add(new Asset(ruleName, currentRule.toString(), "drl"));
        }
    }

    public static String getRuleName(String line) throws DroolsParserException {
        DrlParser parser = new DrlParser();
        line = line + "\n when\n then \n end";
        RuleDescr rule = (RuleDescr)parser.parse(line).getRules().get(0);
        return rule.getName();
    }

    private String getPackage(String line) throws DroolsParserException {
        DrlParser parser = new DrlParser();
        return parser.parse(line).getName();
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageHeader() {
        return this.header.toString();
    }

    public boolean isDSLEnabled() {
        return this.usesDSL;
    }

    public static String mergeLines(String existing, String toMerge) {
        String[] newLines;
        if (toMerge == null || toMerge.equals("")) {
            return existing;
        }
        if (existing == null || existing.equals("")) {
            return toMerge;
        }
        HashSet<String> existingLines = new HashSet<String>(Arrays.asList(existing.split("\n")));
        for (String newLine1 : newLines = toMerge.split("\n")) {
            String newLine = newLine1.trim();
            if (newLine.equals("") || existingLines.contains(newLine1.trim())) continue;
            existing = existing + "\n" + newLine1;
        }
        return existing;
    }

    public static class Asset {
        public final String format;
        public final String name;
        public final String content;

        public Asset(String name, String content, String format) {
            this.name = name;
            this.content = content;
            this.format = format;
        }
    }
}

