/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.repository.RulesRepositoryException;

public class MetaDataMapper {
    private static final MetaDataMapper instance = new MetaDataMapper();
    private final Map writeMappingsForClass = new HashMap();
    private final Map readMappipngsForClass = new HashMap();

    private MetaDataMapper() {
    }

    public static MetaDataMapper getInstance() {
        return instance;
    }

    public void copyFromMetaData(MetaData data, Object target) {
        Map writeMappings = this.getWriteMappings(data, target);
        Iterator i$ = writeMappings.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = i$.next();
            Field f = (Field)e.getKey();
            Method m = (Method)e.getValue();
            try {
                m.invoke(target, f.get(data));
            }
            catch (IllegalArgumentException e1) {
                throw new RulesRepositoryException((Throwable)e1);
            }
            catch (IllegalAccessException e1) {
                throw new RulesRepositoryException((Throwable)e1);
            }
            catch (InvocationTargetException e1) {
                throw new RulesRepositoryException((Throwable)e1);
            }
        }
    }

    private Map getWriteMappings(MetaData data, Object target) {
        if (!this.writeMappingsForClass.containsKey(target.getClass())) {
            Map writeMappings = this.loadWriteMappings(data, target.getClass());
            this.writeMappingsForClass.put(target.getClass(), writeMappings);
        }
        return (Map)this.writeMappingsForClass.get(target.getClass());
    }

    private Map loadWriteMappings(MetaData data, Class bean) {
        Field[] fields;
        HashMap<Field, Method> mappings = new HashMap<Field, Method>();
        for (Field f : fields = data.getClass().getFields()) {
            String old = f.getName();
            String name = Character.toUpperCase(old.charAt(0)) + old.substring(1);
            name = "update" + name;
            try {
                Method m = bean.getMethod(name, f.getType());
                mappings.put(f, m);
            }
            catch (SecurityException e) {
                throw new RulesRepositoryException("Unable to map meta data", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return mappings;
    }

    public void copyToMetaData(MetaData data, Object source) {
        Map readMappings = this.getReadMappings(data, source);
        Iterator i$ = readMappings.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = i$.next();
            Field f = (Field)e.getKey();
            Method m = (Method)e.getValue();
            try {
                f.set(data, m.invoke(source, null));
            }
            catch (IllegalArgumentException e1) {
                throw new RulesRepositoryException((Throwable)e1);
            }
            catch (IllegalAccessException e1) {
                throw new RulesRepositoryException((Throwable)e1);
            }
            catch (InvocationTargetException e1) {
                throw new RulesRepositoryException((Throwable)e1);
            }
        }
    }

    private Map getReadMappings(MetaData data, Object source) {
        if (!this.readMappipngsForClass.containsKey(source.getClass())) {
            this.readMappipngsForClass.put(source.getClass(), this.loadReadMappings(data, source.getClass()));
        }
        return (Map)this.readMappipngsForClass.get(source.getClass());
    }

    private Map loadReadMappings(MetaData data, Class bean) {
        Field[] fields;
        HashMap<Field, Method> mappings = new HashMap<Field, Method>();
        for (Field f : fields = data.getClass().getFields()) {
            String old = f.getName();
            String name = Character.toUpperCase(old.charAt(0)) + old.substring(1);
            name = f.getType() == Boolean.class ? "is" + name : "get" + name;
            try {
                Method m = bean.getMethod(name, null);
                if (f.getType() != m.getReturnType()) continue;
                mappings.put(f, m);
            }
            catch (SecurityException e) {
                throw new RulesRepositoryException("Unable to map meta data", (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        return mappings;
    }
}

