/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl.templates;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.shared.api.PortableObject;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.templates.InterpolationVariable;
import org.drools.ide.common.client.modeldriven.brl.templates.RuleModelVisitor;

public class TemplateModel
extends RuleModel
implements PortableObject {
    public static final String ID_COLUMN_NAME = "__ID_KOL_NAME__";
    private long idCol = 0L;
    private Map<String, List<String>> table = new HashMap<String, List<String>>();
    private int rowsCount = 0;

    public String addRow(String rowId, String[] row) {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        if (row.length != vars.size() - 1) {
            throw new IllegalArgumentException("Invalid numbers of columns: " + row.length + " expected: " + vars.size());
        }
        if (rowId == null || rowId.length() == 0) {
            rowId = this.getNewIdColValue();
        }
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            List<String> list = this.table.get(entry.getKey().getVarName());
            if (list == null) {
                list = new ArrayList<String>();
                this.table.put(entry.getKey().getVarName(), list);
            }
            if (this.rowsCount != list.size()) {
                throw new IllegalArgumentException("invalid list size for " + entry.getKey() + ", expected: " + this.rowsCount + " was: " + list.size());
            }
            if (ID_COLUMN_NAME.equals(entry.getKey().getVarName())) {
                list.add(rowId);
                continue;
            }
            list.add(row[entry.getValue()]);
        }
        ++this.rowsCount;
        return rowId;
    }

    public String addRow(int index, String[] row) {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        if (row.length != vars.size() - 1) {
            throw new IllegalArgumentException("Invalid numbers of columns: " + row.length + " expected: " + vars.size());
        }
        String rowId = this.getNewIdColValue();
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            List<String> list = this.table.get(entry.getKey().getVarName());
            if (list == null) {
                list = new ArrayList<String>();
                this.table.put(entry.getKey().getVarName(), list);
            }
            if (this.rowsCount != list.size()) {
                throw new IllegalArgumentException("invalid list size for " + entry.getKey() + ", expected: " + this.rowsCount + " was: " + list.size());
            }
            if (ID_COLUMN_NAME.equals(entry.getKey().getVarName())) {
                list.add(index, rowId);
                continue;
            }
            list.add(index, row[entry.getValue()]);
        }
        ++this.rowsCount;
        return rowId;
    }

    public String addRow(String[] row) {
        return this.addRow(null, row);
    }

    public void clearRows() {
        if (this.rowsCount > 0) {
            for (List<String> col : this.table.values()) {
                col.clear();
            }
            this.rowsCount = 0;
        }
    }

    public int getColsCount() {
        return this.getInterpolationVariables().size() - 1;
    }

    private Map<InterpolationVariable, Integer> getInterpolationVariables() {
        HashMap<InterpolationVariable, Integer> result = new HashMap<InterpolationVariable, Integer>();
        new RuleModelVisitor(result).visit(this);
        InterpolationVariable id = new InterpolationVariable(ID_COLUMN_NAME, "Long");
        result.put(id, result.size());
        return result;
    }

    public InterpolationVariable[] getInterpolationVariablesList() {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        InterpolationVariable[] ret = new InterpolationVariable[vars.size() - 1];
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            if (ID_COLUMN_NAME.equals(entry.getKey().getVarName())) continue;
            ret[entry.getValue().intValue()] = entry.getKey();
        }
        return ret;
    }

    private String getNewIdColValue() {
        ++this.idCol;
        return String.valueOf(this.idCol);
    }

    public int getRowsCount() {
        return this.rowsCount;
    }

    public Map<String, List<String>> getTable() {
        return this.table;
    }

    public String[][] getTableAsArray() {
        if (this.rowsCount <= 0) {
            return new String[0][0];
        }
        this.putInSync();
        String[][] ret = new String[this.rowsCount][this.table.size() - 1];
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        for (Map.Entry<InterpolationVariable, Integer> entry : vars.entrySet()) {
            InterpolationVariable var = entry.getKey();
            String varName = var.getVarName();
            if (ID_COLUMN_NAME.equals(varName)) continue;
            int idx = entry.getValue();
            for (int row = 0; row < this.rowsCount; ++row) {
                ret[row][idx] = this.table.get(varName).get(row);
            }
        }
        return ret;
    }

    public void putInSync() {
        Map<InterpolationVariable, Integer> vars = this.getInterpolationVariables();
        HashSet<String> requiredVars = new HashSet<String>();
        for (InterpolationVariable var : vars.keySet()) {
            if (!this.table.containsKey(var.getVarName())) continue;
            requiredVars.add(var.getVarName());
        }
        this.table.keySet().retainAll(requiredVars);
        ArrayList<String> aux = new ArrayList<String>(this.rowsCount);
        for (int i = 0; i < this.rowsCount; ++i) {
            aux.add("");
        }
        for (InterpolationVariable var : vars.keySet()) {
            if (requiredVars.contains(var.getVarName())) continue;
            this.table.put(var.getVarName(), new ArrayList(aux));
        }
    }

    public void removeRow(int row) {
        if (row >= 0 && row < this.rowsCount) {
            for (List<String> col : this.table.values()) {
                col.remove(row);
            }
            --this.rowsCount;
        } else {
            throw new ArrayIndexOutOfBoundsException(row);
        }
    }

    public boolean removeRowById(String rowId) {
        int idx = this.table.get(ID_COLUMN_NAME).indexOf(rowId);
        if (idx != -1) {
            for (List<String> col : this.table.values()) {
                col.remove(idx);
            }
            --this.rowsCount;
        }
        return idx != -1;
    }

    public void setValue(String varName, int rowIndex, String newValue) {
        this.getTable().get(varName).set(rowIndex, newValue);
    }
}

