/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.config.xml.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.solder.config.xml.model.AbstractXmlItem;
import org.jboss.solder.config.xml.model.ParameterXmlItem;
import org.jboss.solder.config.xml.model.ParametersXmlItem;
import org.jboss.solder.config.xml.model.XmlItem;
import org.jboss.solder.config.xml.model.XmlItemType;
import org.jboss.solder.config.xml.util.TypeOccuranceInformation;
import org.jboss.solder.config.xml.util.XmlConfigurationException;

public class MethodXmlItem
extends AbstractXmlItem {
    private String methodName;
    Method method;
    HashSet<TypeOccuranceInformation> allowed = new HashSet();

    public MethodXmlItem(XmlItem parent, String methodName, String document, int lineno) {
        super(XmlItemType.METHOD, parent, parent.getJavaClass(), null, null, document, lineno);
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.ANNOTATION, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.PARAMETERS, null, 1));
        this.methodName = methodName;
        Method found = null;
        for (Method m : this.javaClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            if (found == null) {
                found = m;
                continue;
            }
            return;
        }
        this.method = found;
    }

    @Override
    public boolean resolveChildren(BeanManager manager) {
        if (this.method != null) {
            return true;
        }
        ArrayList rtList = new ArrayList();
        List<ParametersXmlItem> parameters = this.getChildrenOfType(ParametersXmlItem.class);
        if (parameters.size() > 1) {
            throw new XmlConfigurationException("A method may only have a single <parameters> element", this.document, this.lineno);
        }
        if (!parameters.isEmpty()) {
            for (ParameterXmlItem c : parameters.get(0).getChildrenOfType(ParameterXmlItem.class)) {
                Class<?> cl = c.getJavaClass();
                rtList.add(cl);
            }
        }
        Class[] alAr = new Class[rtList.size()];
        for (int i = 0; i < rtList.size(); ++i) {
            alAr[i] = (Class)rtList.get(i);
        }
        try {
            this.method = this.javaClass.getMethod(this.methodName, alAr);
            return true;
        }
        catch (SecurityException e) {
            throw new XmlConfigurationException("Security Exception resolving method " + this.methodName + " on class " + this.javaClass.getName(), this.getDocument(), this.getLineno());
        }
        catch (NoSuchMethodException e) {
            throw new XmlConfigurationException("NoSuchMethodException resolving method " + this.methodName + " on class " + this.javaClass.getName(), this.getDocument(), this.getLineno());
        }
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public Set<TypeOccuranceInformation> getAllowedItem() {
        return this.allowed;
    }
}

