/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.metadata;

import java.util.Collections;
import java.util.Map;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.system.DefaultFactories;
import org.apache.sis.internal.system.OptionalDependency;
import org.apache.sis.io.wkt.FormattableObject;
import org.apache.sis.metadata.iso.extent.DefaultExtent;
import org.apache.sis.metadata.iso.extent.DefaultGeographicBoundingBox;
import org.apache.sis.metadata.iso.extent.DefaultSpatialTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultTemporalExtent;
import org.apache.sis.metadata.iso.extent.DefaultVerticalExtent;
import org.apache.sis.util.Deprecable;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.opengis.util.NoSuchIdentifierException;

public class ReferencingServices
extends OptionalDependency {
    public static final double NAUTICAL_MILE = 1852.0;
    public static final double AUTHALIC_RADIUS = 6371007.0;
    public static final String BURSA_WOLF_KEY = "bursaWolf";
    public static final String PARAMETERS_KEY = "parameters";
    public static final String OPERATION_TYPE_KEY = "operationType";
    public static final String MT_FACTORY = "mtFactory";
    private static final char IDENTIFIER_SEPARATOR = ':';
    private static volatile ReferencingServices instance;

    protected ReferencingServices() {
        super("org.apache.sis.metadata", "sis-referencing");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void classpathChanged() {
        Class<ReferencingServices> clazz = ReferencingServices.class;
        synchronized (ReferencingServices.class) {
            super.classpathChanged();
            instance = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ReferencingServices getInstance() {
        ReferencingServices referencingServices = instance;
        if (referencingServices != null) return referencingServices;
        Class<ReferencingServices> clazz = ReferencingServices.class;
        synchronized (ReferencingServices.class) {
            referencingServices = instance;
            if (referencingServices != null) return referencingServices;
            referencingServices = ReferencingServices.getInstance(ReferencingServices.class, "org.apache.sis.metadata", "sis-referencing", "org.apache.sis.internal.referencing.ServicesForMetadata");
            if (referencingServices == null) {
                referencingServices = new ReferencingServices();
            }
            instance = referencingServices;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return referencingServices;
        }
    }

    public void setBounds(Envelope envelope, DefaultGeographicBoundingBox defaultGeographicBoundingBox) throws TransformException {
        throw this.moduleNotFound();
    }

    public void setBounds(Envelope envelope, DefaultVerticalExtent defaultVerticalExtent) throws TransformException {
        throw this.moduleNotFound();
    }

    public void setBounds(Envelope envelope, DefaultTemporalExtent defaultTemporalExtent) throws TransformException {
        throw this.moduleNotFound();
    }

    public void setBounds(Envelope envelope, DefaultSpatialTemporalExtent defaultSpatialTemporalExtent) throws TransformException {
        throw this.moduleNotFound();
    }

    public void addElements(Envelope envelope, DefaultExtent defaultExtent) throws TransformException {
        throw this.moduleNotFound();
    }

    public ParameterDescriptor<?> toImplementation(ParameterDescriptor<?> parameterDescriptor) {
        throw this.moduleNotFound();
    }

    public FormattableObject toFormattableObject(IdentifiedObject identifiedObject) {
        throw this.moduleNotFound();
    }

    public FormattableObject toFormattableObject(MathTransform mathTransform, boolean bl) {
        throw this.moduleNotFound();
    }

    public VerticalCRS getMSLH() {
        throw this.moduleNotFound();
    }

    public PrimeMeridian getGreenwich() {
        throw this.moduleNotFound();
    }

    public CartesianCS getGeocentricCS(Unit<Length> unit) {
        throw this.moduleNotFound();
    }

    public CartesianCS upgradeGeocentricCS(CartesianCS cartesianCS) {
        return cartesianCS;
    }

    public CoordinateSystem createAbstractCS(Map<String, ?> map, CoordinateSystemAxis[] coordinateSystemAxisArray) {
        throw this.moduleNotFound();
    }

    public DerivedCRS createDerivedCRS(Map<String, ?> map, SingleCRS singleCRS, OperationMethod operationMethod, MathTransform mathTransform, CoordinateSystem coordinateSystem) {
        throw this.moduleNotFound();
    }

    public AxisDirection directionAlongMeridian(AxisDirection axisDirection, double d) {
        throw this.moduleNotFound();
    }

    public Object createToWGS84(double[] dArray) {
        return null;
    }

    public SingleOperation createSingleOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, CoordinateReferenceSystem coordinateReferenceSystem3, OperationMethod operationMethod, CoordinateOperationFactory coordinateOperationFactory) throws FactoryException {
        throw this.moduleNotFound();
    }

    public CoordinateOperationFactory getCoordinateOperationFactory(Map<String, ?> map, MathTransformFactory mathTransformFactory) {
        CoordinateOperationFactory coordinateOperationFactory = DefaultFactories.forClass(CoordinateOperationFactory.class);
        if (coordinateOperationFactory != null) {
            return coordinateOperationFactory;
        }
        throw this.moduleNotFound();
    }

    public Map<String, ?> getProperties(IdentifiedObject identifiedObject) {
        return Collections.singletonMap("name", identifiedObject.getName());
    }

    public boolean isHeuristicMatchForName(IdentifiedObject identifiedObject, String string) {
        return NameToIdentifier.isHeuristicMatchForName(identifiedObject.getName(), identifiedObject.getAlias(), string);
    }

    private boolean matches(OperationMethod operationMethod, String string) {
        if (this.isHeuristicMatchForName(operationMethod, string)) {
            return true;
        }
        int n = string.indexOf(58);
        while (n >= 0) {
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(++n).trim();
            for (ReferenceIdentifier referenceIdentifier : operationMethod.getIdentifiers()) {
                if (!string2.equalsIgnoreCase(referenceIdentifier.getCodeSpace()) || !string3.equalsIgnoreCase(referenceIdentifier.getCode())) continue;
                return true;
            }
            n = string.indexOf(58, n);
        }
        return false;
    }

    public final OperationMethod getOperationMethod(Iterable<? extends OperationMethod> iterable, String string) {
        OperationMethod operationMethod = null;
        for (OperationMethod operationMethod2 : iterable) {
            if (!this.matches(operationMethod2, string)) continue;
            if (!(operationMethod2 instanceof Deprecable) || !((Deprecable)((Object)operationMethod2)).isDeprecated()) {
                return operationMethod2;
            }
            if (operationMethod != null) continue;
            operationMethod = operationMethod2;
        }
        return operationMethod;
    }

    public OperationMethod getOperationMethod(CoordinateOperationFactory coordinateOperationFactory, MathTransformFactory mathTransformFactory, String string) throws FactoryException {
        OperationMethod operationMethod = this.getOperationMethod(mathTransformFactory.getAvailableMethods(SingleOperation.class), string);
        if (operationMethod != null) {
            return operationMethod;
        }
        throw new NoSuchIdentifierException(Errors.format((short)179, string), string);
    }
}

