/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import org.apache.sis.internal.util.Numerics;
import org.apache.sis.measure.Range;
import org.apache.sis.measure.ValueRange;
import org.apache.sis.util.Numbers;
import org.apache.sis.util.collection.WeakHashSet;
import org.apache.sis.util.resources.Errors;

public class NumberRange<E extends Number>
extends Range<E> {
    private static final long serialVersionUID = -3198281191274903617L;
    private static final WeakHashSet<NumberRange<?>> POOL = new WeakHashSet<NumberRange>(NumberRange.class);

    static <E extends Number, T extends NumberRange<E>> T unique(T t) {
        return POOL.unique(t);
    }

    public static NumberRange<Byte> create(byte by, boolean bl, byte by2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Byte>(Byte.class, by, bl, by2, bl2));
    }

    public static NumberRange<Short> create(short s, boolean bl, short s2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Short>(Short.class, s, bl, s2, bl2));
    }

    public static NumberRange<Integer> create(int n, boolean bl, int n2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Integer>(Integer.class, n, bl, n2, bl2));
    }

    public static NumberRange<Long> create(long l, boolean bl, long l2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Long>(Long.class, l, bl, l2, bl2));
    }

    public static NumberRange<Float> create(float f, boolean bl, float f2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Float>(Float.class, NumberRange.valueOf("minValue", f, Float.NEGATIVE_INFINITY), bl, NumberRange.valueOf("maxValue", f2, Float.POSITIVE_INFINITY), bl2));
    }

    static Float valueOf(String string, float f, float f2) {
        if (Float.isNaN(f)) {
            throw new IllegalArgumentException(Errors.format((short)89, string));
        }
        return f != f2 ? Float.valueOf(f) : null;
    }

    public static NumberRange<Double> create(double d, boolean bl, double d2, boolean bl2) {
        return NumberRange.unique(new NumberRange<Double>(Double.class, NumberRange.valueOf("minValue", d, Double.NEGATIVE_INFINITY), bl, NumberRange.valueOf("maxValue", d2, Double.POSITIVE_INFINITY), bl2));
    }

    static Double valueOf(String string, double d, double d2) {
        if (Double.isNaN(d)) {
            throw new IllegalArgumentException(Errors.format((short)89, string));
        }
        return d != d2 ? Numerics.valueOf(d) : null;
    }

    public static NumberRange<Integer> createLeftBounded(int n, boolean bl) {
        return NumberRange.unique(new NumberRange<Object>((Class<Object>)Integer.class, n, bl, null, false));
    }

    public static NumberRange<?> createBestFit(Number number, boolean bl, Number number2, boolean bl2) {
        Class<? extends Number> clazz = Numbers.widestClass(Numbers.narrowestClass(number), Numbers.narrowestClass(number2));
        return clazz == null ? null : NumberRange.unique(new NumberRange<Number>(clazz, Numbers.cast(number, clazz), bl, Numbers.cast(number2, clazz), bl2));
    }

    public static <N extends Number> NumberRange<N> castOrCopy(Range<N> range) {
        if (range instanceof NumberRange) {
            return (NumberRange)range;
        }
        return new NumberRange<N>(range);
    }

    public NumberRange(Range<E> range) {
        super(range);
    }

    public NumberRange(Class<E> clazz, ValueRange valueRange) throws IllegalArgumentException {
        super(clazz, (Comparable)Numbers.cast(NumberRange.valueOf("minimum", valueRange.minimum(), Double.NEGATIVE_INFINITY), clazz), valueRange.isMinIncluded(), (Comparable)Numbers.cast(NumberRange.valueOf("maximum", valueRange.maximum(), Double.POSITIVE_INFINITY), clazz), valueRange.isMaxIncluded());
    }

    public NumberRange(Class<E> clazz, E e, boolean bl, E e2, boolean bl2) {
        super(clazz, (Comparable)e, bl, (Comparable)e2, bl2);
    }

    NumberRange(Class<E> clazz, Range<? extends Number> range) throws IllegalArgumentException {
        super(clazz, (Comparable)Numbers.cast((Number)range.minValue, clazz), range.isMinIncluded, (Comparable)Numbers.cast((Number)range.maxValue, clazz), range.isMaxIncluded);
    }

    @Override
    Range<E> create(E e, boolean bl, E e2, boolean bl2) {
        return new NumberRange<E>(this.elementType, e, bl, e2, bl2);
    }

    <N extends Number> NumberRange<N> convertAndCast(NumberRange<?> numberRange, Class<N> clazz) throws IllegalArgumentException {
        if (numberRange.elementType == clazz) {
            return numberRange;
        }
        return new NumberRange<N>(clazz, numberRange);
    }

    public <N extends Number> NumberRange<N> castTo(Class<N> clazz) throws IllegalArgumentException {
        if (this.elementType == clazz) {
            return this;
        }
        return new NumberRange<N>(clazz, this);
    }

    @Override
    Range<E>[] newArray(int n) {
        return new NumberRange[n];
    }

    public double getMinDouble() {
        Number number = (Number)this.getMinValue();
        return number != null ? number.doubleValue() : Double.NEGATIVE_INFINITY;
    }

    public double getMinDouble(boolean bl) {
        double d = this.getMinDouble();
        if (bl != this.isMinIncluded()) {
            d = NumberRange.next(this.getElementType(), d, bl);
        }
        return d;
    }

    public double getMaxDouble() {
        Number number = (Number)this.getMaxValue();
        return number != null ? number.doubleValue() : Double.POSITIVE_INFINITY;
    }

    public double getMaxDouble(boolean bl) {
        double d = this.getMaxDouble();
        if (bl != this.isMaxIncluded()) {
            d = NumberRange.next(this.getElementType(), d, !bl);
        }
        return d;
    }

    private static double next(Class<?> clazz, double d, boolean bl) {
        if (!bl) {
            d = -d;
        }
        if (Numbers.isInteger(clazz)) {
            d += 1.0;
        } else if (clazz.equals(Float.class)) {
            d = Math.nextUp((float)d);
        } else if (clazz.equals(Double.class)) {
            d = Math.nextUp(d);
        } else {
            throw new IllegalStateException(Errors.format((short)90, clazz));
        }
        if (!bl) {
            d = -d;
        }
        return d;
    }

    public boolean containsAny(Number number) throws IllegalArgumentException {
        int n;
        if (number == null) {
            return false;
        }
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, number.getClass());
        number = Numbers.cast(number, clazz);
        if (this.minValue != null) {
            n = ((Comparable)((Object)Numbers.cast((Number)((Object)this.minValue), clazz))).compareTo(number);
            if (this.isMinIncluded ? n > 0 : n >= 0) {
                return false;
            }
        }
        if (this.maxValue != null) {
            n = ((Comparable)((Object)Numbers.cast((Number)((Object)this.maxValue), clazz))).compareTo(number);
            if (this.isMaxIncluded ? n < 0 : n <= 0) {
                return false;
            }
        }
        return true;
    }

    public boolean containsAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return this.castTo(clazz).contains(this.convertAndCast(numberRange, clazz));
    }

    public boolean intersectsAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return this.castTo(clazz).intersects(this.convertAndCast(numberRange, clazz));
    }

    public NumberRange<?> intersectAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        NumberRange<? extends Number> numberRange2 = NumberRange.castOrCopy(this.castTo(clazz).intersect(this.convertAndCast(numberRange, clazz)));
        clazz = Numbers.narrowestClass(this.elementType, numberRange.elementType);
        clazz = Numbers.widestClass(clazz, Numbers.narrowestClass((Number)((Object)numberRange2.minValue)));
        clazz = Numbers.widestClass(clazz, Numbers.narrowestClass((Number)((Object)numberRange2.maxValue)));
        return numberRange2.castTo(clazz);
    }

    public NumberRange<?> unionAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return NumberRange.castOrCopy(this.castTo(clazz).union(this.convertAndCast(numberRange, clazz)));
    }

    public NumberRange<?>[] subtractAny(NumberRange<?> numberRange) throws IllegalArgumentException {
        Class<? extends Number> clazz = Numbers.widestClass(this.elementType, numberRange.elementType);
        return (NumberRange[])this.castTo(clazz).subtract(this.convertAndCast(numberRange, clazz));
    }
}

