/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.springcontext;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import org.drools.guvnor.client.asseteditor.drools.springcontext.SpringContextElementSelectedListener;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.ErrorPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.guvnor.client.rpc.RepositoryService;
import org.drools.guvnor.client.rpc.RepositoryServiceAsync;
import org.drools.guvnor.client.rpc.SnapshotInfo;

public class SpringContextElementsBrowser
extends Composite {
    private Map<String, String> springContextElements;
    private SpringContextElementSelectedListener elementSelectedItem;
    private final VerticalPanel mainPanel = new VerticalPanel();

    public SpringContextElementsBrowser(SpringContextElementSelectedListener elementSelectedItem) {
        this.elementSelectedItem = elementSelectedItem;
        RepositoryServiceAsync repositoryService = (RepositoryServiceAsync)GWT.create(RepositoryService.class);
        repositoryService.loadSpringContextElementData((AsyncCallback)new AsyncCallback<Map<String, String>>(){

            public void onFailure(Throwable caught) {
            }

            public void onSuccess(Map<String, String> result) {
                SpringContextElementsBrowser.this.springContextElements = result;
                SpringContextElementsBrowser.this.doLayout();
            }
        });
        this.initWidget((Widget)this.mainPanel);
    }

    private void doLayout() {
        this.mainPanel.add((Widget)new HTML("<b>Palette</b>"));
        for (Map.Entry<String, String> entry : this.springContextElements.entrySet()) {
            this.mainPanel.add((Widget)new PanelButton(entry.getKey(), entry.getValue()));
        }
        Tree resourcesTree = new Tree();
        this.mainPanel.add((Widget)resourcesTree);
        final TreeItem rootItem = new TreeItem(Constants.INSTANCE.Packages());
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.loadGlobalModule((AsyncCallback)new AsyncCallback<Module>(){

            public void onFailure(Throwable caught) {
                ErrorPopup.showMessage((String)"Error listing Global Area information!");
            }

            public void onSuccess(Module result) {
                SpringContextElementsBrowser.this.populatePackageTree(result, rootItem);
            }
        });
        moduleService.listModules((AsyncCallback)new AsyncCallback<Module[]>(){

            public void onFailure(Throwable caught) {
                ErrorPopup.showMessage((String)"Error listing package information!");
            }

            public void onSuccess(Module[] result) {
                for (int i = 0; i < result.length; ++i) {
                    Module packageConfigData = result[i];
                    SpringContextElementsBrowser.this.populatePackageTree(packageConfigData, rootItem);
                }
            }
        });
        resourcesTree.addItem(rootItem);
        resourcesTree.setStyleName("category-explorer-Tree");
        resourcesTree.addSelectionHandler((SelectionHandler)new SelectionHandler<TreeItem>(){

            public void onSelection(SelectionEvent<TreeItem> event) {
                Object o = ((TreeItem)event.getSelectedItem()).getUserObject();
                if (o instanceof String) {
                    // empty if block
                }
            }
        });
        ScrollPanel scrollPanel = new ScrollPanel((Widget)resourcesTree);
        scrollPanel.setHeight("150px");
        scrollPanel.setWidth("130px");
        this.mainPanel.add((Widget)scrollPanel);
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainPanel.setSpacing(10);
    }

    private void populatePackageTree(final Module packageConfigData, TreeItem rootItem) {
        String resourceElement = "<drools:resource type=\"PKG\" source=\"{url}\" basicAuthentication='enabled' username='|' password=''/>";
        final TreeItem packageItem = new TreeItem(packageConfigData.getName());
        TreeItem leafItem = new TreeItem((Widget)new ClickableLabel("LATEST", (ClickHandler)new LeafClickHandler(packageConfigData.getName(), "<drools:resource type=\"PKG\" source=\"{url}\" basicAuthentication='enabled' username='|' password=''/>".replace("{url}", PackageBuilderWidget.getDownloadLink(packageConfigData)))));
        packageItem.addItem(leafItem);
        ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
        moduleService.listSnapshots(packageConfigData.getName(), (AsyncCallback)new AsyncCallback<SnapshotInfo[]>(){

            public void onFailure(Throwable caught) {
                ErrorPopup.showMessage((String)"Error listing snapshots information!");
            }

            public void onSuccess(SnapshotInfo[] result) {
                for (int j = 0; j < result.length; ++j) {
                    final SnapshotInfo snapshotInfo = result[j];
                    ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                    moduleService.loadModule(snapshotInfo.getUuid(), (AsyncCallback)new AsyncCallback<Module>(){

                        public void onFailure(Throwable caught) {
                            ErrorPopup.showMessage((String)"Error listing snapshots information!");
                        }

                        public void onSuccess(Module result) {
                            TreeItem leafItem = new TreeItem((Widget)new ClickableLabel(snapshotInfo.getName(), (ClickHandler)new LeafClickHandler(packageConfigData.getName(), "<drools:resource type=\"PKG\" source=\"{url}\" basicAuthentication='enabled' username='|' password=''/>".replace("{url}", PackageBuilderWidget.getDownloadLink(result)))));
                            packageItem.addItem(leafItem);
                        }
                    });
                }
            }
        });
        rootItem.addItem(packageItem);
    }

    private class LeafClickHandler
    implements ClickHandler {
        private final String title;
        private final String pasteValue;

        public LeafClickHandler(String title, String pasteValue) {
            this.title = title;
            this.pasteValue = pasteValue;
        }

        public void onClick(ClickEvent event) {
            if (SpringContextElementsBrowser.this.elementSelectedItem != null) {
                SpringContextElementsBrowser.this.elementSelectedItem.onElementSelected(this.title, this.pasteValue);
            }
        }
    }

    private class PanelButton
    extends Button {
        public PanelButton(String html, String pasteValue) {
            super(html);
            this.setWidth("100px");
            this.addClickHandler(new LeafClickHandler(html, pasteValue));
        }
    }
}

