/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.widgets.drools.wizards.assets.decisiontable.ActionInsertFactFieldsPattern;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt52.ActionCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionInsertFactCol52;
import org.drools.ide.common.client.modeldriven.dt52.ActionSetFieldCol52;
import org.drools.ide.common.client.modeldriven.dt52.BaseColumn;
import org.drools.ide.common.client.modeldriven.dt52.CompositeColumn;
import org.drools.ide.common.client.modeldriven.dt52.ConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.LimitedEntryConditionCol52;
import org.drools.ide.common.client.modeldriven.dt52.Pattern52;

public class Validator {
    private List<CompositeColumn<? extends BaseColumn>> patternsConditions;
    private List<Pattern52> patternsActions;
    private Map<Pattern52, List<ActionSetFieldCol52>> patternToActionSetFieldsMap;
    private Map<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> patternToActionInsertFactFieldsMap;

    public Validator() {
        this(new ArrayList<CompositeColumn<? extends BaseColumn>>());
    }

    public Validator(List<CompositeColumn<? extends BaseColumn>> patterns) {
        this.patternsConditions = patterns;
        this.patternsActions = new ArrayList<Pattern52>();
    }

    public void addActionPattern(Pattern52 pattern) {
        this.patternsActions.add(pattern);
    }

    public void removeActionPattern(Pattern52 pattern) {
        this.patternsActions.remove(pattern);
    }

    public boolean arePatternBindingsUnique() {
        boolean hasUniqueBindings = true;
        HashMap<String, ArrayList<Pattern52>> bindings = new HashMap<String, ArrayList<Pattern52>>();
        for (CompositeColumn<? extends BaseColumn> cc : this.patternsConditions) {
            Pattern52 p;
            String binding;
            if (!(cc instanceof Pattern52) || (binding = (p = (Pattern52)cc).getBoundName()) == null || binding.equals("")) continue;
            ArrayList<Pattern52> ps = (ArrayList<Pattern52>)bindings.get(binding);
            if (ps == null) {
                ps = new ArrayList<Pattern52>();
                bindings.put(binding, ps);
            }
            ps.add(p);
        }
        for (Pattern52 p : this.patternsActions) {
            String binding = p.getBoundName();
            if (binding == null || binding.equals("")) continue;
            ArrayList<Pattern52> ps = (ArrayList<Pattern52>)bindings.get(binding);
            if (ps == null) {
                ps = new ArrayList<Pattern52>();
                bindings.put(binding, ps);
            }
            ps.add(p);
        }
        for (List pws : bindings.values()) {
            if (pws.size() <= 1) continue;
            hasUniqueBindings = false;
            break;
        }
        return hasUniqueBindings;
    }

    public boolean isPatternBindingUnique(Pattern52 pattern) {
        String binding = pattern.getBoundName();
        if (binding == null || binding.equals("")) {
            return true;
        }
        for (CompositeColumn<? extends BaseColumn> cc : this.patternsConditions) {
            Pattern52 p;
            if (!(cc instanceof Pattern52) || (p = (Pattern52)cc) == pattern || p.getBoundName() == null || !p.getBoundName().equals(binding)) continue;
            return false;
        }
        for (Pattern52 p : this.patternsActions) {
            if (p == pattern || p.getBoundName() == null || !p.getBoundName().equals(binding)) continue;
            return false;
        }
        return true;
    }

    public boolean isPatternValid(Pattern52 p) {
        return p.getBoundName() != null && !p.getBoundName().equals("");
    }

    public boolean isConditionValid(ConditionCol52 c) {
        return this.isConditionHeaderValid(c) && this.isConditionOperatorValid(c) && this.isConditionLimitedEntryValueValid(c);
    }

    public boolean isConditionHeaderValid(ConditionCol52 c) {
        return c.getHeader() != null && !c.getHeader().equals("");
    }

    public boolean isConditionOperatorValid(ConditionCol52 c) {
        if (c.getConstraintValueType() == 5) {
            return true;
        }
        return c.getOperator() != null && !c.getOperator().equals("");
    }

    public boolean isActionValid(ActionCol52 c) {
        return this.isActionHeaderValid(c);
    }

    public boolean isActionHeaderValid(ActionCol52 a) {
        return a.getHeader() != null && !a.getHeader().equals("");
    }

    public void setPatternToActionSetFieldsMap(Map<Pattern52, List<ActionSetFieldCol52>> patternToActionSetFieldsMap) {
        this.patternToActionSetFieldsMap = patternToActionSetFieldsMap;
    }

    public boolean arePatternActionSetFieldsValid(Pattern52 p) {
        if (this.patternToActionSetFieldsMap == null) {
            return true;
        }
        List<ActionSetFieldCol52> actions = this.patternToActionSetFieldsMap.get(p);
        if (actions == null) {
            return true;
        }
        for (ActionSetFieldCol52 a : actions) {
            if (this.isActionValid((ActionCol52)a)) continue;
            return false;
        }
        return true;
    }

    public void setPatternToActionInsertFactFieldsMap(Map<ActionInsertFactFieldsPattern, List<ActionInsertFactCol52>> patternToActionInsertFactFieldsMap) {
        this.patternToActionInsertFactFieldsMap = patternToActionInsertFactFieldsMap;
    }

    public boolean arePatternActionInsertFactFieldsValid(Pattern52 p) {
        if (this.patternToActionInsertFactFieldsMap == null) {
            return true;
        }
        List<ActionInsertFactCol52> actions = this.patternToActionInsertFactFieldsMap.get(p);
        if (actions == null) {
            return true;
        }
        for (ActionInsertFactCol52 a : actions) {
            if (this.isActionValid((ActionCol52)a)) continue;
            return false;
        }
        return true;
    }

    public boolean doesOperatorNeedValue(ConditionCol52 c) {
        String operator = c.getOperator();
        if (operator == null || operator.equals("")) {
            return false;
        }
        return !operator.equals("== null") && !operator.equals("!= null");
    }

    public boolean doesOperatorAcceptValueList(ConditionCol52 c) {
        String operator = c.getOperator();
        if (operator == null || operator.equals("")) {
            return false;
        }
        return !SuggestionCompletionEngine.operatorRequiresList((String)operator) && !operator.equals("== null") && !operator.equals("!= null");
    }

    public boolean isConditionLimitedEntryValueValid(ConditionCol52 c) {
        if (!(c instanceof LimitedEntryConditionCol52)) {
            return true;
        }
        LimitedEntryConditionCol52 lec = (LimitedEntryConditionCol52)c;
        boolean doesOperatorNeedValue = this.doesOperatorNeedValue((ConditionCol52)lec);
        boolean hasValue = this.hasValue(lec);
        return doesOperatorNeedValue && hasValue || !doesOperatorNeedValue && !hasValue;
    }

    private boolean hasValue(LimitedEntryConditionCol52 lec) {
        if (lec.getValue() == null) {
            return false;
        }
        return lec.getValue().hasValue();
    }
}

