/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.collection;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.collection.DerivedSet;
import org.apache.sis.util.resources.Errors;

class DerivedMap<SK, SV, K, V>
extends AbstractMap<K, V>
implements ObjectConverter<Map.Entry<SK, SV>, Map.Entry<K, V>>,
Serializable {
    private static final long serialVersionUID = -4760466188643114727L;
    protected final Map<SK, SV> storage;
    protected final ObjectConverter<SK, K> keyConverter;
    protected final ObjectConverter<SV, V> valueConverter;
    private transient Set<K> keySet;
    private transient Set<Map.Entry<K, V>> entrySet;

    static <SK, SV, K, V> Map<K, V> create(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
        Set<FunctionProperty> set = objectConverter.properties();
        Set<FunctionProperty> set2 = objectConverter2.properties();
        if (set.contains((Object)FunctionProperty.INVERTIBLE)) {
            if (set2.contains((Object)FunctionProperty.INVERTIBLE)) {
                return new Invertible<SK, SV, K, V>(map, objectConverter, objectConverter2);
            }
            return new InvertibleKey<SK, SV, K, V>(map, objectConverter, objectConverter2);
        }
        if (set2.contains((Object)FunctionProperty.INVERTIBLE)) {
            return new InvertibleValue<SK, SV, K, V>(map, objectConverter, objectConverter2);
        }
        return new DerivedMap<SK, SV, K, V>(map, objectConverter, objectConverter2);
    }

    private DerivedMap(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
        this.storage = map;
        this.keyConverter = objectConverter;
        this.valueConverter = objectConverter2;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty() || this.keySet().isEmpty();
    }

    @Override
    public V put(K k, V v) throws UnsupportedOperationException {
        return this.put(k, this.keyConverter.inverse().apply(k), this.valueConverter.inverse().apply(v));
    }

    final V put(K k, SK SK, SV SV) {
        if (SK == null) {
            throw new UnconvertibleObjectException(Errors.format((short)31, "key", k));
        }
        return this.valueConverter.apply(this.storage.put(SK, SV));
    }

    @Override
    public final Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = DerivedSet.create(this.storage.keySet(), this.keyConverter);
        }
        return this.keySet;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = DerivedSet.create(this.storage.entrySet(), this);
        }
        return this.entrySet;
    }

    @Override
    public final Set<FunctionProperty> properties() {
        EnumSet<FunctionProperty> enumSet = EnumSet.of(FunctionProperty.INVERTIBLE, FunctionProperty.INJECTIVE, FunctionProperty.SURJECTIVE);
        enumSet.retainAll(this.keyConverter.properties());
        enumSet.retainAll(this.valueConverter.properties());
        return enumSet;
    }

    @Override
    public final Class<Map.Entry<SK, SV>> getSourceClass() {
        return Map.Entry.class;
    }

    @Override
    public final Class<Map.Entry<K, V>> getTargetClass() {
        return Map.Entry.class;
    }

    @Override
    public final Map.Entry<K, V> apply(Map.Entry<SK, SV> entry) {
        K k = this.keyConverter.apply(entry.getKey());
        V v = this.valueConverter.apply(entry.getValue());
        return k != null ? new AbstractMap.SimpleEntry<K, V>(k, v) : null;
    }

    @Override
    public ObjectConverter<Map.Entry<K, V>, Map.Entry<SK, SV>> inverse() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private static final class Invertible<SK, SV, K, V>
    extends InvertibleKey<SK, SV, K, V> {
        private static final long serialVersionUID = -6625938922337246124L;
        private final ObjectConverter<V, SV> valueInverse;
        private transient ObjectConverter<Map.Entry<K, V>, Map.Entry<SK, SV>> inverse;

        Invertible(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
            super(map, objectConverter, objectConverter2);
            this.valueInverse = objectConverter2.inverse();
        }

        @Override
        public boolean containsValue(Object object) {
            Class clazz = this.valueConverter.getTargetClass();
            return clazz.isInstance(object) && this.storage.containsValue(this.valueInverse.apply((V)clazz.cast(object)));
        }

        @Override
        public V put(K k, V v) {
            return this.put(k, this.keyInverse.apply(k), this.valueInverse.apply(v));
        }

        @Override
        public ObjectConverter<Map.Entry<K, V>, Map.Entry<SK, SV>> inverse() {
            if (this.inverse == null) {
                this.inverse = new DerivedMap<K, V, SK, SV>(null, this.keyInverse, this.valueInverse);
            }
            return this.inverse;
        }
    }

    private static final class InvertibleValue<SK, SV, K, V>
    extends DerivedMap<SK, SV, K, V> {
        private static final long serialVersionUID = -8290698486357636366L;
        private final ObjectConverter<V, SV> valueInverse;

        InvertibleValue(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
            super(map, objectConverter, objectConverter2);
            this.valueInverse = objectConverter2.inverse();
        }

        @Override
        public boolean containsValue(Object object) {
            Class clazz = this.valueConverter.getTargetClass();
            return clazz.isInstance(object) && this.storage.containsValue(this.valueInverse.apply((V)clazz.cast(object)));
        }
    }

    private static class InvertibleKey<SK, SV, K, V>
    extends DerivedMap<SK, SV, K, V> {
        private static final long serialVersionUID = 3499911507293121425L;
        protected final ObjectConverter<K, SK> keyInverse;

        InvertibleKey(Map<SK, SV> map, ObjectConverter<SK, K> objectConverter, ObjectConverter<SV, V> objectConverter2) {
            super(map, objectConverter, objectConverter2);
            this.keyInverse = objectConverter.inverse();
        }

        @Override
        public final V get(Object object) {
            Class clazz = this.keyConverter.getTargetClass();
            return clazz.isInstance(object) ? (V)this.valueConverter.apply(this.storage.get(this.keyInverse.apply((K)clazz.cast(object)))) : null;
        }

        @Override
        public final V remove(Object object) throws UnsupportedOperationException {
            Class clazz = this.keyConverter.getTargetClass();
            return clazz.isInstance(object) ? (V)this.valueConverter.apply(this.storage.remove(this.keyInverse.apply((K)clazz.cast(object)))) : null;
        }

        @Override
        public final boolean containsKey(Object object) {
            Class clazz = this.keyConverter.getTargetClass();
            return clazz.isInstance(object) && this.storage.containsKey(this.keyInverse.apply((K)clazz.cast(object)));
        }
    }
}

