/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor.drools.enums;

import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.asseteditor.drools.enums.EnumRow;

public class EnumParser {
    private EnumParser() {
    }

    public static List<EnumRow> parseEnums(String content) {
        ArrayList<EnumRow> enums = new ArrayList<EnumRow>();
        if (content == null || content.isEmpty()) {
            return enums;
        }
        String[] lines = content.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].trim();
            EnumRow er = EnumParser.parseEnum(line);
            if (er == null) continue;
            enums.add(er);
        }
        return enums;
    }

    private static EnumRow parseEnum(String line) {
        String context;
        if (line.equals("") || line.startsWith("#") || line.startsWith("//")) {
            return null;
        }
        int colonIndex = line.indexOf(":");
        if (colonIndex < 0) {
            return null;
        }
        String factField = line.substring(0, colonIndex);
        int dotIndex = (factField = factField.trim()).indexOf(".");
        if (dotIndex < 0) {
            return null;
        }
        String factName = factField.substring(0, dotIndex);
        factName = factName.trim();
        String fieldName = factField.substring(dotIndex + 1, factField.length());
        fieldName = fieldName.trim();
        if (!factName.startsWith("'")) {
            return null;
        }
        if (!fieldName.endsWith("'")) {
            return null;
        }
        EnumRow er = new EnumRow(factName = factName.substring(1).trim(), fieldName = fieldName.substring(0, fieldName.length() - 1).trim(), context = line.substring(colonIndex + 1).trim());
        if (!er.isValid()) {
            return null;
        }
        return er;
    }
}

