/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.analysis.action;

import java.util.HashSet;
import java.util.Set;
import org.drools.guvnor.client.decisiontable.analysis.action.ActionDetectorKey;
import org.drools.ide.common.client.modeldriven.dt52.DTCellValue52;

public class ActionDetector {
    protected ActionDetectorKey key;
    protected Set<DTCellValue52> valueSet = null;
    protected boolean duplicated = false;

    public ActionDetector(ActionDetectorKey key, DTCellValue52 value) {
        this.key = key;
        this.valueSet = new HashSet<DTCellValue52>(2);
        this.valueSet.add(value);
    }

    protected ActionDetector(ActionDetector a, ActionDetector b) {
        if (!a.key.equals(b.key)) {
            throw new IllegalArgumentException("The ActionDetectorKey of a and b are not equal.");
        }
        this.key = a.key;
        this.valueSet = new HashSet<DTCellValue52>(a.valueSet);
        this.duplicated = a.duplicated || b.duplicated;
        for (DTCellValue52 bValue : b.valueSet) {
            this.duplicated = this.duplicated || !this.valueSet.add(bValue);
        }
    }

    public ActionDetectorKey getKey() {
        return this.key;
    }

    public boolean isDuplicated() {
        return this.duplicated;
    }

    public boolean isMultipleValuesForOneAction() {
        return this.valueSet.size() > 1;
    }

    public ActionDetector merge(ActionDetector other) {
        return new ActionDetector(this, other);
    }
}

