/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.converters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.client.rpc.ConversionResult;
import org.drools.guvnor.client.rpc.ConversionResultNoConverter;
import org.drools.guvnor.server.converters.AbstractConverter;
import org.drools.guvnor.server.converters.ConversionService;
import org.drools.guvnor.server.converters.decisiontable.DecisionTableXLSToDecisionTableGuidedConverter;
import org.drools.repository.AssetItem;

@ApplicationScoped
public class GuvnorDroolsConversionService
implements ConversionService {
    @Inject
    private DecisionTableXLSToDecisionTableGuidedConverter decisionTableXLSToDecisionTableGuidedConverter;
    private final Map<String, List<AbstractConverter>> CONVERTERS = new HashMap<String, List<AbstractConverter>>();
    private final ConversionResult NULL_RESULT = new ConversionResultNoConverter();

    @PostConstruct
    public void registration() {
        this.register("xls", this.decisionTableXLSToDecisionTableGuidedConverter);
    }

    public void register(String sourceFormat, AbstractConverter converter) {
        List<AbstractConverter> registeredConverters = this.CONVERTERS.get(sourceFormat);
        if (registeredConverters == null) {
            registeredConverters = new ArrayList<AbstractConverter>();
            this.CONVERTERS.put(sourceFormat, registeredConverters);
        }
        registeredConverters.add(converter);
    }

    public ConversionResult convert(AssetItem item, String targetFormat) {
        String sourceFormat = item.getFormat();
        if (!this.CONVERTERS.containsKey(sourceFormat)) {
            return this.NULL_RESULT;
        }
        for (AbstractConverter converter : this.CONVERTERS.get(sourceFormat)) {
            if (!converter.isTargetFormatSupported(targetFormat)) continue;
            return converter.convert(item);
        }
        return this.NULL_RESULT;
    }
}

