/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.server.TestScenarioServiceImplementation;
import org.drools.guvnor.server.files.AssetZipper;
import org.drools.guvnor.server.files.FileManagerService;
import org.drools.guvnor.server.files.GuvnorDroolsDocsBuilder;
import org.drools.guvnor.server.files.PackageDeploymentURIHelper;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

public class PackageDeploymentServlet
extends RepositoryServlet {
    private static final long serialVersionUID = 510L;
    private static final String RFC822DATEFORMAT = "EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z";
    private static final Locale HEADER_LOCALE = Locale.US;
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private TestScenarioServiceImplementation testScenarioServiceImplementation;
    @Inject
    private FileManagerService fileManagerService;

    protected long getLastModified(HttpServletRequest request) {
        PackageDeploymentURIHelper helper = null;
        try {
            helper = new PackageDeploymentURIHelper(request.getRequestURI());
            return this.fileManagerService.getLastModified(helper.getPackageName(), helper.getVersion());
        }
        catch (UnsupportedEncodingException e) {
            return super.getLastModified(request);
        }
    }

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equals("HEAD")) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(RFC822DATEFORMAT, HEADER_LOCALE);
            PackageDeploymentURIHelper helper = new PackageDeploymentURIHelper(request.getRequestURI());
            long mod = this.fileManagerService.getLastModified(helper.getPackageName(), helper.getVersion());
            response.addHeader("lastModified", "" + mod);
            response.addHeader("Last-Modified", dateFormat.format(new Date(mod)));
        } else {
            super.doHead(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        String packageName = request.getParameter("packageName");
        FormData data = FileManagerService.getFormData((HttpServletRequest)request);
        try {
            this.fileManagerService.importClassicDRL(data.getFile().getInputStream(), packageName);
            response.getWriter().write("OK");
        }
        catch (IllegalArgumentException e) {
            response.getWriter().write(e.getMessage());
        }
        catch (RulesRepositoryException e) {
            response.getWriter().write("Unable to process import: " + e.getMessage());
        }
    }

    protected void doGet(final HttpServletRequest req, final HttpServletResponse res) throws ServletException, IOException {
        this.doAuthorizedAction(req, res, new RepositoryServlet.Command(){

            public void execute() throws Exception {
                PackageDeploymentURIHelper helper = new PackageDeploymentURIHelper(req.getRequestURI());
                PackageDeploymentServlet.this.log.info("PackageName: " + helper.getPackageName());
                PackageDeploymentServlet.this.log.info("PackageVersion: " + helper.getVersion());
                PackageDeploymentServlet.this.log.info("PackageIsLatest: " + helper.isLatest());
                PackageDeploymentServlet.this.log.info("PackageIsSource: " + helper.isSource());
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                String fileName = null;
                if (helper.isSource()) {
                    fileName = helper.isAsset() ? PackageDeploymentServlet.this.fileManagerService.loadSourceAsset(helper.getPackageName(), helper.getVersion(), helper.isLatest(), helper.getAssetName(), out) : PackageDeploymentServlet.this.fileManagerService.loadSourcePackage(helper.getPackageName(), helper.getVersion(), helper.isLatest(), (OutputStream)out);
                } else if (helper.isDocumentation()) {
                    GuvnorDroolsDocsBuilder builder;
                    ModuleItem pkg = PackageDeploymentServlet.this.rulesRepository.loadModule(helper.getPackageName());
                    try {
                        builder = GuvnorDroolsDocsBuilder.getInstance((ModuleItem)pkg);
                    }
                    catch (DroolsParserException e) {
                        throw new ServletException("Could not parse the rule package.");
                    }
                    fileName = "documentation.pdf";
                    builder.writePDF((OutputStream)out);
                } else if (helper.isPng()) {
                    ModuleItem pkg = PackageDeploymentServlet.this.rulesRepository.loadModule(helper.getPackageName());
                    AssetItem asset = pkg.loadAsset(helper.getAssetName());
                    fileName = PackageDeploymentServlet.this.fileManagerService.loadFileAttachmentByUUID(asset.getUUID(), (OutputStream)out);
                } else if (req.getRequestURI().endsWith("SCENARIOS")) {
                    fileName = "TestScenariosResult.txt";
                    PackageDeploymentServlet.this.doRunScenarios(helper, out);
                } else if (req.getRequestURI().endsWith("ChangeSet.xml")) {
                    String url = req.getRequestURL().toString().replace("/ChangeSet.xml", "");
                    fileName = "ChangeSet.xml";
                    String xml = "";
                    xml = xml + "<change-set xmlns='http://drools.org/drools-5.0/change-set'\n";
                    xml = xml + "    xmlns:xs='http://www.w3.org/2001/XMLSchema-instance'\n";
                    xml = xml + "    xs:schemaLocation='http://drools.org/drools-5.0/change-set http://anonsvn.jboss.org/repos/labs/labs/jbossrules/trunk/drools-api/src/main/resources/change-set-1.0.0.xsd' >\n";
                    xml = xml + "    <add>\n ";
                    xml = xml + "        <resource source='" + url + "' type='PKG' />\n";
                    xml = xml + "    </add>\n";
                    xml = xml + "</change-set>";
                    out.write(xml.getBytes());
                } else if (req.getRequestURI().endsWith("MODEL")) {
                    ModuleItem pkg = PackageDeploymentServlet.this.rulesRepository.loadModule(helper.getPackageName());
                    AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"jar"});
                    BufferedInputStream inputFile = null;
                    byte[] data = new byte[1000];
                    int count = 0;
                    int numberOfAssets = 0;
                    while (it.hasNext()) {
                        it.next();
                        ++numberOfAssets;
                    }
                    if (numberOfAssets == 0) {
                        res.setContentType("text/html");
                        PrintWriter outEM = res.getWriter();
                        outEM.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.0 Transitional//EN\">\n<HTML>\n<HEAD><TITLE>Empty POJO Model(jar)</TITLE></HEAD>\n<BODY>\n<H1>EMPTY MODEL</H1>\n</BODY></HTML>");
                        return;
                    }
                    if (numberOfAssets > 1) {
                        fileName = "Model.zip";
                        inputFile = new BufferedInputStream(PackageDeploymentServlet.this.zipModel(pkg));
                        while ((count = inputFile.read(data, 0, 1000)) != -1) {
                            out.write(data, 0, count);
                        }
                        inputFile.close();
                    } else {
                        fileName = "ModelJar.jar";
                        inputFile = new BufferedInputStream(PackageDeploymentServlet.this.zipModel(pkg));
                        while ((count = inputFile.read(data, 0, 1000)) != -1) {
                            out.write(data, 0, count);
                        }
                        inputFile.close();
                    }
                } else if (req.getRequestURI().contains("/SpringContext/")) {
                    String uri = req.getRequestURI();
                    int lastIndexOfSlash = uri.lastIndexOf(47);
                    String assetName = uri.substring(lastIndexOfSlash + 1);
                    fileName = assetName + ".xml";
                    ModuleItem pkg = PackageDeploymentServlet.this.rulesRepository.loadModule(helper.getPackageName());
                    AssetItem asset = pkg.loadAsset(assetName);
                    out.write(asset.getBinaryContentAsBytes());
                } else {
                    fileName = PackageDeploymentServlet.this.fileManagerService.loadBinaryPackage(helper.getPackageName(), helper.getVersion(), helper.isLatest(), (OutputStream)out);
                }
                res.setContentType("application/x-download");
                res.setHeader("Content-Disposition", "attachment; filename=" + fileName + ";");
                res.setContentLength(out.size());
                res.getOutputStream().write(out.toByteArray());
                res.getOutputStream().flush();
            }
        });
    }

    private void doRunScenarios(PackageDeploymentURIHelper helper, ByteArrayOutputStream out) throws IOException {
        ModuleItem pkg = helper.isLatest() ? this.rulesRepository.loadModule(helper.getPackageName()) : this.rulesRepository.loadModuleSnapshot(helper.getPackageName(), helper.getVersion());
        try {
            BulkTestRunResult result = this.testScenarioServiceImplementation.runScenariosInPackage(pkg);
            out.write(result.toString().getBytes());
        }
        catch (DetailedSerializationException e) {
            this.log.error("Unable to run scenarios.", (Throwable)e);
            out.write(e.getMessage().getBytes());
        }
        catch (SerializationException e) {
            this.log.error("Unable to run scenarios.", (Throwable)e);
            out.write(e.getMessage().getBytes());
        }
    }

    public InputStream zipModel(ModuleItem pkg) {
        LinkedList<AssetItem> jarAssets = new LinkedList<AssetItem>();
        AssetZipper assetZipper = null;
        Iterator it = pkg.getAssets();
        while (it.hasNext()) {
            AssetItem asset = (AssetItem)it.next();
            if (!asset.getFormat().contentEquals("jar")) continue;
            jarAssets.add(asset);
        }
        if (jarAssets.size() != 0) {
            assetZipper = new AssetZipper(jarAssets, pkg);
            return assetZipper.zipAssets();
        }
        return null;
    }
}

