/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.SubBlockHeader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UnixOwnersHeader
extends SubBlockHeader {
    private Log logger = LogFactory.getLog(UnixOwnersHeader.class);
    private int ownerNameSize;
    private int groupNameSize;
    private String owner;
    private String group;

    public UnixOwnersHeader(SubBlockHeader sb, byte[] uoHeader) {
        super(sb);
        int pos = 0;
        this.ownerNameSize = Raw.readShortLittleEndian(uoHeader, pos) & 0xFFFF;
        this.groupNameSize = Raw.readShortLittleEndian(uoHeader, pos += 2) & 0xFFFF;
        if ((pos += 2) + this.ownerNameSize < uoHeader.length) {
            byte[] ownerBuffer = new byte[this.ownerNameSize];
            System.arraycopy(uoHeader, pos, ownerBuffer, 0, this.ownerNameSize);
            this.owner = new String(ownerBuffer);
        }
        if ((pos += this.ownerNameSize) + this.groupNameSize < uoHeader.length) {
            byte[] groupBuffer = new byte[this.groupNameSize];
            System.arraycopy(uoHeader, pos, groupBuffer, 0, this.groupNameSize);
            this.group = new String(groupBuffer);
        }
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public int getGroupNameSize() {
        return this.groupNameSize;
    }

    public void setGroupNameSize(int groupNameSize) {
        this.groupNameSize = groupNameSize;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public int getOwnerNameSize() {
        return this.ownerNameSize;
    }

    public void setOwnerNameSize(int ownerNameSize) {
        this.ownerNameSize = ownerNameSize;
    }

    @Override
    public void print() {
        super.print();
        this.logger.info((Object)("ownerNameSize: " + this.ownerNameSize));
        this.logger.info((Object)("owner: " + this.owner));
        this.logger.info((Object)("groupNameSize: " + this.groupNameSize));
        this.logger.info((Object)("group: " + this.group));
    }
}

