/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel.traits;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.core.util.ClassUtils;
import org.drools.factmodel.traits.TraitField;
import org.drools.factmodel.traits.TraitFieldTMS;
import org.drools.factmodel.traits.TraitType;
import org.drools.factmodel.traits.TypeCache;
import org.drools.factmodel.traits.TypeWrapper;
import org.mvel2.MVEL;

public class TraitFieldTMSImpl
implements TraitFieldTMS,
Externalizable {
    private Map<String, TraitField> fieldTMS = new LinkedHashMap<String, TraitField>();
    private transient WorkingMemory workingMemory;
    private TypeCache typeCache = new TypeCache();
    private long modificationMask = Long.MIN_VALUE;

    public void init(WorkingMemory wm) {
        this.workingMemory = wm;
        if (this.getTypeCache().needsInit()) {
            this.getTypeCache().init(wm);
        }
    }

    public void registerField(Class domainKlass, String name) {
        this.registerField(domainKlass, name, Object.class, null, null);
    }

    public void registerField(Class domainKlass, String name, Class rangeKlass, Object value, String initial) {
        short pos = (short)ClassUtils.getSettableProperties(domainKlass).indexOf(name);
        TraitField fld = new TraitField(this.getKlass(rangeKlass), value, initial != null ? MVEL.eval((String)initial, (Class)rangeKlass) : null, pos);
        this.fieldTMS.put(name, fld);
    }

    public Object set(String name, Object value, Class klass) {
        return this.fieldTMS.get(name).set(value, this.getKlass(klass), this.workingMemory);
    }

    public Object get(String name, Class klass) {
        return this.fieldTMS.get(name).get(this.getKlass(klass));
    }

    public boolean isManagingField(String name) {
        return this.fieldTMS.containsKey(name);
    }

    public Object donField(String name, TraitType trait, String defaultValue, Class klass, boolean logical) {
        TraitField fld = this.fieldTMS.get(name);
        this.modificationMask |= (long)(1 << fld.getPosition());
        return fld.don(trait, defaultValue != null ? MVEL.eval((String)defaultValue, (Class)klass) : null, this.getKlass(klass), logical, this.workingMemory);
    }

    public Object shedField(String name, TraitType trait, Class rangeKlass, Class asKlass) {
        TraitField fld = this.fieldTMS.get(name);
        this.modificationMask |= (long)(1 << fld.getPosition());
        return fld.shed(trait, this.getKlass(rangeKlass), this.getKlass(asKlass), this.workingMemory);
    }

    private TypeWrapper getKlass(Class klass) {
        TypeWrapper wrapper = this.getTypeCache().get(klass.getName());
        if (wrapper == null) {
            wrapper = new TypeWrapper(klass);
            this.getTypeCache().put(wrapper.getName(), wrapper);
        }
        return wrapper;
    }

    public boolean needsInit() {
        return this.workingMemory == null;
    }

    public long getAndResetModificationMask() {
        long l = this.modificationMask;
        this.modificationMask = Long.MIN_VALUE;
        return l;
    }

    public TraitField getRegisteredTraitField(String name) {
        return this.fieldTMS.get(name);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.fieldTMS.size());
        ArrayList<String> keys = new ArrayList<String>(this.fieldTMS.keySet());
        Collections.sort(keys);
        for (String k : keys) {
            out.writeObject(k);
            out.writeObject(this.fieldTMS.get(k));
        }
        out.writeObject(this.typeCache);
        out.writeLong(this.modificationMask);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.fieldTMS = new HashMap<String, TraitField>();
        int n = in.readInt();
        for (int j = 0; j < n; ++j) {
            String k = (String)in.readObject();
            TraitField tf = (TraitField)in.readObject();
            this.fieldTMS.put(k, tf);
        }
        this.typeCache = (TypeCache)in.readObject();
        this.modificationMask = in.readLong();
    }

    public TypeCache getTypeCache() {
        if (this.typeCache == null) {
            this.typeCache = new TypeCache();
        }
        return this.typeCache;
    }
}

