/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.guvnor.common.services.project.model.Package;
import org.guvnor.common.services.project.model.Project;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.KPropertyImpl;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.model.KProperty;

public class DefaultIndexBuilder {
    protected final String fileName;
    protected final Project project;
    protected final Package pkg;
    protected String pkgName;
    private Set<IndexElementsGenerator> generators = new HashSet<IndexElementsGenerator>();

    public DefaultIndexBuilder(String fileName, Project project, Package pkg) {
        this.fileName = (String)PortablePreconditions.checkNotNull((String)"fileName", (Object)fileName);
        this.project = (Project)PortablePreconditions.checkNotNull((String)"project", (Object)project);
        this.pkg = (Package)PortablePreconditions.checkNotNull((String)"pkg", (Object)pkg);
    }

    public DefaultIndexBuilder addGenerator(IndexElementsGenerator generator) {
        this.generators.add((IndexElementsGenerator)PortablePreconditions.checkNotNull((String)"generator", (Object)generator));
        return this;
    }

    public Set<KProperty<?>> build() {
        HashSet indexElements = new HashSet();
        this.generators.forEach(generator -> this.addIndexElements(indexElements, (IndexElementsGenerator)generator));
        if (this.project != null && this.project.getRootPath() != null) {
            String projectRootUri = this.project.getRootPath().toURI();
            indexElements.add((KProperty<?>)new KPropertyImpl("projectRoot", (Object)projectRootUri));
            String projectName = this.project.getProjectName();
            if (projectName != null) {
                indexElements.add((KProperty<?>)new KPropertyImpl("projectName", (Object)projectName));
            }
        }
        if (this.pkgName == null) {
            this.pkgName = this.pkg.getPackageName();
        }
        if (this.pkgName != null) {
            indexElements.add((KProperty<?>)new KPropertyImpl("packageName", (Object)this.pkgName));
        }
        return indexElements;
    }

    private void addIndexElements(Set<KProperty<?>> indexElements, IndexElementsGenerator generator) {
        if (generator == null) {
            return;
        }
        List generatorsIndexElements = generator.toIndexElements();
        indexElements.addAll(generatorsIndexElements);
    }

    public void setPackageName(String pkgName) {
        this.pkgName = pkgName;
    }
}

