/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.indexing;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.compiler.DrlExprParser;
import org.drools.compiler.lang.descr.AccumulateDescr;
import org.drools.compiler.lang.descr.AccumulateImportDescr;
import org.drools.compiler.lang.descr.ActionDescr;
import org.drools.compiler.lang.descr.AndDescr;
import org.drools.compiler.lang.descr.AnnotatedBaseDescr;
import org.drools.compiler.lang.descr.AnnotationDescr;
import org.drools.compiler.lang.descr.AtomicExprDescr;
import org.drools.compiler.lang.descr.AttributeDescr;
import org.drools.compiler.lang.descr.BaseDescr;
import org.drools.compiler.lang.descr.BehaviorDescr;
import org.drools.compiler.lang.descr.BindingDescr;
import org.drools.compiler.lang.descr.CollectDescr;
import org.drools.compiler.lang.descr.ConditionalBranchDescr;
import org.drools.compiler.lang.descr.ConnectiveDescr;
import org.drools.compiler.lang.descr.ConstraintConnectiveDescr;
import org.drools.compiler.lang.descr.DeclarativeInvokerDescr;
import org.drools.compiler.lang.descr.EntryPointDeclarationDescr;
import org.drools.compiler.lang.descr.EntryPointDescr;
import org.drools.compiler.lang.descr.EnumDeclarationDescr;
import org.drools.compiler.lang.descr.EnumLiteralDescr;
import org.drools.compiler.lang.descr.EvalDescr;
import org.drools.compiler.lang.descr.EvaluatorBasedRestrictionDescr;
import org.drools.compiler.lang.descr.ExistsDescr;
import org.drools.compiler.lang.descr.ExprConstraintDescr;
import org.drools.compiler.lang.descr.FactTemplateDescr;
import org.drools.compiler.lang.descr.FieldConstraintDescr;
import org.drools.compiler.lang.descr.FieldTemplateDescr;
import org.drools.compiler.lang.descr.ForFunctionDescr;
import org.drools.compiler.lang.descr.ForallDescr;
import org.drools.compiler.lang.descr.FromDescr;
import org.drools.compiler.lang.descr.FunctionDescr;
import org.drools.compiler.lang.descr.FunctionImportDescr;
import org.drools.compiler.lang.descr.GlobalDescr;
import org.drools.compiler.lang.descr.ImportDescr;
import org.drools.compiler.lang.descr.LiteralDescr;
import org.drools.compiler.lang.descr.LiteralRestrictionDescr;
import org.drools.compiler.lang.descr.MVELExprDescr;
import org.drools.compiler.lang.descr.NamedConsequenceDescr;
import org.drools.compiler.lang.descr.NotDescr;
import org.drools.compiler.lang.descr.OrDescr;
import org.drools.compiler.lang.descr.PackageDescr;
import org.drools.compiler.lang.descr.PatternDescr;
import org.drools.compiler.lang.descr.PredicateDescr;
import org.drools.compiler.lang.descr.QualifiedIdentifierRestrictionDescr;
import org.drools.compiler.lang.descr.QueryDescr;
import org.drools.compiler.lang.descr.RelationalExprDescr;
import org.drools.compiler.lang.descr.RestrictionConnectiveDescr;
import org.drools.compiler.lang.descr.ReturnValueRestrictionDescr;
import org.drools.compiler.lang.descr.RuleDescr;
import org.drools.compiler.lang.descr.TypeDeclarationDescr;
import org.drools.compiler.lang.descr.TypeFieldDescr;
import org.drools.compiler.lang.descr.UnitDescr;
import org.drools.compiler.lang.descr.VariableRestrictionDescr;
import org.drools.compiler.lang.descr.WindowDeclarationDescr;
import org.drools.compiler.lang.descr.WindowReferenceDescr;
import org.drools.workbench.models.datamodel.oracle.ModelField;
import org.drools.workbench.models.datamodel.oracle.ProjectDataModelOracle;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.workbench.common.services.refactoring.IndexElementsGenerator;
import org.kie.workbench.common.services.refactoring.ResourceReference;
import org.kie.workbench.common.services.refactoring.SharedPart;
import org.kie.workbench.common.services.refactoring.backend.server.impact.ResourceReferenceCollector;
import org.kie.workbench.common.services.refactoring.backend.server.indexing.DefaultIndexBuilder;
import org.kie.workbench.common.services.refactoring.service.PartType;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.metadata.model.KProperty;

public class PackageDescrIndexVisitor
extends ResourceReferenceCollector {
    private static final Logger logger = LoggerFactory.getLogger(PackageDescrIndexVisitor.class);
    private final ProjectDataModelOracle dmo;
    private final DefaultIndexBuilder builder;
    private final PackageDescr packageDescr;
    private final PackageDescrIndexVisitorContext context = new PackageDescrIndexVisitorContext();

    public PackageDescrIndexVisitor(ProjectDataModelOracle dmo, DefaultIndexBuilder builder, PackageDescr packageDescr) {
        this.dmo = (ProjectDataModelOracle)PortablePreconditions.checkNotNull((String)"dmo", (Object)dmo);
        this.builder = (DefaultIndexBuilder)PortablePreconditions.checkNotNull((String)"builder", (Object)builder);
        this.packageDescr = (PackageDescr)PortablePreconditions.checkNotNull((String)"packageDescr", (Object)packageDescr);
    }

    public Set<KProperty<?>> visit() {
        this.visit(this.packageDescr);
        return this.builder.build();
    }

    void visit(Object descr) {
        if (descr instanceof AccumulateDescr) {
            this.visit((AccumulateDescr)descr);
        } else if (descr instanceof AccumulateImportDescr) {
            this.visit((AccumulateImportDescr)descr);
        } else if (descr instanceof ActionDescr) {
            this.visit((ActionDescr)descr);
        } else if (descr instanceof AndDescr) {
            this.visit((AndDescr)descr);
        } else if (descr instanceof AnnotationDescr) {
            this.visit((AnnotationDescr)descr);
        } else if (descr instanceof AtomicExprDescr) {
            this.visit((AtomicExprDescr)descr);
        } else if (descr instanceof AttributeDescr) {
            this.visit((AttributeDescr)descr);
        } else if (descr instanceof BehaviorDescr) {
            this.visit((BehaviorDescr)descr);
        } else if (descr instanceof BindingDescr) {
            this.visit((BindingDescr)descr);
        } else if (descr instanceof CollectDescr) {
            this.visit((CollectDescr)descr);
        } else if (descr instanceof ConditionalBranchDescr) {
            this.visit((ConditionalBranchDescr)descr);
        } else if (descr instanceof ConnectiveDescr) {
            this.visit((ConnectiveDescr)descr);
        } else if (descr instanceof ConstraintConnectiveDescr) {
            this.visit((ConstraintConnectiveDescr)descr);
        } else if (descr instanceof EntryPointDeclarationDescr) {
            this.visit((EntryPointDeclarationDescr)descr);
        } else if (descr instanceof EntryPointDescr) {
            this.visit((EntryPointDescr)descr);
        } else if (descr instanceof EnumDeclarationDescr) {
            this.visit((EnumDeclarationDescr)descr);
        } else if (descr instanceof EnumLiteralDescr) {
            this.visit((EnumLiteralDescr)descr);
        } else if (descr instanceof ExistsDescr) {
            this.visit((ExistsDescr)descr);
        } else if (descr instanceof ExprConstraintDescr) {
            this.visit((ExprConstraintDescr)descr);
        } else if (descr instanceof EvalDescr) {
            this.visit((EvalDescr)descr);
        } else if (descr instanceof FactTemplateDescr) {
            this.visit((FactTemplateDescr)descr);
        } else if (descr instanceof FieldConstraintDescr) {
            this.visit((FieldConstraintDescr)descr);
        } else if (descr instanceof FieldTemplateDescr) {
            this.visit((FieldTemplateDescr)descr);
        } else if (descr instanceof ForallDescr) {
            this.visit((ForallDescr)descr);
        } else if (descr instanceof ForFunctionDescr) {
            this.visit((ForFunctionDescr)descr);
        } else if (descr instanceof FromDescr) {
            this.visit((FromDescr)descr);
        } else if (descr instanceof FunctionDescr) {
            this.visit((FunctionDescr)descr);
        } else if (descr instanceof FunctionImportDescr) {
            this.visit((FunctionImportDescr)descr);
        } else if (descr instanceof GlobalDescr) {
            this.visit((GlobalDescr)descr);
        } else if (descr instanceof ImportDescr) {
            this.visit((ImportDescr)descr);
        } else if (descr instanceof LiteralDescr) {
            this.visit((LiteralDescr)descr);
        } else if (descr instanceof LiteralRestrictionDescr) {
            this.visit((LiteralRestrictionDescr)descr);
        } else if (descr instanceof MVELExprDescr) {
            this.visit((MVELExprDescr)descr);
        } else if (descr instanceof NamedConsequenceDescr) {
            this.visit((NamedConsequenceDescr)descr);
        } else if (descr instanceof NotDescr) {
            this.visit((NotDescr)descr);
        } else if (descr instanceof OrDescr) {
            this.visit((OrDescr)descr);
        } else if (descr instanceof PackageDescr) {
            this.visit((PackageDescr)descr);
        } else if (descr instanceof PatternDescr) {
            this.visit((PatternDescr)descr);
        } else if (descr instanceof PredicateDescr) {
            this.visit((PredicateDescr)descr);
        } else if (descr instanceof QueryDescr) {
            this.visit((QueryDescr)descr);
        } else if (descr instanceof QualifiedIdentifierRestrictionDescr) {
            this.visit((QualifiedIdentifierRestrictionDescr)descr);
        } else if (descr instanceof RelationalExprDescr) {
            this.visit((RelationalExprDescr)descr);
        } else if (descr instanceof RestrictionConnectiveDescr) {
            this.visit((RestrictionConnectiveDescr)descr);
        } else if (descr instanceof ReturnValueRestrictionDescr) {
            this.visit((ReturnValueRestrictionDescr)descr);
        } else if (descr instanceof TypeDeclarationDescr) {
            this.visit((TypeDeclarationDescr)descr);
        } else if (descr instanceof TypeFieldDescr) {
            this.visit((TypeFieldDescr)descr);
        } else if (descr instanceof UnitDescr) {
            this.visit((UnitDescr)descr);
        } else if (descr instanceof VariableRestrictionDescr) {
            this.visit((VariableRestrictionDescr)descr);
        } else if (descr instanceof WindowDeclarationDescr) {
            this.visit((WindowDeclarationDescr)descr);
        } else if (descr instanceof WindowReferenceDescr) {
            this.visit((WindowReferenceDescr)descr);
        } else if (descr instanceof AnnotatedBaseDescr) {
            this.visit((AnnotatedBaseDescr)descr);
        } else if (descr instanceof DeclarativeInvokerDescr) {
            this.visit((DeclarativeInvokerDescr)descr);
        } else if (descr instanceof EvaluatorBasedRestrictionDescr) {
            this.visit((EvaluatorBasedRestrictionDescr)descr);
        } else if (descr instanceof RuleDescr) {
            this.visit((RuleDescr)descr);
        } else {
            logger.error("Not visiting '" + descr.getClass().getName() + "' when indexing rule.");
        }
    }

    protected void visit(AccumulateDescr descr) {
        this.visit(descr.getInputPattern());
        for (AccumulateDescr.AccumulateFunctionCallDescr accFuncCallDescr : descr.getFunctions()) {
            this.visit(accFuncCallDescr);
        }
    }

    protected void visit(AccumulateDescr.AccumulateFunctionCallDescr descr) {
    }

    protected void visit(AccumulateImportDescr descr) {
        this.addResourceReference(descr.getTarget(), ResourceType.JAVA);
        this.addResourceReference(descr.getFunctionName(), ResourceType.FUNCTION);
    }

    protected void visit(ActionDescr descr) {
    }

    protected void visit(AndDescr descr) {
        for (BaseDescr baseDescr : descr.getDescrs()) {
            this.visit(baseDescr);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(AnnotatedBaseDescr descr) {
        for (AnnotationDescr annoDescr : descr.getAnnotations()) {
            this.visit(annoDescr);
        }
    }

    protected void visit(AnnotationDescr descr) {
        this.addResourceReference(descr.getName(), ResourceType.DRL_ANNOTATION);
    }

    protected void visit(AtomicExprDescr descr) {
        String expression = descr.getExpression();
        this.parseExpression(expression);
    }

    protected void visit(AttributeDescr descr) {
        String attr;
        switch (attr = descr.getName()) {
            case "no-loop": 
            case "lock-on-active": 
            case "salience": 
            case "auto-focus": 
            case "dialect": 
            case "date-effective": 
            case "date-expires": 
            case "enabled": 
            case "duration": 
            case "timer": 
            case "calendars": {
                return;
            }
        }
        PartType type = PartType.getPartTypeFromAttribueDescrName((String)descr.getName());
        switch (type) {
            case AGENDA_GROUP: 
            case ACTIVATION_GROUP: 
            case RULEFLOW_GROUP: {
                SharedPart sharedRef = new SharedPart(descr.getValue(), type);
                this.builder.addGenerator((IndexElementsGenerator)sharedRef);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported attribute encountered: " + descr.getName());
            }
        }
    }

    protected void visit(BehaviorDescr descr) {
    }

    protected void visit(BindingDescr descr) {
        String identifier = descr.getVariable();
        String fullyQualifiedClassName = this.parseExpression(descr.getExpression());
        if (fullyQualifiedClassName != null) {
            this.context.addBoundType(identifier, fullyQualifiedClassName);
        }
    }

    protected void visit(CollectDescr descr) {
        this.visit(descr.getInputPattern());
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
    }

    protected void visit(ConditionalBranchDescr descr) {
        this.visit(descr.getCondition());
        this.visit(descr.getConsequence());
        ConditionalBranchDescr elseBranch = descr.getElseBranch();
        if (elseBranch != null) {
            this.visit(elseBranch);
        }
    }

    protected void visit(ConnectiveDescr descr) {
    }

    protected void visit(ConstraintConnectiveDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(DeclarativeInvokerDescr descr) {
    }

    protected void visit(EntryPointDeclarationDescr descr) {
        this.addSharedReference(descr.getEntryPointId(), PartType.ENTRY_POINT);
        for (AnnotationDescr annoDescr : descr.getAnnotations()) {
            this.visit(annoDescr);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(EntryPointDescr descr) {
        this.addSharedReference(descr.getEntryId(), PartType.ENTRY_POINT);
    }

    protected void visit(EnumDeclarationDescr descr) {
        String typeName = this.getPackagePrefix() + descr.getFullTypeName();
        ResourceReference enumLocalRef = this.addResourceReference(typeName, ResourceType.DRL_ENUM);
        for (EnumLiteralDescr enumLitDescr : descr.getLiterals()) {
            enumLocalRef.addPartReference(enumLitDescr.getName(), PartType.DRL_ENUM_VAL);
            this.visitAnnos((AnnotatedBaseDescr)enumLitDescr);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visitAnnos(AnnotatedBaseDescr descr) {
        for (AnnotationDescr annoDescr : descr.getAnnotations()) {
            this.visit(annoDescr);
        }
    }

    protected void visit(EnumLiteralDescr descr) {
        String name = descr.getName();
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(EvalDescr descr) {
    }

    protected void visit(EvaluatorBasedRestrictionDescr descr) {
    }

    protected void visit(ExistsDescr descr) {
        for (Object o : descr.getDescrs()) {
            this.visit(o);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(ExprConstraintDescr descr) {
        DrlExprParser parser = new DrlExprParser(LanguageLevelOption.DRL6);
        ConstraintConnectiveDescr result = parser.parse(descr.getExpression());
        this.visit(result);
    }

    protected void visit(FactTemplateDescr descr) {
        for (FieldTemplateDescr d : descr.getFields()) {
            this.visit(d);
        }
    }

    protected void visit(FieldConstraintDescr descr) {
        for (Object o : descr.getRestrictions()) {
            this.visit(o);
        }
    }

    protected void visit(FieldTemplateDescr descr) {
    }

    protected void visit(ForallDescr descr) {
        this.visit(descr.getBasePattern());
        for (BaseDescr o : descr.getDescrs()) {
            this.visit(o);
        }
    }

    protected void visit(ForFunctionDescr descr) {
    }

    protected void visit(FromDescr descr) {
        this.visit(descr.getDataSource());
    }

    protected void visit(FunctionDescr descr) {
        String funcName = this.getPackagePrefix() + descr.getName();
        this.addResource(funcName, ResourceType.FUNCTION);
    }

    protected void visit(FunctionImportDescr descr) {
        String funcName = descr.getTarget();
        this.addResourceReference(funcName, ResourceType.FUNCTION);
    }

    protected void visit(GlobalDescr descr) {
        String fqcn = this.getFullyQualifiedClassName(descr.getType());
        this.addResourceReference(fqcn, ResourceType.JAVA);
    }

    protected void visit(ImportDescr descr) {
        String importStr = descr.getTarget();
        if (!importStr.endsWith("*")) {
            this.addResourceReference(descr.getTarget(), ResourceType.JAVA);
        } else {
            logger.debug("Wildcard import encountered : '" + importStr + "'");
        }
    }

    protected void visit(LiteralDescr descr) {
    }

    protected void visit(LiteralRestrictionDescr descr) {
    }

    protected void visit(MVELExprDescr descr) {
    }

    protected void visit(NamedConsequenceDescr descr) {
        String name = descr.getText();
    }

    protected void visit(NotDescr descr) {
        for (Object o : descr.getDescrs()) {
            this.visit(o);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(OrDescr descr) {
        for (BaseDescr d : descr.getDescrs()) {
            this.visit(d);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(PackageDescr descr) {
        for (AccumulateImportDescr accImportDescr : descr.getAccumulateImports()) {
            this.visit(accImportDescr);
        }
        for (AttributeDescr attrDescr : descr.getAttributes()) {
            this.visit(attrDescr);
        }
        for (EntryPointDeclarationDescr entryPointDeclDescr : descr.getEntryPointDeclarations()) {
            this.visit(entryPointDeclDescr);
        }
        for (EnumDeclarationDescr enumDeclDescr : descr.getEnumDeclarations()) {
            this.visit(enumDeclDescr);
        }
        for (FunctionDescr funcDescr : descr.getFunctions()) {
            this.visit(funcDescr);
        }
        for (FunctionImportDescr funcImportDescr : descr.getFunctionImports()) {
            this.visit(funcImportDescr);
        }
        for (GlobalDescr globalDescr : descr.getGlobals()) {
            this.visit(globalDescr);
        }
        for (ImportDescr importDescr : descr.getImports()) {
            this.visit(importDescr);
        }
        for (RuleDescr ruleDescr : descr.getRules()) {
            this.visit(ruleDescr);
        }
        for (TypeDeclarationDescr typeDeclDescr : descr.getTypeDeclarations()) {
            this.visit(typeDeclDescr);
        }
        for (WindowDeclarationDescr windowDeclDescr : descr.getWindowDeclarations()) {
            this.visit(windowDeclDescr);
        }
    }

    protected void visit(PatternDescr descr) {
        this.context.startPattern(descr);
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(descr.getObjectType());
        if (descr.getIdentifier() != null && !descr.getIdentifier().isEmpty()) {
            this.context.addBoundType(descr.getIdentifier(), fullyQualifiedClassName);
        }
        this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
        this.visit(descr.getConstraint());
        this.context.endPattern();
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(PredicateDescr descr) {
    }

    protected void visit(QualifiedIdentifierRestrictionDescr descr) {
    }

    protected void visit(QueryDescr descr) {
        this.visit(descr.getLhs());
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(RestrictionConnectiveDescr descr) {
    }

    protected void visit(RelationalExprDescr descr) {
        this.visit(descr.getLeft());
        this.visit(descr.getRight());
    }

    protected void visit(ReturnValueRestrictionDescr descr) {
    }

    protected void visit(RuleDescr descr) {
        String ruleName = this.getPackagePrefix() + descr.getName();
        this.addResource(ruleName, ResourceType.RULE);
        String parentRuleName = descr.getParentName();
        if (parentRuleName != null) {
            this.addResourceReference(parentRuleName, ResourceType.RULE);
        }
        for (AttributeDescr d : descr.getAttributes().values()) {
            this.visit(d);
        }
        this.visit(descr.getLhs());
        this.visitConsequence(descr.getConsequence());
        for (String string : descr.getNamedConsequences().keySet()) {
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visitConsequence(Object consequence) {
    }

    protected void visit(TypeDeclarationDescr descr) {
        String fqcn = this.getFullyQualifiedClassName(descr.getTypeName());
        this.addResourceReference(fqcn, ResourceType.JAVA);
        if (descr.getSuperTypeName() != null && !descr.getSuperTypeName().isEmpty()) {
            fqcn = this.getFullyQualifiedClassName(descr.getSuperTypeName());
            this.addResourceReference(fqcn, ResourceType.JAVA);
        }
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(TypeFieldDescr descr) {
        this.visitAnnos((AnnotatedBaseDescr)descr);
    }

    protected void visit(UnitDescr descr) {
        String fqcn = this.getFullyQualifiedClassName(descr.getTarget());
        this.addResourceReference(fqcn, ResourceType.JAVA);
    }

    protected void visit(VariableRestrictionDescr descr) {
    }

    protected void visit(WindowDeclarationDescr descr) {
        this.visit(descr.getPattern());
    }

    protected void visit(WindowReferenceDescr descr) {
    }

    private String parseExpression(String expression) {
        String factType = this.context.getCurrentPattern().getObjectType();
        String fullyQualifiedClassName = this.getFullyQualifiedClassName(factType);
        if (expression.startsWith("eval")) {
            return null;
        }
        while (expression.contains(".")) {
            String fieldName = expression.substring(0, expression.indexOf("."));
            if (this.context.isBoundType(fieldName)) {
                fullyQualifiedClassName = this.context.getBoundType(fieldName);
                expression = expression.substring(expression.indexOf(".") + 1);
                continue;
            }
            expression = expression.substring(expression.indexOf(".") + 1);
            factType = this.addField(fieldName, fullyQualifiedClassName);
            if (factType == null) continue;
            fullyQualifiedClassName = this.getFullyQualifiedClassName(factType);
        }
        return this.addField(expression, fullyQualifiedClassName);
    }

    private String addField(String fieldName, String fullyQualifiedClassName) {
        ModelField[] mfs = (ModelField[])this.dmo.getProjectModelFields().get(fullyQualifiedClassName);
        if (mfs != null) {
            for (ModelField mf : mfs) {
                if (!mf.getName().equals(fieldName)) continue;
                ResourceReference resRef = this.addResourceReference(fullyQualifiedClassName, ResourceType.JAVA);
                resRef.addPartReference(fieldName, PartType.FIELD);
                this.addResourceReference(mf.getClassName(), ResourceType.JAVA);
                return mf.getClassName();
            }
        }
        return null;
    }

    private String getFullyQualifiedClassName(String typeName) {
        if (typeName.contains(".")) {
            return typeName;
        }
        for (ImportDescr importDescr : this.packageDescr.getImports()) {
            if (!importDescr.getTarget().endsWith(typeName)) continue;
            return importDescr.getTarget();
        }
        for (Map.Entry entry : this.dmo.getProjectModelFields().entrySet()) {
            ModelField[] mfs = (ModelField[])entry.getValue();
            String key = (String)entry.getKey();
            for (ModelField mf : mfs) {
                if (!mf.getClassType().equals((Object)ModelField.FIELD_CLASS_TYPE.REGULAR_CLASS)) continue;
                if (mf.getClassName().endsWith("." + typeName)) {
                    return mf.getClassName();
                }
                if (!mf.getType().endsWith("." + typeName)) continue;
                return mf.getType();
            }
        }
        return this.packageDescr.getName() + "." + typeName;
    }

    private String getPackagePrefix() {
        String pkgName = this.packageDescr.getName();
        if (!pkgName.isEmpty()) {
            pkgName = pkgName + ".";
        }
        return pkgName;
    }

    private static class PackageDescrIndexVisitorContext {
        private Deque<PatternDescr> patterns = new ArrayDeque<PatternDescr>();
        private Map<String, String> boundTypes = new HashMap<String, String>();

        private PackageDescrIndexVisitorContext() {
        }

        void startPattern(PatternDescr descr) {
            this.patterns.add(descr);
        }

        void endPattern() {
            this.patterns.pop();
        }

        PatternDescr getCurrentPattern() {
            return this.patterns.peek();
        }

        void addBoundType(String identifier, String fullyQualifiedClassName) {
            this.boundTypes.put(identifier, fullyQualifiedClassName);
        }

        boolean isBoundType(String identifier) {
            return this.boundTypes.containsKey(identifier);
        }

        String getBoundType(String identifier) {
            return this.boundTypes.get(identifier);
        }
    }
}

