/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.refactoring.backend.server.query.builder;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.WildcardQuery;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.AbstractQueryBuilder;
import org.kie.workbench.common.services.refactoring.backend.server.query.builder.QueryBuilder;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;

public class SearchEmptyQueryBuilder
extends AbstractQueryBuilder
implements QueryBuilder<SearchEmptyQueryBuilder> {
    private final BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();

    @Override
    public Query build() {
        BooleanQuery query = this.queryBuilder.build();
        return query;
    }

    @Override
    public SearchEmptyQueryBuilder addTerm(ValueIndexTerm term) {
        if (term.getValue().trim().isEmpty()) {
            this.queryBuilder.add((Query)new WildcardQuery(new Term(term.getTerm(), "*")), BooleanClause.Occur.MUST_NOT);
        } else if (term.getValue().trim().equals("*")) {
            this.queryBuilder.add((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST);
        } else {
            Query query = this.getQuery(term);
            this.queryBuilder.add(query, BooleanClause.Occur.MUST);
        }
        return this;
    }

    public SearchEmptyQueryBuilder addRuleNameWildCardTerm() {
        ValueResourceIndexTerm valTerm = new ValueResourceIndexTerm("*", ResourceType.RULE, ValueIndexTerm.TermSearchType.WILDCARD);
        this.queryBuilder.add((Query)new WildcardQuery(new Term(valTerm.getTerm(), valTerm.getValue())), BooleanClause.Occur.MUST);
        return this;
    }
}

