/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.coref.DiscourseEntity;
import opennlp.tools.coref.mention.MentionContext;
import opennlp.tools.coref.resolver.MaxentResolver;
import opennlp.tools.coref.resolver.NonReferentialResolver;
import opennlp.tools.coref.resolver.ResolverMode;
import opennlp.tools.coref.resolver.ResolverUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonNounResolver
extends MaxentResolver {
    public CommonNounResolver(String projectName, ResolverMode m) throws IOException {
        super(projectName, "cmodel", m, 80, true);
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    public CommonNounResolver(String projectName, ResolverMode m, NonReferentialResolver nrr) throws IOException {
        super(projectName, "cmodel", m, 80, true, nrr);
        this.showExclusions = false;
        this.preferFirstReferent = true;
    }

    @Override
    protected List<String> getFeatures(MentionContext mention, DiscourseEntity entity) {
        ArrayList<String> features = new ArrayList<String>();
        features.addAll(super.getFeatures(mention, entity));
        if (entity != null) {
            features.addAll(ResolverUtils.getContextFeatures(mention));
            features.addAll(ResolverUtils.getStringMatchFeatures(mention, entity));
        }
        return features;
    }

    @Override
    public boolean canResolve(MentionContext mention) {
        String firstTok = mention.getFirstTokenText().toLowerCase();
        String firstTokTag = mention.getFirstToken().getSyntacticType();
        boolean rv = mention.getHeadTokenTag().equals("NN") && !ResolverUtils.definiteArticle(firstTok, firstTokTag);
        return rv;
    }

    @Override
    protected boolean excluded(MentionContext ec, DiscourseEntity de) {
        if (super.excluded(ec, de)) {
            return true;
        }
        MentionContext cec = de.getLastExtent();
        return !this.canResolve(cec) || super.excluded(ec, de);
    }
}

