/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.cell.client.TextCell;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.navigation.admin.widget.EventLogPresenter;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.LogPageRow;
import org.drools.guvnor.client.widgets.tables.AbstractPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;

public class LogPagedTable
extends AbstractPagedTable<LogPageRow>
implements EventLogPresenter.EventLogView {
    @UiField
    protected Button cleanButton;
    @UiField
    protected Button refreshButton;
    private static LogPagedTableBinder uiBinder = (LogPagedTableBinder)GWT.create(LogPagedTableBinder.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private static final String HTML_ERROR_ICON = LogPagedTable.makeImage(images.error());
    private static final String HTML_INFO_ICON = LogPagedTable.makeImage(images.information());
    private static final int PAGE_SIZE = 10;

    private static String makeImage(ImageResource resource) {
        AbstractImagePrototype prototype = AbstractImagePrototype.create((ImageResource)resource);
        return prototype.getHTML();
    }

    public LogPagedTable() {
        super(10);
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<LogPageRow> columnPicker, SortableHeaderGroup<LogPageRow> sortableHeaderGroup) {
        AbstractCell<Long> severityCell = new AbstractCell<Long>(new String[0]){

            public void render(Cell.Context context, Long value, SafeHtmlBuilder sb) {
                if (value.intValue() == 0) {
                    sb.appendHtmlConstant(HTML_ERROR_ICON);
                } else if (value.intValue() == 1) {
                    sb.appendHtmlConstant(HTML_INFO_ICON);
                }
            }
        };
        Column<LogPageRow, Long> severityColumn = new Column<LogPageRow, Long>((Cell)severityCell){

            public Long getValue(LogPageRow row) {
                return row.getSeverity();
            }
        };
        columnPicker.addColumn(severityColumn, new SortableHeader<LogPageRow, Long>(sortableHeaderGroup, constants.Severity(), severityColumn), true);
        Column<LogPageRow, String> messageColumn = new Column<LogPageRow, String>((Cell)new TextCell()){

            public String getValue(LogPageRow row) {
                return row.getMessage();
            }
        };
        columnPicker.addColumn(messageColumn, new SortableHeader<LogPageRow, String>(sortableHeaderGroup, constants.Message(), messageColumn), true);
        Column<LogPageRow, Date> timestampColumn = new Column<LogPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(LogPageRow row) {
                return row.getTimestamp();
            }
        };
        columnPicker.addColumn(timestampColumn, new SortableHeader<LogPageRow, Date>(sortableHeaderGroup, constants.Timestamp(), timestampColumn), true);
    }

    @Override
    protected Widget makeWidget() {
        return (Widget)uiBinder.createAndBindUi(this);
    }

    @Override
    public HasClickHandlers getClearEventLogButton() {
        return this.cleanButton;
    }

    @Override
    public HasClickHandlers getRefreshEventLogButton() {
        return this.refreshButton;
    }

    @Override
    public void showClearingLogMessage() {
        LoadingPopup.showMessage(constants.CleaningLogMessages());
    }

    @Override
    public void hideClearingLogMessage() {
        LoadingPopup.close();
    }

    @Override
    public int getStartRowIndex() {
        return this.pager.getPageStart();
    }

    @Override
    public int getPageSize() {
        return 10;
    }

    static interface LogPagedTableBinder
    extends UiBinder<Widget, LogPagedTable> {
    }
}

