/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.temporal.Temporal;
import java.util.Date;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.EventFactHandle;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.Trait;
import org.drools.core.facttemplates.FactTemplate;
import org.drools.core.util.MathUtils;

public class ValueType<T>
implements Externalizable {
    private static final long serialVersionUID = 510L;
    public static final ValueType NULL_TYPE = new ValueType("null", null, 1);
    public static final ValueType PCHAR_TYPE = new ValueType<Character>("char", Character.TYPE, 6);
    public static final ValueType PBYTE_TYPE = new ValueType<Byte>("byte", Byte.TYPE, 4);
    public static final ValueType PSHORT_TYPE = new ValueType<Short>("short", Short.TYPE, 4);
    public static final ValueType PINTEGER_TYPE = new ValueType<Integer>("int", Integer.TYPE, 4);
    public static final ValueType PLONG_TYPE = new ValueType<Long>("long", Long.TYPE, 4);
    public static final ValueType PFLOAT_TYPE = new ValueType<Float>("float", Float.TYPE, 5);
    public static final ValueType PDOUBLE_TYPE = new ValueType<Double>("double", Double.TYPE, 5);
    public static final ValueType PBOOLEAN_TYPE = new ValueType<Boolean>("boolean", Boolean.TYPE, 2);
    public static final ValueType CHAR_TYPE = new ValueType<Character>("Character", Character.class, 6);
    public static final ValueType BYTE_TYPE = new ValueType<Byte>("Byte", Byte.class, 4);
    public static final ValueType SHORT_TYPE = new ValueType<Short>("Short", Short.class, 4);
    public static final ValueType INTEGER_TYPE = new ValueType<Integer>("Integer", Integer.class, 4);
    public static final ValueType LONG_TYPE = new ValueType<Long>("Long", Long.class, 4);
    public static final ValueType FLOAT_TYPE = new ValueType<Float>("Float", Float.class, 5);
    public static final ValueType DOUBLE_TYPE = new ValueType<Double>("Double", Double.class, 5);
    public static final ValueType BOOLEAN_TYPE = new ValueType<Boolean>("Boolean", Boolean.class, 2);
    public static final ValueType NUMBER_TYPE = new ValueType<Number>("Number", Number.class, 8);
    public static final ValueType BIG_DECIMAL_TYPE = new BigDecimalValueType();
    public static final ValueType BIG_INTEGER_TYPE = new BigIntegerValueType();
    public static final ValueType DATE_TYPE = new ValueType<Date>("Date", Date.class, 8);
    public static final ValueType ARRAY_TYPE = new ValueType<Object[]>("Array", Object[].class, 9);
    public static final ValueType STRING_TYPE = new StringValueType();
    public static final ValueType OBJECT_TYPE = new ValueType<Object>("Object", Object.class, 10);
    public static final ValueType FACTTEMPLATE_TYPE = new ValueType<FactTemplate>("FactTemplate", FactTemplate.class, 0);
    public static final ValueType EVENT_TYPE = new ValueType<EventFactHandle>("Event", EventFactHandle.class, 10);
    public static final ValueType QUERY_TYPE = new ValueType<DroolsQuery>("Query", DroolsQuery.class, 10);
    public static final ValueType TRAIT_TYPE = new ValueType<Thing>("Trait", Thing.class, 10);
    public static final ValueType CLASS_TYPE = new ValueType<Class>("Class", Class.class, 10);
    private String name;
    private Class<T> classType;
    private int simpleType;

    public ValueType() {
        this(null, null, 0);
    }

    private ValueType(String name, Class<T> classType, int simpleType) {
        this.name = name;
        this.classType = classType;
        this.simpleType = simpleType;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.classType = (Class)in.readObject();
        this.simpleType = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeObject(this.classType);
        out.writeInt(this.simpleType);
    }

    private Object readResolve() throws ObjectStreamException {
        return ValueType.determineValueType(this.classType);
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getClassType() {
        return this.classType;
    }

    public int getSimpleType() {
        return this.simpleType;
    }

    public static ValueType determineValueType(Class<?> clazz) {
        if (clazz == null) {
            return NULL_TYPE;
        }
        if (clazz == FactTemplate.class) {
            return FACTTEMPLATE_TYPE;
        }
        if (clazz == DroolsQuery.class) {
            return QUERY_TYPE;
        }
        if (clazz == Character.TYPE) {
            return PCHAR_TYPE;
        }
        if (clazz == Byte.TYPE) {
            return PBYTE_TYPE;
        }
        if (clazz == Short.TYPE) {
            return PSHORT_TYPE;
        }
        if (clazz == Integer.TYPE) {
            return PINTEGER_TYPE;
        }
        if (clazz == Long.TYPE) {
            return PLONG_TYPE;
        }
        if (clazz == Float.TYPE) {
            return PFLOAT_TYPE;
        }
        if (clazz == Double.TYPE) {
            return PDOUBLE_TYPE;
        }
        if (clazz == Boolean.TYPE) {
            return PBOOLEAN_TYPE;
        }
        if (clazz == Character.class) {
            return CHAR_TYPE;
        }
        if (clazz == Byte.class) {
            return BYTE_TYPE;
        }
        if (clazz == Short.class) {
            return SHORT_TYPE;
        }
        if (clazz == Integer.class) {
            return INTEGER_TYPE;
        }
        if (clazz == Long.class) {
            return LONG_TYPE;
        }
        if (clazz == Float.class) {
            return FLOAT_TYPE;
        }
        if (clazz == Double.class) {
            return DOUBLE_TYPE;
        }
        if (clazz == Boolean.class) {
            return BOOLEAN_TYPE;
        }
        if (clazz == BigDecimal.class) {
            return BIG_DECIMAL_TYPE;
        }
        if (clazz == BigInteger.class) {
            return BIG_INTEGER_TYPE;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return NUMBER_TYPE;
        }
        if (ValueType.isDateType(clazz)) {
            return DATE_TYPE;
        }
        if (clazz.isArray()) {
            return ARRAY_TYPE;
        }
        if (clazz == String.class) {
            return STRING_TYPE;
        }
        if (clazz == EventFactHandle.class) {
            return EVENT_TYPE;
        }
        if (clazz == Class.class) {
            return CLASS_TYPE;
        }
        if (Thing.class.isAssignableFrom(clazz) || clazz.isAnnotationPresent(Trait.class)) {
            return TRAIT_TYPE;
        }
        return OBJECT_TYPE;
    }

    public static boolean isDateType(Class<?> clazz) {
        return Date.class.isAssignableFrom(clazz) || Temporal.class.isAssignableFrom(clazz);
    }

    public String toString() {
        return "ValueType = '" + this.name + "'";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ValueType) {
            ValueType that = (ValueType)object;
            return this.classType == that.classType && this.simpleType == that.simpleType && (this.name == that.name || this.name != null && this.name.equals(that.name));
        }
        return false;
    }

    public boolean isBoolean() {
        return this.classType == Boolean.class || this.classType == Boolean.TYPE;
    }

    public boolean isDate() {
        return this.classType == Date.class;
    }

    public boolean isNumber() {
        return this.simpleType == 4 || this.simpleType == 5 || this.simpleType == 6 || this.simpleType == 3;
    }

    public boolean isIntegerNumber() {
        return this.simpleType == 4;
    }

    public boolean isFloatNumber() {
        return this.simpleType == 5;
    }

    public boolean isChar() {
        return this.simpleType == 6;
    }

    public boolean isEvent() {
        return this.classType == EventFactHandle.class;
    }

    public T coerce(Object value) {
        return (T)value;
    }

    public static class BigDecimalValueType
    extends ValueType<BigDecimal> {
        public BigDecimalValueType() {
            super("BigDecimal", BigDecimal.class, 3);
        }

        @Override
        public BigDecimal coerce(Object value) {
            if (value == null) {
                return null;
            }
            return MathUtils.getBigDecimal(value);
        }
    }

    public static class BigIntegerValueType
    extends ValueType<BigInteger> {
        public BigIntegerValueType() {
            super("BigInteger", BigInteger.class, 3);
        }

        @Override
        public BigInteger coerce(Object value) {
            if (value == null) {
                return null;
            }
            return MathUtils.getBigInteger(value);
        }
    }

    public static class StringValueType
    extends ValueType<String> {
        public StringValueType() {
            super("String", String.class, 7);
        }

        @Override
        public String coerce(Object value) {
            if (value == null) {
                return null;
            }
            return value instanceof String ? (String)value : value.toString();
        }
    }
}

