/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ConstraintViolationException;
import com.healthmarketscience.jackcess.Index;
import com.healthmarketscience.jackcess.IndexCursor;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.IndexData;
import com.healthmarketscience.jackcess.impl.IndexImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.util.CaseInsensitiveColumnMatcher;
import com.healthmarketscience.jackcess.util.ColumnMatcher;
import com.healthmarketscience.jackcess.util.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

final class FKEnforcer {
    private static final ColumnMatcher MATCHER = CaseInsensitiveColumnMatcher.INSTANCE;
    private final TableImpl _table;
    private final List<ColumnImpl> _cols;
    private List<Joiner> _primaryJoinersChkUp;
    private List<Joiner> _primaryJoinersChkDel;
    private List<Joiner> _primaryJoinersDoUp;
    private List<Joiner> _primaryJoinersDoDel;
    private List<Joiner> _primaryJoinersDoNull;
    private List<Joiner> _secondaryJoiners;

    FKEnforcer(TableImpl table) {
        this._table = table;
        TreeSet<ColumnImpl> cols = new TreeSet<ColumnImpl>();
        for (IndexImpl idx : this._table.getIndexes()) {
            IndexImpl.ForeignKeyReference ref = idx.getReference();
            if (ref == null) continue;
            for (IndexData.ColumnDescriptor iCol : idx.getColumns()) {
                cols.add(iCol.getColumn());
            }
        }
        this._cols = !cols.isEmpty() ? Collections.unmodifiableList(new ArrayList(cols)) : Collections.emptyList();
    }

    private void initialize() throws IOException {
        if (this._secondaryJoiners != null) {
            return;
        }
        this._primaryJoinersChkUp = new ArrayList<Joiner>(1);
        this._primaryJoinersChkDel = new ArrayList<Joiner>(1);
        this._primaryJoinersDoUp = new ArrayList<Joiner>(1);
        this._primaryJoinersDoDel = new ArrayList<Joiner>(1);
        this._primaryJoinersDoNull = new ArrayList<Joiner>(1);
        this._secondaryJoiners = new ArrayList<Joiner>(1);
        for (IndexImpl idx : this._table.getIndexes()) {
            IndexImpl.ForeignKeyReference ref = idx.getReference();
            if (ref == null) continue;
            Joiner joiner = Joiner.create(idx);
            if (ref.isPrimaryTable()) {
                if (ref.isCascadeUpdates()) {
                    this._primaryJoinersDoUp.add(joiner);
                } else {
                    this._primaryJoinersChkUp.add(joiner);
                }
                if (ref.isCascadeDeletes()) {
                    this._primaryJoinersDoDel.add(joiner);
                    continue;
                }
                if (ref.isCascadeNullOnDelete()) {
                    this._primaryJoinersDoNull.add(joiner);
                    continue;
                }
                this._primaryJoinersChkDel.add(joiner);
                continue;
            }
            this._secondaryJoiners.add(joiner);
        }
    }

    public void addRow(Object[] row) throws IOException {
        if (!this.enforcing()) {
            return;
        }
        this.initialize();
        for (Joiner joiner : this._secondaryJoiners) {
            FKEnforcer.requirePrimaryValues(joiner, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow(Object[] oldRow, Object[] newRow) throws IOException {
        if (!this.enforcing()) {
            return;
        }
        if (!this.anyUpdates(oldRow, newRow)) {
            return;
        }
        this.initialize();
        SharedState ss = this._table.getDatabase().getFKEnforcerSharedState();
        if (ss.isUpdating()) {
            for (Joiner joiner : this._secondaryJoiners) {
                if (!FKEnforcer.anyUpdates(joiner, oldRow, newRow)) continue;
                FKEnforcer.requirePrimaryValues(joiner, newRow);
            }
        }
        ss.pushUpdate();
        try {
            for (Joiner joiner : this._primaryJoinersChkUp) {
                if (!FKEnforcer.anyUpdates(joiner, oldRow, newRow)) continue;
                FKEnforcer.requireNoSecondaryValues(joiner, oldRow);
            }
            for (Joiner joiner : this._primaryJoinersDoUp) {
                if (!FKEnforcer.anyUpdates(joiner, oldRow, newRow)) continue;
                FKEnforcer.updateSecondaryValues(joiner, oldRow, newRow);
            }
        }
        finally {
            ss.popUpdate();
        }
    }

    public void deleteRow(Object[] row) throws IOException {
        if (!this.enforcing()) {
            return;
        }
        this.initialize();
        for (Joiner joiner : this._primaryJoinersChkDel) {
            FKEnforcer.requireNoSecondaryValues(joiner, row);
        }
        for (Joiner joiner : this._primaryJoinersDoDel) {
            joiner.deleteRows(row);
        }
        for (Joiner joiner : this._primaryJoinersDoNull) {
            FKEnforcer.nullSecondaryValues(joiner, row);
        }
    }

    private static void requirePrimaryValues(Joiner joiner, Object[] row) throws IOException {
        if (!FKEnforcer.areNull(joiner, row) && !joiner.hasRows(row)) {
            throw new ConstraintViolationException("Adding new row " + Arrays.asList(row) + " violates constraint " + joiner.toFKString());
        }
    }

    private static void requireNoSecondaryValues(Joiner joiner, Object[] row) throws IOException {
        if (joiner.hasRows(row)) {
            throw new ConstraintViolationException("Removing old row " + Arrays.asList(row) + " violates constraint " + joiner.toFKString());
        }
    }

    private static void updateSecondaryValues(Joiner joiner, Object[] oldFromRow, Object[] newFromRow) throws IOException {
        IndexCursor toCursor = joiner.getToCursor();
        List<? extends Index.Column> fromCols = joiner.getColumns();
        List<? extends Index.Column> toCols = joiner.getToIndex().getColumns();
        Object[] toRow = new Object[joiner.getToTable().getColumnCount()];
        Iterator<Row> iter = joiner.findRows(oldFromRow).setColumnNames(Collections.<String>emptySet()).iterator();
        while (iter.hasNext()) {
            iter.next();
            Arrays.fill(toRow, Column.KEEP_VALUE);
            for (int i = 0; i < fromCols.size(); ++i) {
                Object val = fromCols.get(i).getColumn().getRowValue(newFromRow);
                toCols.get(i).getColumn().setRowValue(toRow, val);
            }
            toCursor.updateCurrentRow(toRow);
        }
    }

    private static void nullSecondaryValues(Joiner joiner, Object[] oldFromRow) throws IOException {
        IndexCursor toCursor = joiner.getToCursor();
        List<? extends Index.Column> fromCols = joiner.getColumns();
        List<? extends Index.Column> toCols = joiner.getToIndex().getColumns();
        Object[] toRow = new Object[joiner.getToTable().getColumnCount()];
        Iterator<Row> iter = joiner.findRows(oldFromRow).setColumnNames(Collections.<String>emptySet()).iterator();
        while (iter.hasNext()) {
            iter.next();
            Arrays.fill(toRow, Column.KEEP_VALUE);
            for (int i = 0; i < fromCols.size(); ++i) {
                toCols.get(i).getColumn().setRowValue(toRow, null);
            }
            toCursor.updateCurrentRow(toRow);
        }
    }

    private boolean anyUpdates(Object[] oldRow, Object[] newRow) {
        for (ColumnImpl col : this._cols) {
            if (MATCHER.matches(this._table, col.getName(), col.getRowValue(oldRow), col.getRowValue(newRow))) continue;
            return true;
        }
        return false;
    }

    private static boolean anyUpdates(Joiner joiner, Object[] oldRow, Object[] newRow) {
        Table fromTable = joiner.getFromTable();
        for (Index.Column column : joiner.getColumns()) {
            Column col = column.getColumn();
            if (MATCHER.matches(fromTable, col.getName(), col.getRowValue(oldRow), col.getRowValue(newRow))) continue;
            return true;
        }
        return false;
    }

    private static boolean areNull(Joiner joiner, Object[] row) {
        for (Index.Column column : joiner.getColumns()) {
            if (column.getColumn().getRowValue(row) == null) continue;
            return false;
        }
        return true;
    }

    private boolean enforcing() {
        return this._table.getDatabase().isEnforceForeignKeys();
    }

    static SharedState initSharedState() {
        return new SharedState();
    }

    static final class SharedState {
        private int _updateDepth;

        private SharedState() {
        }

        public boolean isUpdating() {
            return this._updateDepth == 0;
        }

        public void pushUpdate() {
            ++this._updateDepth;
        }

        public void popUpdate() {
            --this._updateDepth;
        }
    }
}

