/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.protocols.Discovery;
import org.jgroups.protocols.PingData;
import org.jgroups.util.Responses;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

public class FILE_PING
extends Discovery {
    protected static final String SUFFIX = ".list";
    protected static final Pattern regexp = Pattern.compile("[\u0000<>:\"/\\|?*]");
    @Property(description="The absolute path of the shared file")
    protected String location = File.separator + "tmp" + File.separator + "jgroups";
    @Deprecated
    @Property(description="Interval (in milliseconds) at which the own Address is written. 0 disables it.")
    protected long interval = 60000L;
    @Property(description="If true, on a view change, the new coordinator removes files from old coordinators")
    protected boolean remove_old_coords_on_view_change = false;
    @Property(description="If true, on a view change, the new coordinator removes all files except its own")
    protected boolean remove_all_files_on_view_change = false;
    @Property(description="The max number of times my own information should be written to the DB after a view change")
    protected int info_writer_max_writes_after_view = 2;
    @Property(description="Interval (in ms) at which the info writer should kick in")
    protected long info_writer_sleep_time = 10000L;
    @ManagedAttribute(description="Number of writes to the file system or cloud store")
    protected int writes;
    @ManagedAttribute(description="Number of reads from the file system or cloud store")
    protected int reads;
    protected File root_dir = null;
    protected static final FilenameFilter filter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(FILE_PING.SUFFIX);
        }
    };
    protected Future<?> info_writer;

    @Override
    public boolean isDynamic() {
        return true;
    }

    @ManagedAttribute(description="Whether the InfoWriter task is running")
    public synchronized boolean isInfoWriterRunning() {
        return this.info_writer != null && !this.info_writer.isDone();
    }

    @ManagedOperation(description="Causes the member to write its own information into the DB, replacing an existing entry")
    public void writeInfo() {
        if (this.is_coord) {
            this.writeAll();
        }
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.createRootDir();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                FILE_PING.this.remove(FILE_PING.this.cluster_name, FILE_PING.this.local_addr);
            }
        });
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.writes = 0;
        this.reads = 0;
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                View old_view = this.view;
                boolean previous_coord = this.is_coord;
                Object retval = super.down(evt);
                View new_view = (View)evt.getArg();
                this.handleView(new_view, old_view, previous_coord != this.is_coord);
                return retval;
            }
            case 4: {
                this.remove(this.cluster_name, this.local_addr);
            }
        }
        return super.down(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void findMembers(List<Address> members, boolean initial_discovery, Responses responses) {
        try {
            this.readAll(members, this.cluster_name, responses);
            if (responses.isEmpty()) {
                PhysicalAddress physical_addr = (PhysicalAddress)this.down(new Event(87, this.local_addr));
                PingData coord_data = new PingData(this.local_addr, true, UUID.get(this.local_addr), physical_addr).coord(this.is_coord);
                this.write(Collections.singletonList(coord_data), this.cluster_name);
                return;
            }
            PhysicalAddress phys_addr = (PhysicalAddress)this.down_prot.down(new Event(87, this.local_addr));
            PingData data = responses.findResponseFrom(this.local_addr);
            if (data != null && data.getPhysicalAddr().equals(phys_addr)) {
                if (data.isCoord() && initial_discovery) {
                    responses.clear();
                }
            } else {
                this.sendDiscoveryResponse(this.local_addr, phys_addr, UUID.get(this.local_addr), null, false);
            }
        }
        finally {
            responses.done();
        }
    }

    @Override
    protected boolean addDiscoveryResponseToCaches(Address mbr, String logical_name, PhysicalAddress physical_addr) {
        PhysicalAddress phys_addr = (PhysicalAddress)this.down_prot.down(new Event(87, mbr));
        boolean added = phys_addr == null || !phys_addr.equals(physical_addr);
        super.addDiscoveryResponseToCaches(mbr, logical_name, physical_addr);
        if (added && this.is_coord) {
            this.writeAll();
        }
        return added;
    }

    protected static String addressToFilename(Address mbr) {
        String logical_name = UUID.get(mbr);
        String name = FILE_PING.addressAsString(mbr) + (logical_name != null ? "." + logical_name + SUFFIX : SUFFIX);
        return regexp.matcher(name).replaceAll("-");
    }

    protected void createRootDir() {
        this.root_dir = new File(this.location);
        if (this.root_dir.exists()) {
            if (!this.root_dir.isDirectory()) {
                throw new IllegalArgumentException("location " + this.root_dir.getPath() + " is not a directory");
            }
        } else {
            this.root_dir.mkdirs();
        }
        if (!this.root_dir.exists()) {
            throw new IllegalArgumentException("location " + this.root_dir.getPath() + " could not be accessed");
        }
    }

    protected void handleView(View new_view, View old_view, boolean coord_changed) {
        if (this.is_coord) {
            if (coord_changed) {
                if (this.remove_all_files_on_view_change) {
                    this.removeAll(this.cluster_name);
                } else if (this.remove_old_coords_on_view_change) {
                    Address old_coord;
                    Address address = old_coord = old_view != null ? old_view.getCreator() : null;
                    if (old_coord != null) {
                        this.remove(this.cluster_name, old_coord);
                    }
                }
            }
            if (coord_changed || View.diff(old_view, new_view)[1].length > 0) {
                this.writeAll();
                if (this.remove_all_files_on_view_change || this.remove_old_coords_on_view_change) {
                    this.startInfoWriter();
                }
            }
        } else if (coord_changed) {
            this.remove(this.cluster_name, this.local_addr);
        }
    }

    protected void remove(String clustername, Address addr) {
        if (clustername == null || addr == null) {
            return;
        }
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            return;
        }
        this.log.debug("remove %s", clustername);
        String filename = FILE_PING.addressToFilename(addr);
        File file = new File(dir, filename);
        this.deleteFile(file);
    }

    protected void removeAll(String clustername) {
        File[] files;
        if (clustername == null) {
            return;
        }
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            return;
        }
        for (File file : files = dir.listFiles(filter)) {
            file.delete();
        }
    }

    protected void readAll(List<Address> members, String clustername, Responses responses) {
        File[] files;
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (File file : files = dir.listFiles(filter)) {
            List<PingData> list = null;
            for (int i = 0; i < 3; ++i) {
                if (file.exists()) {
                    try {
                        list = this.read(file);
                        if (list != null) {
                            break;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Util.sleep(50L);
            }
            if (list == null) {
                this.log.warn("failed reading " + file.getAbsolutePath());
                continue;
            }
            for (PingData data : list) {
                if (members == null || members.contains(data.getAddress())) {
                    responses.addResponse(data, true);
                }
                if (this.local_addr == null || this.local_addr.equals(data.getAddress())) continue;
                this.addDiscoveryResponseToCaches(data.getAddress(), data.getLogicalName(), data.getPhysicalAddr());
            }
        }
    }

    protected List<PingData> read(File file) throws Exception {
        return this.read(new FileInputStream(file));
    }

    @Override
    protected List<PingData> read(InputStream in) {
        try {
            List<PingData> list = super.read(in);
            return list;
        }
        finally {
            ++this.reads;
        }
    }

    protected void writeAll() {
        Map cache_contents = (Map)this.down_prot.down(new Event(88, false));
        ArrayList<PingData> list = new ArrayList<PingData>(cache_contents.size());
        for (Map.Entry entry : cache_contents.entrySet()) {
            Address addr = (Address)entry.getKey();
            PhysicalAddress phys_addr = (PhysicalAddress)entry.getValue();
            PingData data = new PingData(addr, true, UUID.get(addr), phys_addr).coord(addr.equals(this.local_addr));
            list.add(data);
        }
        this.write(list, this.cluster_name);
    }

    protected void write(List<PingData> list, String clustername) {
        File dir = new File(this.root_dir, clustername);
        if (!dir.exists()) {
            dir.mkdir();
        }
        String filename = FILE_PING.addressToFilename(this.local_addr);
        File destination = new File(dir, filename);
        try {
            this.write(list, new FileOutputStream(destination));
        }
        catch (Exception ioe) {
            this.log.error(Util.getMessage("AttemptToWriteDataFailedAt") + clustername + " : " + destination.getName(), ioe);
            this.deleteFile(destination);
        }
    }

    @Override
    protected void write(List<PingData> list, OutputStream out) throws Exception {
        try {
            super.write(list, out);
        }
        finally {
            ++this.writes;
        }
    }

    protected boolean deleteFile(File file) {
        boolean result = true;
        if (this.log.isTraceEnabled()) {
            this.log.trace("Attempting to delete file : " + file.getAbsolutePath());
        }
        if (file != null && file.exists()) {
            try {
                result = file.delete();
                this.log.trace("Deleted file result: " + file.getAbsolutePath() + " : " + result);
            }
            catch (Throwable e) {
                this.log.error(Util.getMessage("FailedToDeleteFile") + file.getAbsolutePath(), e);
            }
        }
        return result;
    }

    protected synchronized void startInfoWriter() {
        if (this.info_writer == null || this.info_writer.isDone()) {
            this.info_writer = this.timer.scheduleWithDynamicInterval(new InfoWriter(this.info_writer_max_writes_after_view, this.info_writer_sleep_time));
        }
    }

    protected synchronized void stopInfoWriter() {
        if (this.info_writer != null) {
            this.info_writer.cancel(false);
        }
    }

    protected class InfoWriter
    implements TimeScheduler.Task {
        protected final int max_writes;
        protected int num_writes;
        protected final long sleep_interval;

        public InfoWriter(int max_writes, long sleep_interval) {
            this.max_writes = max_writes;
            this.sleep_interval = sleep_interval;
        }

        @Override
        public long nextInterval() {
            if (++this.num_writes > this.max_writes) {
                return 0L;
            }
            return Math.max(1000L, Util.random(this.sleep_interval));
        }

        @Override
        public void run() {
            FILE_PING.this.writeAll();
        }
    }
}

