/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.datamodeller.backend.server.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.shared.validation.model.ValidationMessage;
import org.kie.workbench.common.screens.datamodeller.backend.server.validation.PersistableClassValidator;
import org.kie.workbench.common.screens.datamodeller.backend.server.validation.PersistenceDescriptorValidationMessages;
import org.kie.workbench.common.screens.datamodeller.backend.server.validation.PropertyValidator;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceDescriptorModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.PersistenceUnitModel;
import org.kie.workbench.common.screens.datamodeller.model.persistence.TransactionType;
import org.kie.workbench.common.screens.datamodeller.validation.PersistenceDescriptorValidator;
import org.kie.workbench.common.services.backend.project.ProjectClassLoaderHelper;
import org.kie.workbench.common.services.shared.project.KieProject;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;

@ApplicationScoped
public class PersistenceDescriptorValidatorImpl
implements PersistenceDescriptorValidator {
    private KieProjectService projectService;
    private ProjectClassLoaderHelper projectClassLoaderHelper;
    private PersistableClassValidator classValidator = new PersistableClassValidator();
    private PropertyValidator propertyValidator = new PropertyValidator();

    public PersistenceDescriptorValidatorImpl() {
    }

    @Inject
    public PersistenceDescriptorValidatorImpl(KieProjectService projectService, ProjectClassLoaderHelper projectClassLoaderHelper) {
        this.projectService = projectService;
        this.projectClassLoaderHelper = projectClassLoaderHelper;
    }

    public List<ValidationMessage> validate(Path path, PersistenceDescriptorModel model) {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        KieProject project = (KieProject)this.projectService.resolveProject(path);
        if (project == null) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.DESCRIPTOR_NOT_BELONG_TO_PROJECT_ID, "Persistence descriptor do not belong to a valid project", new String[0]));
            return messages;
        }
        if (model.getPersistenceUnit() == null) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTENCE_UNIT_NOT_FOUND_ID, "Persistence descriptor must have a persistence unit", new String[0]));
            return messages;
        }
        PersistenceUnitModel unitModel = model.getPersistenceUnit();
        if (unitModel.getName() == null || unitModel.getName().trim().isEmpty()) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTENCE_UNIT_NAME_EMPTY_ID, "Persistence unit name must have a non empty String value", new String[0]));
        }
        if (unitModel.getProvider() == null || unitModel.getProvider().trim().isEmpty()) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTENCE_UNIT_PROVIDER_ID, "Persistence unit provider must have a non empty String value", new String[0]));
        }
        if (unitModel.getTransactionType() == null) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTENCE_UNIT_TRANSACTION_TYPE_EMPTY_ID, "Persistence must have a Transaction Type", new String[0]));
        } else if (unitModel.getTransactionType() == TransactionType.JTA && (unitModel.getJtaDataSource() == null || unitModel.getJtaDataSource().trim().isEmpty())) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTENCE_UNIT_JTA_DATASOURCE_EMPTY_ID, "JTA transaction type must have a non empty Data Source configured", new String[0]));
        } else if (unitModel.getTransactionType() == TransactionType.RESOURCE_LOCAL && (unitModel.getNonJtaDataSource() == null || unitModel.getNonJtaDataSource().trim().isEmpty())) {
            messages.add(PersistenceDescriptorValidationMessages.newErrorMessage(PersistenceDescriptorValidationMessages.PERSISTENCE_UNIT_NON_JTA_DATASOURCE_EMPTY_ID, "Resource transaction type must have a non empty Data Source configured", new String[0]));
        }
        if (unitModel.getClasses() != null && !unitModel.getClasses().isEmpty()) {
            ClassLoader projectClassLoader = this.projectClassLoaderHelper.getProjectClassLoader(project);
            unitModel.getClasses().forEach(clazz -> Optional.ofNullable(this.classValidator.validate((String)clazz, projectClassLoader)).ifPresent(messages::addAll));
        }
        if (unitModel.getProperties() != null) {
            int[] index = new int[]{1};
            unitModel.getProperties().forEach(property -> {
                int n = index[0];
                index[0] = n + 1;
                messages.addAll(Optional.ofNullable(this.propertyValidator.validate(property.getName(), property.getValue(), n)).orElse(Collections.emptyList()));
            });
        }
        return messages;
    }
}

