/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.services.backend.builder.service;

import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.guvnor.common.services.project.builder.model.BuildResults;
import org.guvnor.common.services.project.builder.model.IncrementalBuildResults;
import org.guvnor.common.services.project.builder.service.BuildService;
import org.guvnor.common.services.project.model.Project;
import org.guvnor.common.services.project.service.DeploymentMode;
import org.jboss.errai.bus.server.annotations.Service;
import org.kie.workbench.common.services.backend.builder.ala.LocalBuildConfig;
import org.kie.workbench.common.services.backend.builder.core.Builder;
import org.kie.workbench.common.services.backend.builder.core.LRUBuilderCache;
import org.kie.workbench.common.services.backend.builder.service.BuildServiceHelper;
import org.kie.workbench.common.services.shared.project.KieProjectService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.ResourceChange;

@Service
@ApplicationScoped
public class BuildServiceImpl
implements BuildService {
    private BuildServiceHelper buildServiceHelper;
    private KieProjectService projectService;
    private LRUBuilderCache cache;

    public BuildServiceImpl() {
    }

    @Inject
    public BuildServiceImpl(KieProjectService projectService, BuildServiceHelper buildServiceHelper, LRUBuilderCache cache) {
        this.projectService = projectService;
        this.buildServiceHelper = buildServiceHelper;
        this.cache = cache;
    }

    public BuildResults build(Project project) {
        return this.buildServiceHelper.localBuild(project);
    }

    public void build(Project project, Consumer<Builder> consumer) {
        this.buildServiceHelper.localBuild(project, localBinaryConfig -> consumer.accept(localBinaryConfig.getBuilder()));
    }

    public BuildResults buildAndDeploy(Project project) {
        return this.buildAndDeploy(project, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Project project, DeploymentMode mode) {
        return this.buildAndDeploy(project, false, mode);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers) {
        return this.buildAndDeploy(project, suppressHandlers, DeploymentMode.VALIDATED);
    }

    public BuildResults buildAndDeploy(Project project, boolean suppressHandlers, DeploymentMode mode) {
        return this.buildServiceHelper.localBuildAndDeploy(project, mode, suppressHandlers);
    }

    public boolean isBuilt(Project project) {
        Builder builder = this.cache.assertBuilder(project);
        return builder.isBuilt();
    }

    public IncrementalBuildResults addPackageResource(Path resource) {
        return this.buildIncrementally(resource, LocalBuildConfig.BuildType.INCREMENTAL_ADD_RESOURCE);
    }

    public IncrementalBuildResults deletePackageResource(Path resource) {
        return this.buildIncrementally(resource, LocalBuildConfig.BuildType.INCREMENTAL_DELETE_RESOURCE);
    }

    public IncrementalBuildResults updatePackageResource(Path resource) {
        return this.buildIncrementally(resource, LocalBuildConfig.BuildType.INCREMENTAL_UPDATE_RESOURCE);
    }

    private IncrementalBuildResults buildIncrementally(Path resource, LocalBuildConfig.BuildType buildType) {
        Project project = this.projectService.resolveProject(resource);
        if (project == null) {
            return new IncrementalBuildResults();
        }
        return this.buildServiceHelper.localBuild(project, buildType, resource);
    }

    public IncrementalBuildResults applyBatchResourceChanges(Project project, Map<Path, Collection<ResourceChange>> changes) {
        if (project == null) {
            return new IncrementalBuildResults();
        }
        return this.buildServiceHelper.localBuild(project, changes);
    }
}

