/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.client.modeldriven.brl;

import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;

public class SingleFieldConstraint
extends BaseSingleFieldConstraint
implements FieldConstraint {
    private String fieldBinding;
    private String factType;
    private String fieldName;
    private String fieldType;
    private FieldConstraint parent;
    private String id;
    public ConnectiveConstraint[] connectives;

    public SingleFieldConstraint(String factType, String fieldName, String fieldType, FieldConstraint parent) {
        this.factType = factType;
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.parent = parent;
    }

    public SingleFieldConstraint(String fieldName) {
        this.factType = null;
        this.fieldName = fieldName;
        this.fieldType = "";
        this.parent = null;
    }

    public SingleFieldConstraint() {
        this.factType = null;
        this.fieldName = null;
        this.fieldType = "";
        this.parent = null;
    }

    public void setFieldBinding(String fieldBinding) {
        this.fieldBinding = fieldBinding;
    }

    public String getFieldBinding() {
        return this.fieldBinding;
    }

    public void addNewConnective() {
        String fieldName = this.fieldName;
        String fieldType = this.fieldType;
        String factType = this.factType;
        if (this.connectives == null) {
            this.connectives = new ConnectiveConstraint[]{new ConnectiveConstraint(factType, fieldName, fieldType)};
        } else {
            ConnectiveConstraint[] newList = new ConnectiveConstraint[this.connectives.length + 1];
            for (int i = 0; i < this.connectives.length; ++i) {
                newList[i] = this.connectives[i];
            }
            newList[this.connectives.length] = new ConnectiveConstraint(factType, fieldName, fieldType);
            this.connectives = newList;
        }
    }

    public void removeConnective(int index) {
        if (this.connectives == null) {
            return;
        }
        if (index < 0 || index > this.connectives.length) {
            throw new IndexOutOfBoundsException();
        }
        int newIndex = 0;
        ConnectiveConstraint[] newList = new ConnectiveConstraint[this.connectives.length - 1];
        for (int i = 0; i < this.connectives.length; ++i) {
            if (i == index) continue;
            newList[newIndex++] = this.connectives[i];
        }
        this.connectives = newList;
    }

    public boolean isBound() {
        return this.getFieldBinding() != null && this.getFieldBinding().length() > 0;
    }

    public String getFactType() {
        return this.factType;
    }

    public void setFactType(String factType) {
        this.factType = factType;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public void setParent(FieldConstraint parent) {
        this.parent = parent;
    }

    public FieldConstraint getParent() {
        return this.parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }
}

