/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.testscenarios.util;

import java.lang.reflect.Method;
import java.util.Date;

public class FieldTypeResolver {
    public static Class<?> getFieldType(String fieldName, Object factObject) {
        for (Method method : factObject.getClass().getDeclaredMethods()) {
            if (!FieldTypeResolver.hasMutator(fieldName, method)) continue;
            return method.getParameterTypes()[0];
        }
        throw new IllegalArgumentException("No field named: " + fieldName);
    }

    public static boolean isDate(String fieldName, Object factObject) {
        for (Method method : factObject.getClass().getDeclaredMethods()) {
            if (!FieldTypeResolver.hasMutator(fieldName, method) || !Date.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            return true;
        }
        return false;
    }

    private static boolean hasMutator(String fieldName, Method method) {
        return (method.getName().equals(fieldName) || method.getName().equals("set" + FieldTypeResolver.capitalize(fieldName))) && method.getParameterTypes().length == 1;
    }

    private static String capitalize(String fieldName) {
        if (fieldName.length() == 0) {
            return "";
        }
        if (fieldName.length() == 1) {
            return fieldName.toUpperCase();
        }
        String firstLetter = fieldName.substring(0, 1);
        String tail = fieldName.substring(1);
        return firstLetter.toUpperCase() + tail;
    }
}

