/*
 * Decompiled with CFR 0.152.
 */
package org.drools.workbench.jcr2vfsmigration.config;

import java.io.File;
import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class FSExportConfig {
    private static final Logger logger = LoggerFactory.getLogger(FSExportConfig.class);
    private static final String FORMAT_STR = "runMigration  [options...]";
    private File inputJcrRepository;
    private File exportTempDir;
    private boolean forceOverwriteTempOutputDirectory;

    public File getInputJcrRepository() {
        return this.inputJcrRepository;
    }

    public File getExportTempDir() {
        return this.exportTempDir;
    }

    public boolean parseArgs(String[] args) {
        CommandLine commandLine;
        Options options = new Options();
        options.addOption("h", "help", false, "help for the command.");
        options.addOption("i", "inputJcrRepository", true, "The Guvnor 5 JCR repository");
        options.addOption("o", "exportTempDir", true, "The temporary export directory");
        options.addOption("f", "forceOverwriteTempOutputDirectory", false, "Force overwriting the temporary output directory");
        HelpFormatter formatter = new HelpFormatter();
        try {
            commandLine = new BasicParser().parse(options, args);
        }
        catch (ParseException e) {
            formatter.printHelp(FORMAT_STR, options);
            return false;
        }
        if (commandLine.hasOption("h")) {
            formatter.printHelp(FORMAT_STR, options);
            return false;
        }
        return this.parseArgInputJcrRepository(commandLine) && this.parseArgExportTempDir(commandLine);
    }

    private boolean parseArgInputJcrRepository(CommandLine commandLine) {
        this.inputJcrRepository = new File(commandLine.getOptionValue("i", "inputJcr"));
        if (!this.inputJcrRepository.exists()) {
            logger.error("The inputJcrRepository ({}) does not exist. Please make sure your inputJcrRepository exists,or use -i to specify alternative location.", (Object)this.inputJcrRepository.getAbsolutePath());
            return false;
        }
        try {
            this.inputJcrRepository = this.inputJcrRepository.getCanonicalFile();
        }
        catch (IOException e) {
            logger.error("The inputJcrRepository ({}) has issues!", (Object)this.inputJcrRepository, (Object)e);
            return false;
        }
        return true;
    }

    private boolean parseArgExportTempDir(CommandLine commandLine) {
        this.exportTempDir = new File(commandLine.getOptionValue("o", "./jcrExport"));
        this.forceOverwriteTempOutputDirectory = commandLine.hasOption("f");
        try {
            if (this.exportTempDir.isFile()) {
                logger.error("The specified export location ({}) is not a directory!", (Object)this.exportTempDir.getAbsolutePath());
                return false;
            }
            if (this.exportTempDir.exists()) {
                if (this.forceOverwriteTempOutputDirectory) {
                    FileUtils.deleteDirectory((File)this.exportTempDir);
                } else {
                    logger.error("The export directory ({}) already exists!", (Object)this.exportTempDir.getAbsolutePath());
                    return false;
                }
            }
            FileUtils.forceMkdir((File)this.exportTempDir);
        }
        catch (Exception e) {
            logger.error("The export directory ({}) has issues!", (Object)this.exportTempDir, (Object)e);
            return false;
        }
        return true;
    }
}

