/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.sis.internal.jdk7.Objects;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.referencing.operation.AbstractCoordinateOperation;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.FactoryException;

final class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private final List<SingleOperation> operations;

    public DefaultConcatenatedOperation(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        this(map, new ArrayList<SingleOperation>(coordinateOperationArray.length), coordinateOperationArray, mathTransformFactory);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, ArrayList<SingleOperation> arrayList, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        this(map, DefaultConcatenatedOperation.expand(map, coordinateOperationArray, arrayList, mathTransformFactory, true), arrayList);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, MathTransform mathTransform, List<SingleOperation> list) {
        super(DefaultConcatenatedOperation.mergeAccuracy(map, list), list.get(0).getSourceCRS(), list.get(list.size() - 1).getTargetCRS(), null, mathTransform);
        this.operations = UnmodifiableArrayList.wrap(list.toArray(new SingleOperation[list.size()]));
    }

    private static MathTransform expand(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, List<SingleOperation> list, MathTransformFactory mathTransformFactory, boolean bl) throws FactoryException {
        Object object = null;
        ArgumentChecks.ensureNonNull("operations", coordinateOperationArray);
        for (int i = 0; i < coordinateOperationArray.length; ++i) {
            int n;
            int n2;
            Object object2;
            Object object3;
            ArgumentChecks.ensureNonNullElement("operations", i, coordinateOperationArray);
            CoordinateOperation coordinateOperation = coordinateOperationArray[i];
            if (coordinateOperation instanceof SingleOperation) {
                list.add((SingleOperation)coordinateOperation);
            } else if (coordinateOperation instanceof ConcatenatedOperation) {
                object3 = (ConcatenatedOperation)coordinateOperation;
                object2 = object3.getOperations();
                DefaultConcatenatedOperation.expand(map, object2.toArray(new CoordinateOperation[object2.size()]), list, mathTransformFactory, false);
            } else {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)28, "operations[" + i + ']', coordinateOperation.getClass()));
            }
            if (i != 0 && (object3 = coordinateOperationArray[i - 1].getTargetCRS()) != null && (object2 = coordinateOperation.getSourceCRS()) != null && (n2 = object3.getCoordinateSystem().getDimension()) != (n = object2.getCoordinateSystem().getDimension())) {
                throw new IllegalArgumentException(Errors.getResources(map).getString((short)59, "operations[" + i + "].sourceCRS", n2, n));
            }
            if (!bl) continue;
            object3 = coordinateOperation.getMathTransform();
            object = object == null ? object3 : mathTransformFactory.createConcatenatedTransform((MathTransform)object, (MathTransform)object3);
        }
        if (bl && list.size() <= 1) {
            throw new IllegalArgumentException(Errors.getResources(map).getString((short)148, 2, CoordinateOperation.class));
        }
        return object;
    }

    private static Map<String, ?> mergeAccuracy(Map<String, ?> map, List<? extends CoordinateOperation> list) {
        if (!map.containsKey("coordinateOperationAccuracy")) {
            LinkedHashSet<PositionalAccuracy> linkedHashSet = null;
            for (CoordinateOperation coordinateOperation : list) {
                Collection<PositionalAccuracy> collection;
                if (!(coordinateOperation instanceof Transformation) || Containers.isNullOrEmpty(collection = coordinateOperation.getCoordinateOperationAccuracy())) continue;
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<PositionalAccuracy>();
                }
                linkedHashSet.addAll(collection);
            }
            if (linkedHashSet != null) {
                HashMap<String, ?> hashMap = new HashMap(map);
                hashMap.put("coordinateOperationAccuracy", linkedHashSet.toArray(new PositionalAccuracy[linkedHashSet.size()]));
                return hashMap;
            }
        }
        return map;
    }

    protected DefaultConcatenatedOperation(ConcatenatedOperation concatenatedOperation) {
        super(concatenatedOperation);
        this.operations = concatenatedOperation.getOperations();
    }

    public static DefaultConcatenatedOperation castOrCopy(ConcatenatedOperation concatenatedOperation) {
        return concatenatedOperation == null || concatenatedOperation instanceof DefaultConcatenatedOperation ? (DefaultConcatenatedOperation)concatenatedOperation : new DefaultConcatenatedOperation(concatenatedOperation);
    }

    public Class<? extends ConcatenatedOperation> getInterface() {
        return ConcatenatedOperation.class;
    }

    @Override
    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(Object object, ComparisonMode comparisonMode) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, comparisonMode)) {
            if (comparisonMode == ComparisonMode.STRICT) {
                return Objects.equals(this.operations, ((DefaultConcatenatedOperation)object).operations);
            }
            return Utilities.deepEquals(this.getOperations(), ((ConcatenatedOperation)object).getOperations(), comparisonMode);
        }
        return false;
    }

    @Override
    protected long computeHashCode() {
        return super.computeHashCode() + (long)(37 * this.operations.hashCode());
    }
}

