/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.repositories;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.deployment.DeploymentException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.ArtifactImpl;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.kie.scanner.Aether;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.apache.commons.io.FilenameUtils;

public class FileSystemArtifactRepository
implements ArtifactRepository {
    private final String name;
    private Logger logger = LoggerFactory.getLogger(FileSystemArtifactRepository.class);
    private RemoteRepository repository;
    private String repositoryDirectory;

    public FileSystemArtifactRepository(String name, String dir) {
        this.name = name;
        String m2RepoDir = FilenameUtils.normalize((String)(dir.trim() + File.separatorChar));
        this.logger.info("Maven Repository root set to: " + m2RepoDir);
        File root = new File(m2RepoDir);
        if (!root.exists()) {
            this.logger.info("Creating Maven Repository root: " + m2RepoDir);
            root.mkdirs();
        }
        this.repositoryDirectory = dir;
        this.repository = this.createRepository(dir);
        Aether.getAether().getRepositories().add(this.getRepository());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<File> listFiles(List<String> wildcards) {
        return FileUtils.listFiles((File)new File(this.getRepositoryDirectory()), (IOFileFilter)new WildcardFileFilter(wildcards, IOCase.INSENSITIVE), (IOFileFilter)DirectoryFileFilter.DIRECTORY);
    }

    @Override
    public Collection<Artifact> listArtifacts(List<String> wildcards) {
        Collection<File> files = this.listFiles(wildcards);
        return files.stream().map(file -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("repository", this.getName());
            ArtifactImpl artifact = new ArtifactImpl((File)file);
            artifact.setProperties(map);
            return artifact;
        }).collect(Collectors.toList());
    }

    @Override
    public boolean containsArtifact(GAV gav) {
        ArtifactRequest request = this.createArtifactRequest(gav);
        try {
            Aether aether = Aether.getAether();
            aether.getSystem().resolveArtifact(aether.getSession(), request);
        }
        catch (ArtifactResolutionException e) {
            this.logger.trace("Artifact {} not found.", (Object)gav, (Object)e);
            return false;
        }
        this.logger.trace("Artifact {} found.", (Object)gav);
        return true;
    }

    @Override
    public File getArtifactFileFromRepository(GAV gav) {
        ArtifactRequest request = this.createArtifactRequest(gav);
        ArtifactResult result = null;
        try {
            result = Aether.getAether().getSystem().resolveArtifact(Aether.getAether().getSession(), request);
        }
        catch (ArtifactResolutionException e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        if (result == null) {
            return null;
        }
        File artifactFile = null;
        if (result.isResolved() && !result.isMissing()) {
            artifactFile = result.getArtifact().getFile();
        }
        return artifactFile;
    }

    @Override
    public void deploy(String pom, Artifact ... artifacts) {
        try {
            DeployRequest deployRequest = new DeployRequest();
            for (Artifact artifact : artifacts) {
                deployRequest.addArtifact(artifact);
            }
            deployRequest.setRepository(this.getRepository());
            Aether.getAether().getSystem().deploy(Aether.getAether().getSession(), deployRequest);
        }
        catch (DeploymentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(GAV gav) {
    }

    private ArtifactRequest createArtifactRequest(GAV gav) {
        ArtifactRequest request = new ArtifactRequest();
        request.addRepository(this.getRepository());
        DefaultArtifact artifact = new DefaultArtifact(gav.getGroupId(), gav.getArtifactId(), "jar", gav.getVersion());
        request.setArtifact((Artifact)artifact);
        return request;
    }

    protected RemoteRepository getRepository() {
        return this.repository;
    }

    private RemoteRepository createRepository(String dir) {
        File m2RepoDir = new File(dir);
        if (!m2RepoDir.exists()) {
            this.logger.error("Repository root does not exist: " + dir);
            throw new IllegalArgumentException("Repository root does not exist: " + dir);
        }
        try {
            String localRepositoryUrl = m2RepoDir.toURI().toURL().toExternalForm();
            return new RemoteRepository.Builder("guvnor-m2-repo", "default", localRepositoryUrl).setSnapshotPolicy(new RepositoryPolicy(true, "daily", "warn")).setReleasePolicy(new RepositoryPolicy(true, "always", "warn")).build();
        }
        catch (MalformedURLException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String getRepositoryDirectory() {
        return this.repositoryDirectory;
    }
}

