/*
 * Decompiled with CFR 0.152.
 */
package org.guvnor.m2repo.backend.server.repositories;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.installation.InstallationException;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.backend.server.repositories.ArtifactRepository;
import org.kie.scanner.Aether;

public class LocalArtifactRepository
implements ArtifactRepository {
    private final String name;

    public LocalArtifactRepository(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Collection<File> listFiles(List<String> wildcards) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public Collection<Artifact> listArtifacts(List<String> wildcards) {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean containsArtifact(GAV gav) {
        return false;
    }

    @Override
    public File getArtifactFileFromRepository(GAV gav) {
        return null;
    }

    @Override
    public void deploy(String pom, Artifact ... artifacts) {
        try {
            InstallRequest installRequest = new InstallRequest();
            for (Artifact artifact : artifacts) {
                installRequest.addArtifact(artifact);
            }
            Aether.getAether().getSystem().install(Aether.getAether().getSession(), installRequest);
        }
        catch (InstallationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void delete(GAV gav) {
    }
}

