/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.regexp.shared.RegExp;
import java.math.BigDecimal;
import org.drools.guvnor.client.common.AbstractRestrictedEntryTextBox;

public class NumericTextBox
extends AbstractRestrictedEntryTextBox {
    private static final RegExp VALID = RegExp.compile((String)"(^[-]?[0-9]*\\.?[0-9]*([eE][-+]?[0-9]*)?$)");

    public NumericTextBox() {
        super(false);
    }

    public NumericTextBox(boolean allowEmptyValue) {
        super(allowEmptyValue);
    }

    @Override
    public boolean isValidValue(String value, boolean isOnFocusLost) {
        boolean isValid = VALID.test(value);
        if (!isValid) {
            return isValid;
        }
        if (!isOnFocusLost && "-".equals(value)) {
            return true;
        }
        try {
            BigDecimal check = new BigDecimal(value);
        }
        catch (NumberFormatException nfe) {
            isValid = "".equals(value) && this.allowEmptyValue;
        }
        return isValid;
    }
}

