/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.DiscussionRecord;
import org.drools.guvnor.client.rpc.PushClient;
import org.drools.guvnor.client.rpc.PushResponse;
import org.drools.guvnor.client.rpc.ServerPushNotification;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.util.Util;

public class DiscussionWidget
extends Composite {
    private static ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private static AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
    private VerticalPanel commentList = new VerticalPanel();
    private VerticalPanel newCommentLayout = new VerticalPanel();
    private Artifact artifact;
    private ServerPushNotification pushNotify;
    private int lastCount = 0;
    private boolean readOnly;

    protected void onUnload() {
        super.onUnload();
        PushClient.instance().unsubscribe(this.pushNotify);
    }

    public DiscussionWidget(final Artifact artifact, boolean readOnly) {
        this.artifact = artifact;
        this.readOnly = readOnly;
        DecoratedDisclosurePanel discussionPanel = new DecoratedDisclosurePanel(constants.Discussion());
        discussionPanel.setWidth("100%");
        this.commentList.setWidth("100%");
        VerticalPanel discussionLayout = new VerticalPanel();
        discussionLayout.setWidth("90%");
        this.newCommentLayout.setWidth("100%");
        this.refreshDiscussion();
        this.showNewCommentButton();
        discussionLayout.add((Widget)this.newCommentLayout);
        discussionLayout.add((Widget)this.commentList);
        discussionPanel.setContent((Widget)discussionLayout);
        this.pushNotify = new ServerPushNotification(){

            @Override
            public void messageReceived(PushResponse response) {
                if ("discussion".equals(response.messageType) && artifact.getUuid().equals(response.message)) {
                    System.err.println("Refreshing discussion...");
                    DiscussionWidget.this.refreshDiscussion();
                }
            }
        };
        PushClient.instance().subscribe(this.pushNotify);
        this.initWidget((Widget)discussionPanel);
    }

    public void refreshDiscussion() {
        assetService.loadDiscussionForAsset(this.artifact.getUuid(), new GenericCallback<List<DiscussionRecord>>(){

            public void onSuccess(List<DiscussionRecord> result) {
                DiscussionWidget.this.updateCommentList(result);
            }
        });
    }

    private void updateCommentList(List<DiscussionRecord> ls) {
        if (ls.size() == this.lastCount) {
            return;
        }
        this.commentList.clear();
        this.lastCount = ls.size();
        for (int rcdCounter = this.lastCount - 1; rcdCounter >= 0; --rcdCounter) {
            DiscussionRecord dr = ls.get(rcdCounter);
            this.appendComment(dr);
        }
    }

    private Widget appendComment(DiscussionRecord r) {
        SmallLabel hrd = new SmallLabel(constants.smallCommentBy0On1Small(r.author, new Date(r.timestamp)));
        hrd.addStyleName("discussion-header");
        this.commentList.add((Widget)hrd);
        String[] parts = r.note.split("\n");
        if (parts.length > 0) {
            StringBuilder txtBuilder = new StringBuilder();
            for (int i = 0; i < parts.length; ++i) {
                txtBuilder.append(parts[i]);
                if (i == parts.length - 1) continue;
                txtBuilder.append("<br/>");
            }
            HTML hth = new HTML(txtBuilder.toString());
            hth.setStyleName("form-field");
            this.commentList.add((Widget)hth);
        } else {
            Label lbl = new Label(r.note);
            lbl.setStyleName("form-field");
            this.commentList.add((Widget)lbl);
        }
        this.commentList.add((Widget)new HTML("<br/>"));
        return hrd;
    }

    private void showNewCommentButton() {
        this.newCommentLayout.clear();
        HorizontalPanel hp = new HorizontalPanel();
        Button createNewComment = new Button(constants.AddADiscussionComment());
        createNewComment.setEnabled(!this.readOnly);
        hp.add((Widget)createNewComment);
        if (UserCapabilities.INSTANCE.hasCapability(Capability.SHOW_ADMIN)) {
            Button adminClearAll = new Button(constants.EraseAllComments());
            adminClearAll.setEnabled(!this.readOnly);
            hp.add((Widget)adminClearAll);
            adminClearAll.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent sender) {
                    if (Window.confirm((String)constants.EraseAllCommentsWarning())) {
                        assetService.clearAllDiscussionsForAsset(DiscussionWidget.this.artifact.getUuid(), new GenericCallback<Void>(){

                            public void onSuccess(Void v) {
                                DiscussionWidget.this.updateCommentList(new ArrayList());
                            }
                        });
                    }
                }
            });
        }
        final String feedURL = GWT.getModuleBaseURL() + "feed/discussion?package=" + ((Asset)this.artifact).getMetaData().getModuleName() + "&assetName=" + URL.encode((String)this.artifact.getName()) + "&viewUrl=" + Util.getSelfURL();
        Image image = GuvnorImages.INSTANCE.Feed();
        image.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                Window.open((String)feedURL, (String)"_blank", null);
            }
        });
        hp.add((Widget)image);
        this.newCommentLayout.add((Widget)hp);
        this.newCommentLayout.setCellHorizontalAlignment((Widget)hp, HasHorizontalAlignment.ALIGN_RIGHT);
        createNewComment.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent sender) {
                DiscussionWidget.this.showAddNewComment();
            }
        });
    }

    private void showAddNewComment() {
        this.newCommentLayout.clear();
        final TextArea comment = new TextArea();
        comment.setWidth("100%");
        this.newCommentLayout.add((Widget)comment);
        Button ok = new Button(constants.OK());
        Button cancel = new Button(constants.Cancel());
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent sender) {
                DiscussionWidget.this.sendNewComment(comment.getText());
            }
        });
        cancel.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent sender) {
                DiscussionWidget.this.showNewCommentButton();
            }
        });
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)ok);
        hp.add((Widget)cancel);
        this.newCommentLayout.add((Widget)hp);
        comment.setFocus(true);
    }

    private void sendNewComment(String text) {
        this.newCommentLayout.clear();
        this.newCommentLayout.add((Widget)new Image(images.spinner()));
        assetService.addToDiscussionForAsset(this.artifact.getUuid(), text, new GenericCallback<List<DiscussionRecord>>(){

            public void onSuccess(List<DiscussionRecord> result) {
                DiscussionWidget.this.showNewCommentButton();
                DiscussionWidget.this.updateCommentList(result);
            }
        });
    }
}

