/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.Popup;

public class PopupListWidget
extends Popup {
    protected int minimumWidth = 500;
    protected int minimumHeight = 200;
    @UiField
    protected ScrollPanel listContainer;
    @UiField
    protected VerticalPanel list;
    @UiField
    protected Button cmdOk;
    private Widget popupContent;
    private static PopupListWidgetBinder uiBinder = (PopupListWidgetBinder)GWT.create(PopupListWidgetBinder.class);

    public PopupListWidget() {
        this.setModal(true);
        this.popupContent = (Widget)uiBinder.createAndBindUi((Object)this);
        int height = this.getPopupHeight();
        int width = this.getPopupWidth();
        this.listContainer.setHeight(height + "px");
        this.listContainer.setWidth(width + "px");
    }

    public PopupListWidget(int width, int height) {
        this.setModal(false);
        this.popupContent = (Widget)uiBinder.createAndBindUi((Object)this);
        this.listContainer.setHeight(height + "px");
        this.listContainer.setWidth(width + "px");
    }

    public void addListItem(Widget w) {
        this.list.add(w);
    }

    @Override
    public Widget getContent() {
        return this.popupContent;
    }

    private int getPopupWidth() {
        int w = (int)((double)Window.getClientWidth() * 0.75);
        if (w < this.minimumWidth) {
            w = this.minimumWidth;
        }
        return w;
    }

    protected int getPopupHeight() {
        int h = (int)((double)Window.getClientHeight() * 0.75);
        if (h < this.minimumHeight) {
            h = this.minimumHeight;
        }
        return h;
    }

    @UiHandler(value={"cmdOk"})
    protected void cmdOkOnClickEvent(ClickEvent event) {
        this.hide();
    }

    static interface PopupListWidgetBinder
    extends UiBinder<Widget, PopupListWidget> {
    }
}

