/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.tables;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.DateCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.view.client.AsyncDataProvider;
import com.google.gwt.view.client.HasData;
import java.util.Date;
import java.util.List;
import org.drools.guvnor.client.common.AssetEditorFactory;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.resources.ComparableImageResource;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.rpc.AssetPageRequest;
import org.drools.guvnor.client.rpc.AssetPageRow;
import org.drools.guvnor.client.rpc.PageResponse;
import org.drools.guvnor.client.widgets.tables.AbstractAssetPagedTable;
import org.drools.guvnor.client.widgets.tables.ColumnPicker;
import org.drools.guvnor.client.widgets.tables.ComparableImageResourceCell;
import org.drools.guvnor.client.widgets.tables.RuleEnabledStateCell;
import org.drools.guvnor.client.widgets.tables.SortableHeader;
import org.drools.guvnor.client.widgets.tables.SortableHeaderGroup;
import org.drools.guvnor.client.widgets.tables.TitledTextCell;
import org.drools.guvnor.client.widgets.tables.TitledTextColumn;

public class AssetPagedTable
extends AbstractAssetPagedTable<AssetPageRow> {
    private static final int PAGE_SIZE = 10;
    private ClientFactory clientFactory;

    public AssetPagedTable(String packageUuid, List<String> formatInList, Boolean formatIsRegistered, ClientFactory clientFactory) {
        this(packageUuid, formatInList, formatIsRegistered, null, clientFactory);
    }

    public AssetPagedTable(final String packageUuid, final List<String> formatInList, final Boolean formatIsRegistered, String feedURL, ClientFactory clientFactory) {
        super(10, feedURL, clientFactory);
        this.clientFactory = clientFactory;
        this.setDataProvider(new AsyncDataProvider<AssetPageRow>(){

            protected void onRangeChanged(HasData<AssetPageRow> display) {
                AssetPageRequest request = new AssetPageRequest(packageUuid, formatInList, formatIsRegistered, AssetPagedTable.this.pager.getPageStart(), AssetPagedTable.this.pageSize);
                AssetPagedTable.this.assetService.findAssetPage(request, (AsyncCallback<PageResponse<AssetPageRow>>)new GenericCallback<PageResponse<AssetPageRow>>(){

                    public void onSuccess(PageResponse<AssetPageRow> response) {
                        this.updateRowCount(response.getTotalRowSize(), response.isTotalRowSizeExact());
                        this.updateRowData(response.getStartRowIndex(), response.getPageRowList());
                    }
                });
            }
        });
    }

    @Override
    protected void addAncillaryColumns(ColumnPicker<AssetPageRow> columnPicker, SortableHeaderGroup<AssetPageRow> sortableHeaderGroup) {
        Column<AssetPageRow, ComparableImageResource> formatColumn = new Column<AssetPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(AssetPageRow row) {
                AssetEditorFactory factory = AssetPagedTable.this.clientFactory.getAssetEditorFactory();
                return new ComparableImageResource(row.getFormat(), factory.getAssetEditorIcon(row.getFormat()));
            }
        };
        columnPicker.addColumn(formatColumn, new SortableHeader<AssetPageRow, ComparableImageResource>(sortableHeaderGroup, constants.Format(), formatColumn), true);
        Column<AssetPageRow, ComparableImageResource> validColumn = new Column<AssetPageRow, ComparableImageResource>((Cell)new ComparableImageResourceCell()){

            public ComparableImageResource getValue(AssetPageRow row) {
                return new ComparableImageResource(row.getValid().toString(), GuvnorImages.INSTANCE.getValidImage(row.getValid()));
            }
        };
        columnPicker.addColumn(validColumn, new SortableHeader<AssetPageRow, ComparableImageResource>(sortableHeaderGroup, constants.Valid(), validColumn), true);
        TitledTextColumn<AssetPageRow> titleColumn = new TitledTextColumn<AssetPageRow>(){

            public TitledTextCell.TitledText getValue(AssetPageRow row) {
                return new TitledTextCell.TitledText(row.getName(), row.getAbbreviatedDescription());
            }
        };
        columnPicker.addColumn(titleColumn, new SortableHeader<AssetPageRow, TitledTextCell.TitledText>(sortableHeaderGroup, constants.Name(), titleColumn), true);
        TextColumn<AssetPageRow> packageNameColumn = new TextColumn<AssetPageRow>(){

            public String getValue(AssetPageRow row) {
                return row.getPackageName();
            }
        };
        columnPicker.addColumn((Column<AssetPageRow, ?>)packageNameColumn, new SortableHeader(sortableHeaderGroup, constants.PackageName(), packageNameColumn), false);
        TextColumn<AssetPageRow> stateNameColumn = new TextColumn<AssetPageRow>(){

            public String getValue(AssetPageRow row) {
                return row.getStateName();
            }
        };
        columnPicker.addColumn((Column<AssetPageRow, ?>)stateNameColumn, new SortableHeader(sortableHeaderGroup, constants.Status(), stateNameColumn), true);
        TextColumn<AssetPageRow> creatorColumn = new TextColumn<AssetPageRow>(){

            public String getValue(AssetPageRow row) {
                return row.getCreator();
            }
        };
        columnPicker.addColumn((Column<AssetPageRow, ?>)creatorColumn, new SortableHeader(sortableHeaderGroup, constants.Creator(), creatorColumn), false);
        Column<AssetPageRow, Date> createdDateColumn = new Column<AssetPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(AssetPageRow row) {
                return row.getCreatedDate();
            }
        };
        columnPicker.addColumn(createdDateColumn, new SortableHeader<AssetPageRow, Date>(sortableHeaderGroup, constants.CreatedDate(), createdDateColumn), false);
        TextColumn<AssetPageRow> lastContributorColumn = new TextColumn<AssetPageRow>(){

            public String getValue(AssetPageRow row) {
                return row.getLastContributor();
            }
        };
        columnPicker.addColumn((Column<AssetPageRow, ?>)lastContributorColumn, new SortableHeader(sortableHeaderGroup, constants.LastContributor(), lastContributorColumn), false);
        Column<AssetPageRow, Date> lastModifiedColumn = new Column<AssetPageRow, Date>((Cell)new DateCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_MEDIUM))){

            public Date getValue(AssetPageRow row) {
                return row.getLastModified();
            }
        };
        columnPicker.addColumn(lastModifiedColumn, new SortableHeader<AssetPageRow, Date>(sortableHeaderGroup, constants.LastModified(), lastModifiedColumn), true);
        TextColumn<AssetPageRow> categorySummaryColumn = new TextColumn<AssetPageRow>(){

            public String getValue(AssetPageRow row) {
                return row.getCategorySummary();
            }
        };
        columnPicker.addColumn((Column<AssetPageRow, ?>)categorySummaryColumn, new SortableHeader(sortableHeaderGroup, constants.Categories(), categorySummaryColumn), false);
        TextColumn<AssetPageRow> externalSourceColumn = new TextColumn<AssetPageRow>(){

            public String getValue(AssetPageRow row) {
                return row.getExternalSource();
            }
        };
        columnPicker.addColumn((Column<AssetPageRow, ?>)externalSourceColumn, new SortableHeader(sortableHeaderGroup, constants.ExternalSource(), externalSourceColumn), false);
        Column<AssetPageRow, Boolean> isDisabledColumn = new Column<AssetPageRow, Boolean>((Cell)new RuleEnabledStateCell()){

            public Boolean getValue(AssetPageRow row) {
                return row.isDisabled();
            }
        };
        columnPicker.addColumn(isDisabledColumn, new SortableHeader<AssetPageRow, Boolean>(sortableHeaderGroup, constants.AssetTableIsDisabled(), isDisabledColumn), false);
    }
}

