/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.security.rules;

import java.io.Serializable;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.security.ModuleUUIDType;
import org.drools.guvnor.server.security.RoleBasedPermission;
import org.drools.guvnor.server.security.rules.PackagePermissionRule;
import org.drools.guvnor.server.security.rules.PermissionRule;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;

@ApplicationScoped
public class PackageUUIDTypePermissionRule
implements PermissionRule,
Serializable {
    @Inject
    @Preferred
    private RulesRepository rulesRepository;

    @Override
    public boolean hasPermission(Object requestedObject, String requestedPermission, List<RoleBasedPermission> permissions) {
        String targetName;
        String targetUUID = ((ModuleUUIDType)requestedObject).getUUID();
        try {
            targetName = this.rulesRepository.loadModuleByUUID(targetUUID).getName();
        }
        catch (RulesRepositoryException e) {
            return false;
        }
        return new PackagePermissionRule().hasPermission(targetName, requestedPermission, permissions);
    }
}

