/*
 * Decompiled with CFR 0.152.
 */
package org.drools.command.impl;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.drools.KnowledgeBase;
import org.drools.command.Command;
import org.drools.command.CommandService;
import org.drools.command.GetSessionClockCommand;
import org.drools.command.Interceptor;
import org.drools.command.impl.KnowledgeCommandContext;
import org.drools.command.runtime.AddEventListenerCommand;
import org.drools.command.runtime.DisposeCommand;
import org.drools.command.runtime.GetCalendarsCommand;
import org.drools.command.runtime.GetChannelsCommand;
import org.drools.command.runtime.GetEnvironmentCommand;
import org.drools.command.runtime.GetGlobalCommand;
import org.drools.command.runtime.GetGlobalsCommand;
import org.drools.command.runtime.GetIdCommand;
import org.drools.command.runtime.GetKnowledgeBaseCommand;
import org.drools.command.runtime.RegisterChannelCommand;
import org.drools.command.runtime.RegisterExitPointCommand;
import org.drools.command.runtime.RemoveEventListenerCommand;
import org.drools.command.runtime.SetGlobalCommand;
import org.drools.command.runtime.UnregisterChannelCommand;
import org.drools.command.runtime.UnregisterExitPointCommand;
import org.drools.command.runtime.process.AbortProcessInstanceCommand;
import org.drools.command.runtime.process.AbortWorkItemCommand;
import org.drools.command.runtime.process.CompleteWorkItemCommand;
import org.drools.command.runtime.process.CreateProcessInstanceCommand;
import org.drools.command.runtime.process.GetProcessEventListenersCommand;
import org.drools.command.runtime.process.GetProcessInstanceCommand;
import org.drools.command.runtime.process.GetProcessInstancesCommand;
import org.drools.command.runtime.process.GetWorkItemCommand;
import org.drools.command.runtime.process.RegisterWorkItemHandlerCommand;
import org.drools.command.runtime.process.SignalEventCommand;
import org.drools.command.runtime.process.StartProcessCommand;
import org.drools.command.runtime.process.StartProcessInstanceCommand;
import org.drools.command.runtime.rule.AgendaGroupSetFocusCommand;
import org.drools.command.runtime.rule.ClearActivationGroupCommand;
import org.drools.command.runtime.rule.ClearAgendaCommand;
import org.drools.command.runtime.rule.ClearAgendaGroupCommand;
import org.drools.command.runtime.rule.ClearRuleFlowGroupCommand;
import org.drools.command.runtime.rule.FireAllRulesCommand;
import org.drools.command.runtime.rule.FireUntilHaltCommand;
import org.drools.command.runtime.rule.GetAgendaEventListenersCommand;
import org.drools.command.runtime.rule.GetFactHandleCommand;
import org.drools.command.runtime.rule.GetFactHandlesCommand;
import org.drools.command.runtime.rule.GetObjectCommand;
import org.drools.command.runtime.rule.GetObjectsCommand;
import org.drools.command.runtime.rule.GetWorkingMemoryEntryPointCommand;
import org.drools.command.runtime.rule.GetWorkingMemoryEntryPointsCommand;
import org.drools.command.runtime.rule.GetWorkingMemoryEventListenersCommand;
import org.drools.command.runtime.rule.HaltCommand;
import org.drools.command.runtime.rule.InsertObjectCommand;
import org.drools.command.runtime.rule.QueryCommand;
import org.drools.command.runtime.rule.RetractCommand;
import org.drools.command.runtime.rule.UpdateCommand;
import org.drools.event.process.ProcessEventListener;
import org.drools.event.rule.AgendaEventListener;
import org.drools.event.rule.WorkingMemoryEventListener;
import org.drools.process.instance.WorkItem;
import org.drools.process.instance.WorkItemManager;
import org.drools.rule.EntryPoint;
import org.drools.runtime.Calendars;
import org.drools.runtime.Channel;
import org.drools.runtime.Environment;
import org.drools.runtime.ExitPoint;
import org.drools.runtime.Globals;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.ObjectFilter;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.rule.ActivationGroup;
import org.drools.runtime.rule.Agenda;
import org.drools.runtime.rule.AgendaFilter;
import org.drools.runtime.rule.AgendaGroup;
import org.drools.runtime.rule.FactHandle;
import org.drools.runtime.rule.LiveQuery;
import org.drools.runtime.rule.QueryResults;
import org.drools.runtime.rule.RuleFlowGroup;
import org.drools.runtime.rule.ViewChangedEventListener;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;
import org.drools.time.SessionClock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandBasedStatefulKnowledgeSession
implements StatefulKnowledgeSession {
    private CommandService commandService;
    private transient WorkItemManager workItemManager;
    private transient Agenda agenda;

    public CommandBasedStatefulKnowledgeSession(CommandService commandService) {
        this.commandService = commandService;
    }

    @Override
    public int getId() {
        return this.commandService.execute(new GetIdCommand());
    }

    @Override
    public ProcessInstance getProcessInstance(long id) {
        GetProcessInstanceCommand command = new GetProcessInstanceCommand();
        command.setProcessInstanceId(id);
        return this.commandService.execute(command);
    }

    @Override
    public void abortProcessInstance(long id) {
        AbortProcessInstanceCommand command = new AbortProcessInstanceCommand();
        command.setProcessInstanceId(id);
        this.commandService.execute(command);
    }

    public CommandService getCommandService() {
        return this.commandService;
    }

    @Override
    public Collection<ProcessInstance> getProcessInstances() {
        return this.commandService.execute(new GetProcessInstancesCommand());
    }

    @Override
    public WorkItemManager getWorkItemManager() {
        if (this.workItemManager == null) {
            this.workItemManager = new WorkItemManager(){

                @Override
                public void completeWorkItem(long id, Map<String, Object> results) {
                    CompleteWorkItemCommand command = new CompleteWorkItemCommand();
                    command.setWorkItemId(id);
                    command.setResults(results);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void abortWorkItem(long id) {
                    AbortWorkItemCommand command = new AbortWorkItemCommand();
                    command.setWorkItemId(id);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void registerWorkItemHandler(String workItemName, WorkItemHandler handler) {
                    RegisterWorkItemHandlerCommand command = new RegisterWorkItemHandlerCommand();
                    command.setWorkItemName(workItemName);
                    command.setHandler(handler);
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public WorkItem getWorkItem(long id) {
                    GetWorkItemCommand command = new GetWorkItemCommand();
                    command.setWorkItemId(id);
                    return CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public Set<WorkItem> getWorkItems() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAbortWorkItem(long id) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalAddWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void internalExecuteWorkItem(WorkItem workItem) {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.workItemManager;
    }

    @Override
    public void signalEvent(String type, Object event) {
        SignalEventCommand command = new SignalEventCommand(type, event);
        this.commandService.execute(command);
    }

    @Override
    public void signalEvent(String type, Object event, long processInstanceId) {
        SignalEventCommand command = new SignalEventCommand(processInstanceId, type, event);
        this.commandService.execute(command);
    }

    @Override
    public ProcessInstance startProcess(String processId) {
        return this.startProcess(processId, null);
    }

    @Override
    public ProcessInstance startProcess(String processId, Map<String, Object> parameters) {
        StartProcessCommand command = new StartProcessCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return this.commandService.execute(command);
    }

    @Override
    public ProcessInstance createProcessInstance(String processId, Map<String, Object> parameters) {
        CreateProcessInstanceCommand command = new CreateProcessInstanceCommand();
        command.setProcessId(processId);
        command.setParameters(parameters);
        return this.commandService.execute(command);
    }

    @Override
    public ProcessInstance startProcessInstance(long processInstanceId) {
        StartProcessInstanceCommand command = new StartProcessInstanceCommand();
        command.setProcessInstanceId(processInstanceId);
        return this.commandService.execute(command);
    }

    @Override
    public void dispose() {
        this.commandService.execute(new DisposeCommand());
    }

    @Override
    public int fireAllRules() {
        return this.commandService.execute(new FireAllRulesCommand());
    }

    @Override
    public int fireAllRules(int max) {
        return this.commandService.execute(new FireAllRulesCommand(max));
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter) {
        return this.commandService.execute(new FireAllRulesCommand(agendaFilter));
    }

    @Override
    public int fireAllRules(AgendaFilter agendaFilter, int max) {
        return this.commandService.execute(new FireAllRulesCommand(agendaFilter, max));
    }

    @Override
    public void fireUntilHalt() {
        this.commandService.execute(new FireUntilHaltCommand());
    }

    @Override
    public void fireUntilHalt(AgendaFilter agendaFilter) {
        this.commandService.execute(new FireUntilHaltCommand(agendaFilter));
    }

    @Override
    public KnowledgeBase getKnowledgeBase() {
        return this.commandService.execute(new GetKnowledgeBaseCommand());
    }

    @Override
    @Deprecated
    public void registerExitPoint(String name, ExitPoint exitPoint) {
        this.commandService.execute(new RegisterExitPointCommand(name, exitPoint));
    }

    @Override
    @Deprecated
    public void unregisterExitPoint(String name) {
        this.commandService.execute(new UnregisterExitPointCommand(name));
    }

    @Override
    public void registerChannel(String name, Channel channel) {
        this.commandService.execute(new RegisterChannelCommand(name, channel));
    }

    @Override
    public void unregisterChannel(String name) {
        this.commandService.execute(new UnregisterChannelCommand(name));
    }

    @Override
    public Map<String, Channel> getChannels() {
        return (Map)this.commandService.execute(new GetChannelsCommand());
    }

    @Override
    public Agenda getAgenda() {
        if (this.agenda == null) {
            this.agenda = new Agenda(){

                public void clear() {
                    ClearAgendaCommand command = new ClearAgendaCommand();
                    CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                }

                public ActivationGroup getActivationGroup(final String name) {
                    return new ActivationGroup(){

                        public void clear() {
                            ClearActivationGroupCommand command = new ClearActivationGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }
                    };
                }

                public AgendaGroup getAgendaGroup(final String name) {
                    return new AgendaGroup(){

                        public void clear() {
                            ClearAgendaGroupCommand command = new ClearAgendaGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }

                        public void setFocus() {
                            AgendaGroupSetFocusCommand command = new AgendaGroupSetFocusCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }
                    };
                }

                public RuleFlowGroup getRuleFlowGroup(final String name) {
                    return new RuleFlowGroup(){

                        public void clear() {
                            ClearRuleFlowGroupCommand command = new ClearRuleFlowGroupCommand();
                            command.setName(name);
                            CommandBasedStatefulKnowledgeSession.this.commandService.execute(command);
                        }

                        public String getName() {
                            return name;
                        }
                    };
                }
            };
        }
        return this.agenda;
    }

    @Override
    public FactHandle getFactHandle(Object object) {
        return this.commandService.execute(new GetFactHandleCommand(object));
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles() {
        return this.commandService.execute(new GetFactHandlesCommand());
    }

    @Override
    public <T extends FactHandle> Collection<T> getFactHandles(ObjectFilter filter) {
        return this.commandService.execute(new GetFactHandlesCommand(filter));
    }

    @Override
    public Collection<Object> getObjects() {
        return this.getObjects(null);
    }

    @Override
    public Collection<Object> getObjects(ObjectFilter filter) {
        Collection result = this.commandService.execute(new GetObjectsCommand(filter));
        return result;
    }

    @Override
    public <T extends SessionClock> T getSessionClock() {
        return (T)this.commandService.execute(new GetSessionClockCommand());
    }

    @Override
    public WorkingMemoryEntryPoint getWorkingMemoryEntryPoint(String name) {
        return this.commandService.execute(new GetWorkingMemoryEntryPointCommand(name));
    }

    @Override
    public Collection<? extends WorkingMemoryEntryPoint> getWorkingMemoryEntryPoints() {
        return this.commandService.execute(new GetWorkingMemoryEntryPointsCommand());
    }

    @Override
    public void halt() {
        this.commandService.execute(new HaltCommand());
    }

    @Override
    public FactHandle insert(Object object) {
        return this.commandService.execute(new InsertObjectCommand(object));
    }

    @Override
    public void retract(FactHandle handle) {
        this.commandService.execute(new RetractCommand(handle));
    }

    @Override
    public void update(FactHandle handle, Object object) {
        this.commandService.execute(new UpdateCommand(handle, object));
    }

    @Override
    public void addEventListener(WorkingMemoryEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    @Override
    public void addEventListener(AgendaEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    @Override
    public Collection<AgendaEventListener> getAgendaEventListeners() {
        return this.commandService.execute(new GetAgendaEventListenersCommand());
    }

    @Override
    public Collection<WorkingMemoryEventListener> getWorkingMemoryEventListeners() {
        return this.commandService.execute(new GetWorkingMemoryEventListenersCommand());
    }

    @Override
    public void removeEventListener(WorkingMemoryEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    @Override
    public void removeEventListener(AgendaEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    @Override
    public void addEventListener(ProcessEventListener listener) {
        this.commandService.execute(new AddEventListenerCommand(listener));
    }

    @Override
    public Collection<ProcessEventListener> getProcessEventListeners() {
        return this.commandService.execute(new GetProcessEventListenersCommand());
    }

    @Override
    public void removeEventListener(ProcessEventListener listener) {
        this.commandService.execute(new RemoveEventListenerCommand(listener));
    }

    @Override
    public Object getGlobal(String identifier) {
        return this.commandService.execute(new GetGlobalCommand(identifier));
    }

    @Override
    public void setGlobal(String identifier, Object object) {
        this.commandService.execute(new SetGlobalCommand(identifier, object));
    }

    @Override
    public Globals getGlobals() {
        return this.commandService.execute(new GetGlobalsCommand());
    }

    @Override
    public Calendars getCalendars() {
        return this.commandService.execute(new GetCalendarsCommand());
    }

    @Override
    public Object getObject(FactHandle factHandle) {
        return this.commandService.execute(new GetObjectCommand(factHandle));
    }

    @Override
    public Environment getEnvironment() {
        return this.commandService.execute(new GetEnvironmentCommand());
    }

    @Override
    public <T> T execute(Command<T> command) {
        return this.commandService.execute(command);
    }

    @Override
    public QueryResults getQueryResults(String query, Object ... arguments) {
        QueryCommand cmd = new QueryCommand(null, query, arguments);
        return this.commandService.execute(cmd);
    }

    @Override
    public String getEntryPointId() {
        return EntryPoint.DEFAULT.getEntryPointId();
    }

    @Override
    public long getFactCount() {
        return 0L;
    }

    @Override
    public LiveQuery openLiveQuery(String query, Object[] arguments, ViewChangedEventListener listener) {
        return null;
    }

    @Override
    public KnowledgeSessionConfiguration getSessionConfiguration() {
        return ((KnowledgeCommandContext)this.commandService.getContext()).getStatefulKnowledgesession().getSessionConfiguration();
    }

    public void addInterceptor(Interceptor interceptor) {
        interceptor.setNext(this.commandService);
        this.commandService = interceptor;
    }
}

