/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.Externalizable;
import java.util.HashSet;
import java.util.Map;
import org.drools.base.ClassTypeResolver;
import org.drools.base.TypeResolver;
import org.drools.compiler.DialectCompiletimeRegistry;
import org.drools.compiler.PackageBuilder;
import org.drools.core.util.ClassUtils;
import org.drools.factmodel.traits.TraitRegistry;
import org.drools.io.Resource;
import org.drools.lang.descr.ImportDescr;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.Consequence;

public class PackageRegistry {
    private final Package pkg;
    private String dialect;
    private final DialectRuntimeRegistry dialectRuntimeRegistry;
    private final DialectCompiletimeRegistry dialectCompiletimeRegistry;
    private final TypeResolver typeResolver;

    public PackageRegistry(PackageBuilder packageBuilder, Package pkg) {
        this.pkg = pkg;
        this.dialectCompiletimeRegistry = packageBuilder.getPackageBuilderConfiguration().buildDialectRegistry(packageBuilder, this, pkg);
        this.dialectRuntimeRegistry = pkg.getDialectRuntimeRegistry();
        this.typeResolver = new ClassTypeResolver(new HashSet(this.pkg.getImports().keySet()), packageBuilder.getRootClassLoader(), this.pkg.getName());
        this.typeResolver.addImport(pkg.getName() + ".*");
        pkg.setTypeResolver(this.typeResolver);
    }

    private PackageRegistry(Package pkg, DialectRuntimeRegistry runtimeRegistry, DialectCompiletimeRegistry compiletimeRegistry, TypeResolver typeResolver) {
        this.pkg = pkg;
        this.dialectRuntimeRegistry = runtimeRegistry;
        this.dialectCompiletimeRegistry = compiletimeRegistry;
        this.typeResolver = typeResolver;
    }

    PackageRegistry clonePackage(ClassLoader classLoader) {
        Package clonedPkg = (Package)ClassUtils.deepClone((Externalizable)this.pkg, (ClassLoader)classLoader);
        clonedPkg.setDialectRuntimeRegistry(this.pkg.getDialectRuntimeRegistry());
        for (Rule rule : this.pkg.getRules()) {
            Rule clonedRule = clonedPkg.getRule(rule.getName());
            clonedRule.setConsequence(rule.getConsequence());
            if (!rule.hasNamedConsequences()) continue;
            for (Map.Entry namedConsequence : rule.getNamedConsequences().entrySet()) {
                clonedRule.addNamedConsequence((String)namedConsequence.getKey(), (Consequence)namedConsequence.getValue());
            }
        }
        PackageRegistry clone = new PackageRegistry(clonedPkg, this.dialectRuntimeRegistry, this.dialectCompiletimeRegistry, this.typeResolver);
        clone.setDialect(this.dialect);
        return clone;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
    }

    public Package getPackage() {
        return this.pkg;
    }

    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    public DialectCompiletimeRegistry getDialectCompiletimeRegistry() {
        return this.dialectCompiletimeRegistry;
    }

    public void addImport(ImportDescr importDescr) {
        String importEntry = importDescr.getTarget();
        this.pkg.addImport(new ImportDeclaration(importEntry));
        this.typeResolver.addImport(importEntry);
        this.dialectCompiletimeRegistry.addImport(importDescr);
    }

    public void addStaticImport(ImportDescr importDescr) {
        this.dialectCompiletimeRegistry.addStaticImport(importDescr);
    }

    public TypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    public void compileAll() {
        this.dialectCompiletimeRegistry.compileAll();
    }

    public void removeObjectsGeneratedFromResource(Resource resource) {
        this.pkg.removeObjectsGeneratedFromResource(resource);
    }

    public TraitRegistry getTraitRegistry() {
        return this.pkg.getTraitRegistry();
    }
}

