/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa;

import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.explorer.navigation.qa.VerifyFieldConstraintEditor;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.resources.DroolsGuvnorImages;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;

public class VerifyFactWidget
extends Composite {
    private Grid outer = new Grid(2, 1);
    private boolean showResults;
    private String type;
    private SuggestionCompletionEngine sce;
    private Scenario scenario;
    private ExecutionTrace executionTrace;

    public VerifyFactWidget(final VerifyFact vf, Scenario sc, final SuggestionCompletionEngine sce, ExecutionTrace executionTrace, boolean showResults) {
        this.outer.getCellFormatter().setStyleName(0, 0, "modeller-fact-TypeHeader");
        this.outer.getCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        this.outer.setStyleName("modeller-fact-pattern-Widget");
        this.sce = sce;
        this.scenario = sc;
        this.executionTrace = executionTrace;
        HorizontalPanel ab = new HorizontalPanel();
        if (!vf.anonymous) {
            this.type = (String)sc.getVariableTypes().get(vf.getName());
            ab.add((Widget)new SmallLabel(Constants.INSTANCE.scenarioFactTypeHasValues(this.type, vf.getName())));
        } else {
            this.type = vf.getName();
            ab.add((Widget)new SmallLabel(Constants.INSTANCE.AFactOfType0HasValues(vf.getName())));
        }
        this.showResults = showResults;
        Image add = DroolsGuvnorImages.INSTANCE.AddFieldToFact();
        add.setTitle(Constants.INSTANCE.AddAFieldToThisExpectation());
        add.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                String[] fields = sce.getModelFields(VerifyFactWidget.this.type);
                final FormStylePopup pop = new FormStylePopup(DroolsGuvnorImages.INSTANCE.RuleAsset(), Constants.INSTANCE.ChooseAFieldToAdd());
                final ListBox b = new ListBox();
                for (int i = 0; i < fields.length; ++i) {
                    b.addItem(fields[i]);
                }
                pop.addRow((Widget)b);
                Button ok = new Button(Constants.INSTANCE.OK());
                ok.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent w) {
                        String f = b.getItemText(b.getSelectedIndex());
                        vf.getFieldValues().add(new VerifyField(f, "", "=="));
                        FlexTable data = VerifyFactWidget.this.render(vf);
                        VerifyFactWidget.this.outer.setWidget(1, 0, (Widget)data);
                        pop.hide();
                    }
                });
                pop.addRow((Widget)ok);
                pop.show();
            }
        });
        ab.add((Widget)add);
        this.outer.setWidget(0, 0, (Widget)ab);
        this.initWidget((Widget)this.outer);
        FlexTable data = this.render(vf);
        this.outer.setWidget(1, 0, (Widget)data);
    }

    private FlexTable render(final VerifyFact vf) {
        FlexTable data = new FlexTable();
        for (int i = 0; i < vf.getFieldValues().size(); ++i) {
            final VerifyField fld = (VerifyField)vf.getFieldValues().get(i);
            data.setWidget(i, 1, (Widget)new SmallLabel(fld.getFieldName() + ":"));
            data.getFlexCellFormatter().setHorizontalAlignment(i, 1, HasHorizontalAlignment.ALIGN_RIGHT);
            final ListBox opr = new ListBox();
            opr.addItem(Constants.INSTANCE.equalsScenario(), "==");
            opr.addItem(Constants.INSTANCE.doesNotEqualScenario(), "!=");
            if (fld.getOperator().equals("==")) {
                opr.setSelectedIndex(0);
            } else {
                opr.setSelectedIndex(1);
            }
            opr.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    fld.setOperator(opr.getValue(opr.getSelectedIndex()));
                }
            });
            data.setWidget(i, 2, (Widget)opr);
            VerifyFieldConstraintEditor cellEditor = new VerifyFieldConstraintEditor(this.type, new ValueChanged(){

                public void valueChanged(String newValue) {
                    fld.setExpected(newValue);
                }
            }, fld, this.sce, this.scenario, this.executionTrace);
            data.setWidget(i, 3, (Widget)cellEditor);
            Image del = DroolsGuvnorImages.INSTANCE.DeleteItemSmall();
            del.setAltText(Constants.INSTANCE.RemoveThisFieldExpectation());
            del.setTitle(Constants.INSTANCE.RemoveThisFieldExpectation());
            del.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent w) {
                    if (Window.confirm((String)Constants.INSTANCE.AreYouSureYouWantToRemoveThisFieldExpectation(fld.getFieldName()))) {
                        vf.getFieldValues().remove(fld);
                        FlexTable data = VerifyFactWidget.this.render(vf);
                        VerifyFactWidget.this.outer.setWidget(1, 0, (Widget)data);
                    }
                }
            });
            data.setWidget(i, 4, (Widget)del);
            if (!this.showResults || fld.getSuccessResult() == null) continue;
            if (!fld.getSuccessResult().booleanValue()) {
                data.setWidget(i, 0, (Widget)new Image(DroolsGuvnorImageResources.INSTANCE.warning()));
                data.setWidget(i, 5, (Widget)new HTML(Constants.INSTANCE.ActualResult(fld.getActualResult())));
                data.getCellFormatter().addStyleName(i, 5, "testErrorValue");
                continue;
            }
            data.setWidget(i, 0, (Widget)new Image(DroolsGuvnorImageResources.INSTANCE.testPassed()));
        }
        return data;
    }
}

