/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer.navigation.qa.testscenarios;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.RuleSelectionEvent;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioHelper;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioParentWidget;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.ScenarioWidgetComponentCreator;
import org.drools.guvnor.client.explorer.navigation.qa.testscenarios.TestRunnerWidget;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.moduleeditor.drools.SuggestionCompletionCache;
import org.drools.guvnor.client.resources.DroolsGuvnorImageResources;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.ModuleServiceAsync;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.CallFixtureMap;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.Fixture;
import org.drools.ide.common.client.modeldriven.testing.FixtureList;
import org.drools.ide.common.client.modeldriven.testing.FixturesMap;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyFact;
import org.drools.ide.common.client.modeldriven.testing.VerifyRuleFired;

public class ScenarioWidget
extends Composite
implements EditorWidget,
ScenarioParentWidget {
    private String[] availableRules;
    protected final SuggestionCompletionEngine suggestionCompletionEngine;
    private final VerticalPanel layout = new VerticalPanel();
    private HandlerRegistration availableRulesHandlerRegistration;
    private ScenarioWidgetComponentCreator scenarioWidgetComponentCreator;

    public ScenarioWidget(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this(asset);
    }

    public ScenarioWidget(Asset asset) {
        this.scenarioWidgetComponentCreator = new ScenarioWidgetComponentCreator(asset, this);
        this.setShowResults(false);
        this.suggestionCompletionEngine = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.getMetaData().getModuleName());
        this.ifFixturesSizeZeroThenAddExecutionTrace();
        if (!asset.isReadonly()) {
            this.layout.add((Widget)new TestRunnerWidget(this, asset.getMetaData().getModuleName()));
        }
        this.renderEditor();
        this.initWidget((Widget)this.layout);
        this.setStyleName("scenario-Viewer");
        this.layout.setWidth("100%");
    }

    private void ifFixturesSizeZeroThenAddExecutionTrace() {
        if (this.getScenario().getFixtures().size() == 0) {
            this.getScenario().getFixtures().add(new ExecutionTrace());
        }
    }

    private void createWidgetForEditorLayout(DirtyableFlexTable editorLayout, int layoutRow, int layoutColumn, Widget widget) {
        editorLayout.setWidget(layoutRow, layoutColumn, widget);
    }

    @Override
    public void renderEditor() {
        if (this.layout.getWidgetCount() == 2) {
            this.layout.remove(1);
        }
        DirtyableFlexTable editorLayout = this.scenarioWidgetComponentCreator.createDirtyableFlexTable();
        this.layout.add((Widget)editorLayout);
        ScenarioHelper scenarioHelper = new ScenarioHelper();
        List<Fixture> fixtures = scenarioHelper.lumpyMap(this.getScenario().getFixtures());
        List<ExecutionTrace> listExecutionTrace = scenarioHelper.getExecutionTraceFor(fixtures);
        int layoutRow = 1;
        int executionTraceLine = 0;
        ExecutionTrace previousExecutionTrace = null;
        for (Fixture fixture : fixtures) {
            if (fixture instanceof ExecutionTrace) {
                ExecutionTrace currentExecutionTrace = (ExecutionTrace)fixture;
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createExpectPanel(currentExecutionTrace));
                if (++executionTraceLine >= listExecutionTrace.size()) {
                    executionTraceLine = listExecutionTrace.size() - 1;
                }
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createExecutionWidget(currentExecutionTrace));
                editorLayout.setHorizontalAlignmentForFlexCellFormatter(layoutRow, 2, HasHorizontalAlignment.ALIGN_LEFT);
                previousExecutionTrace = currentExecutionTrace;
            } else if (fixture instanceof FixturesMap) {
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createGivenLabelButton(listExecutionTrace, executionTraceLine, previousExecutionTrace));
                this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 1, this.scenarioWidgetComponentCreator.createGivenPanel(listExecutionTrace, executionTraceLine, (FixturesMap)fixture));
            } else if (fixture instanceof CallFixtureMap) {
                this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createCallMethodLabelButton(listExecutionTrace, executionTraceLine, previousExecutionTrace));
                this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 1, this.scenarioWidgetComponentCreator.createCallMethodOnGivenPanel(listExecutionTrace, executionTraceLine, (CallFixtureMap)fixture));
            } else {
                FixtureList fixturesList = (FixtureList)fixture;
                Fixture first = (Fixture)fixturesList.get(0);
                if (first instanceof VerifyFact) {
                    this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createVerifyFactsPanel(listExecutionTrace, executionTraceLine, fixturesList));
                } else if (first instanceof VerifyRuleFired) {
                    this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createVerifyRulesFiredWidget(fixturesList));
                }
            }
            ++layoutRow;
        }
        this.createWidgetForEditorLayout(editorLayout, layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createAddExecuteButton());
        this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 0, (Widget)this.scenarioWidgetComponentCreator.createSmallLabel());
        this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createConfigWidget());
        HorizontalPanel horizontalPanel = this.scenarioWidgetComponentCreator.createHorizontalPanel();
        this.createWidgetForEditorLayout(editorLayout, ++layoutRow, 0, (Widget)horizontalPanel);
        this.createWidgetForEditorLayout(editorLayout, layoutRow, 1, (Widget)this.scenarioWidgetComponentCreator.createGlobalPanel(scenarioHelper, previousExecutionTrace));
    }

    public Widget getRuleSelectionWidget(final String packageName, RuleSelectionEvent selected) {
        final HorizontalPanel horizontalPanel = new HorizontalPanel();
        final TextBox ruleNameTextBox = this.scenarioWidgetComponentCreator.createRuleNameTextBox();
        horizontalPanel.add((Widget)ruleNameTextBox);
        if (this.availableRules != null) {
            ListBox availableRulesBox = this.scenarioWidgetComponentCreator.createAvailableRulesBox(this.availableRules);
            availableRulesBox.setSelectedIndex(0);
            if (this.availableRulesHandlerRegistration != null) {
                this.availableRulesHandlerRegistration.removeHandler();
            }
            ChangeHandler ruleSelectionCL = this.scenarioWidgetComponentCreator.createRuleChangeHandler(ruleNameTextBox, availableRulesBox);
            this.availableRulesHandlerRegistration = availableRulesBox.addChangeHandler(ruleSelectionCL);
            horizontalPanel.add((Widget)availableRulesBox);
        } else {
            final Button showList = new Button(Constants.INSTANCE.showListButton());
            horizontalPanel.add((Widget)showList);
            showList.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    horizontalPanel.remove((Widget)showList);
                    final Image busy = new Image(DroolsGuvnorImageResources.INSTANCE.searching());
                    SmallLabel loading = new SmallLabel(Constants.INSTANCE.loadingList1());
                    horizontalPanel.add((Widget)busy);
                    horizontalPanel.add((Widget)loading);
                    Scheduler scheduler = Scheduler.get();
                    scheduler.scheduleDeferred((Scheduler.ScheduledCommand)new Command((Label)loading){
                        final /* synthetic */ Label val$loading;
                        {
                            this.val$loading = label;
                        }

                        public void execute() {
                            ModuleServiceAsync moduleService = (ModuleServiceAsync)GWT.create(ModuleService.class);
                            moduleService.listRulesInPackage(packageName, this.createGenericCallback(horizontalPanel, ruleNameTextBox, busy, this.val$loading));
                        }

                        private GenericCallback<String[]> createGenericCallback(final HorizontalPanel horizontalPanel, final TextBox ruleNameTextBox, final Image busy2, final Label loading) {
                            return new GenericCallback<String[]>(){

                                public void onSuccess(String[] list) {
                                    ScenarioWidget.access$002(ScenarioWidget.this, list);
                                    final ListBox availableRulesBox = ScenarioWidget.this.scenarioWidgetComponentCreator.createAvailableRulesBox(list);
                                    ChangeHandler ruleSelectionCL = new ChangeHandler(){

                                        public void onChange(ChangeEvent event) {
                                            ruleNameTextBox.setText(availableRulesBox.getItemText(availableRulesBox.getSelectedIndex()));
                                        }
                                    };
                                    ScenarioWidget.this.availableRulesHandlerRegistration = availableRulesBox.addChangeHandler(ruleSelectionCL);
                                    availableRulesBox.setSelectedIndex(0);
                                    horizontalPanel.add((Widget)availableRulesBox);
                                    horizontalPanel.remove((Widget)busy2);
                                    horizontalPanel.remove((Widget)loading);
                                }
                            };
                        }
                    });
                }
            });
        }
        Button ok = this.scenarioWidgetComponentCreator.createOkButton(selected, ruleNameTextBox);
        horizontalPanel.add((Widget)ok);
        return horizontalPanel;
    }

    void setShowResults(boolean showResults) {
        this.scenarioWidgetComponentCreator.setShowResults(showResults);
    }

    boolean isShowResults() {
        return this.scenarioWidgetComponentCreator.isShowResults();
    }

    public MetaData getMetaData() {
        return this.scenarioWidgetComponentCreator.getMetaData();
    }

    public void setScenario(Scenario scenario) {
        this.scenarioWidgetComponentCreator.setScenario(scenario);
    }

    public Scenario getScenario() {
        return this.scenarioWidgetComponentCreator.getScenario();
    }

    static /* synthetic */ String[] access$002(ScenarioWidget x0, String[] x1) {
        x0.availableRules = x1;
        return x1;
    }
}

