/*
 * Decompiled with CFR 0.152.
 */
package org.drools.ide.common.server.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.ide.common.client.modeldriven.FieldNature;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.ActionCallMethod;
import org.drools.ide.common.client.modeldriven.brl.ActionExecuteWorkItem;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldFunction;
import org.drools.ide.common.client.modeldriven.brl.ActionFieldValue;
import org.drools.ide.common.client.modeldriven.brl.ActionGlobalCollectionAdd;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertFact;
import org.drools.ide.common.client.modeldriven.brl.ActionInsertLogicalFact;
import org.drools.ide.common.client.modeldriven.brl.ActionRetractFact;
import org.drools.ide.common.client.modeldriven.brl.ActionSetField;
import org.drools.ide.common.client.modeldriven.brl.ActionUpdateField;
import org.drools.ide.common.client.modeldriven.brl.ActionWorkItemFieldValue;
import org.drools.ide.common.client.modeldriven.brl.CEPWindow;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.CompositeFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.ide.common.client.modeldriven.brl.DSLSentence;
import org.drools.ide.common.client.modeldriven.brl.ExpressionFormLine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FreeFormLine;
import org.drools.ide.common.client.modeldriven.brl.FromAccumulateCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCollectCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromEntryPointFactPattern;
import org.drools.ide.common.client.modeldriven.brl.HasParameterizedOperator;
import org.drools.ide.common.client.modeldriven.brl.IAction;
import org.drools.ide.common.client.modeldriven.brl.IFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleAttribute;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraintEBLeftSide;
import org.drools.ide.common.server.util.BRLPersistence;
import org.drools.ide.common.server.util.DRLConstraintValueBuilder;
import org.drools.ide.common.server.util.OperatorParameterDRLBuilder;
import org.drools.ide.common.shared.workitems.HasBinding;
import org.drools.ide.common.shared.workitems.PortableParameterDefinition;
import org.drools.ide.common.shared.workitems.PortableWorkDefinition;

public class BRDRLPersistence
implements BRLPersistence {
    private static final String WORKITEM_PREFIX = "wi";
    private static final BRLPersistence INSTANCE = new BRDRLPersistence();
    public static final String DEFAULT_DIALECT = "mvel";
    protected DRLConstraintValueBuilder constraintValueBuilder = DRLConstraintValueBuilder.getBuilder("mvel");
    protected Map<String, IFactPattern> bindingsPatterns;
    protected Map<String, FieldConstraint> bindingsFields;

    protected BRDRLPersistence() {
    }

    public static BRLPersistence getInstance() {
        return INSTANCE;
    }

    @Override
    public String marshal(RuleModel model) {
        return this.marshalRule(model);
    }

    protected String marshalRule(RuleModel model) {
        boolean isDSLEnhanced = model.hasDSLSentences();
        this.bindingsPatterns = new HashMap<String, IFactPattern>();
        this.bindingsFields = new HashMap<String, FieldConstraint>();
        StringBuilder buf = new StringBuilder();
        this.marshalHeader(model, buf);
        this.marshalMetadata(buf, model);
        this.marshalAttributes(buf, model);
        buf.append("\twhen\n");
        this.marshalLHS(buf, model, isDSLEnhanced);
        buf.append("\tthen\n");
        this.marshalRHS(buf, model, isDSLEnhanced);
        this.marshalFooter(buf);
        return buf.toString();
    }

    protected void marshalFooter(StringBuilder buf) {
        buf.append("end\n");
    }

    protected void marshalHeader(RuleModel model, StringBuilder buf) {
        buf.append("rule \"" + this.marshalRuleName(model) + "\"");
        if (null != model.parentName && model.parentName.length() > 0) {
            buf.append(" extends \"" + model.parentName + "\"\n");
        } else {
            buf.append('\n');
        }
    }

    protected String marshalRuleName(RuleModel model) {
        return model.name;
    }

    @Override
    public RuleModel unmarshal(String str) {
        throw new UnsupportedOperationException("Still not possible to convert pure DRL to RuleModel");
    }

    private void marshalAttributes(StringBuilder buf, RuleModel model) {
        boolean hasDialect = false;
        for (int i = 0; i < model.attributes.length; ++i) {
            RuleAttribute attr = model.attributes[i];
            buf.append("\t");
            buf.append(attr);
            buf.append("\n");
            if (!attr.attributeName.equals("dialect")) continue;
            this.constraintValueBuilder = DRLConstraintValueBuilder.getBuilder(attr.value);
            hasDialect = true;
        }
        if (!hasDialect) {
            RuleAttribute attr = new RuleAttribute("dialect", DEFAULT_DIALECT);
            buf.append("\t");
            buf.append(attr);
            buf.append("\n");
        }
    }

    private void marshalMetadata(StringBuilder buf, RuleModel model) {
        if (model.metadataList != null) {
            for (int i = 0; i < model.metadataList.length; ++i) {
                buf.append("\t").append(model.metadataList[i]).append("\n");
            }
        }
    }

    private void marshalLHS(StringBuilder buf, RuleModel model, boolean isDSLEnhanced) {
        String indentation;
        String nestedIndentation = indentation = "\t\t";
        boolean isNegated = model.isNegated();
        if (model.lhs != null) {
            if (isNegated) {
                nestedIndentation = nestedIndentation + "\t";
                buf.append(indentation);
                buf.append("not (\n");
            }
            LHSPatternVisitor visitor = this.getLHSPatternVisitor(isDSLEnhanced, buf, nestedIndentation, isNegated);
            for (IPattern cond : model.lhs) {
                visitor.visit(cond);
            }
            if (model.isNegated()) {
                buf.delete(buf.length() - 5, buf.length());
                buf.append("\n");
                buf.append(indentation);
                buf.append(")\n");
            }
        }
    }

    protected LHSPatternVisitor getLHSPatternVisitor(boolean isDSLEnhanced, StringBuilder buf, String nestedIndentation, boolean isNegated) {
        return new LHSPatternVisitor(isDSLEnhanced, this.bindingsPatterns, this.bindingsFields, this.constraintValueBuilder, buf, nestedIndentation, isNegated);
    }

    private void marshalRHS(StringBuilder buf, RuleModel model, boolean isDSLEnhanced) {
        String indentation = "\t\t";
        if (model.rhs != null) {
            Map<String, List<ActionFieldValue>> classes = this.getRHSClassDependencies(model);
            if (classes.containsKey("Date")) {
                buf.append(indentation);
                buf.append("java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(\"" + System.getProperty("drools.dateformat") + "\");\n");
            }
            if (!this.getRHSWorkItemDependencies(model).isEmpty()) {
                buf.append(indentation);
                buf.append("org.drools.process.instance.WorkItemManager wim = (org.drools.process.instance.WorkItemManager) drools.getWorkingMemory().getWorkItemManager();\n");
            }
            RHSActionVisitor actionVisitor = this.getRHSActionVisitor(isDSLEnhanced, buf, indentation);
            for (IAction action : model.rhs) {
                actionVisitor.visit(action);
            }
        }
    }

    protected RHSActionVisitor getRHSActionVisitor(boolean isDSLEnhanced, StringBuilder buf, String indentation) {
        return new RHSActionVisitor(isDSLEnhanced, this.bindingsPatterns, this.bindingsFields, this.constraintValueBuilder, buf, indentation);
    }

    private Map<String, List<ActionFieldValue>> getRHSClassDependencies(RuleModel model) {
        if (model != null) {
            RHSClassDependencyVisitor dependencyVisitor = new RHSClassDependencyVisitor();
            for (IAction action : model.rhs) {
                dependencyVisitor.visit(action);
            }
            return dependencyVisitor.getRHSClasses();
        }
        Map<String, List<ActionFieldValue>> empty = Collections.emptyMap();
        return empty;
    }

    private List<PortableWorkDefinition> getRHSWorkItemDependencies(RuleModel model) {
        if (model != null) {
            ArrayList<PortableWorkDefinition> workItems = new ArrayList<PortableWorkDefinition>();
            for (IAction action : model.rhs) {
                if (!(action instanceof ActionExecuteWorkItem)) continue;
                workItems.add(((ActionExecuteWorkItem)action).getWorkDefinition());
            }
            return workItems;
        }
        List<PortableWorkDefinition> empty = Collections.emptyList();
        return empty;
    }

    public static class RHSClassDependencyVisitor
    extends ReflectiveVisitor {
        private Map<String, List<ActionFieldValue>> classes = new HashMap<String, List<ActionFieldValue>>();

        public void visitFreeFormLine(FreeFormLine ffl) {
        }

        public void visitActionGlobalCollectionAdd(ActionGlobalCollectionAdd add) {
        }

        public void visitActionRetractFact(ActionRetractFact action) {
        }

        public void visitDSLSentence(DSLSentence sentence) {
        }

        public void visitActionInsertFact(ActionInsertFact action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionInsertLogicalFact(ActionInsertLogicalFact action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionUpdateField(ActionUpdateField action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionSetField(ActionSetField action) {
            this.getClasses(action.fieldValues);
        }

        public void visitActionExecuteWorkItem(ActionExecuteWorkItem action) {
        }

        public Map<String, List<ActionFieldValue>> getRHSClasses() {
            return this.classes;
        }

        private void getClasses(ActionFieldValue[] fieldValues) {
            for (ActionFieldValue afv : fieldValues) {
                String type = afv.getType();
                List<ActionFieldValue> afvs = this.classes.get(type);
                if (afvs == null) {
                    afvs = new ArrayList<ActionFieldValue>();
                    this.classes.put(type, afvs);
                }
                afvs.add(afv);
            }
        }
    }

    public static class RHSActionVisitor
    extends ReflectiveVisitor {
        private StringBuilder buf;
        private boolean isDSLEnhanced;
        private String indentation;
        private int idx = 0;
        private Map<String, IFactPattern> bindingsPatterns;
        private Map<String, FieldConstraint> bindingsFields;
        protected DRLConstraintValueBuilder constraintValueBuilder;
        private Set<String> instantiatedWorkItems;

        public RHSActionVisitor(boolean isDSLEnhanced, Map<String, IFactPattern> bindingsPatterns, Map<String, FieldConstraint> bindingsFields, DRLConstraintValueBuilder constraintValueBuilder, StringBuilder b, String indentation) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.bindingsPatterns = bindingsPatterns;
            this.bindingsFields = bindingsFields;
            this.constraintValueBuilder = constraintValueBuilder;
            this.indentation = indentation;
            this.instantiatedWorkItems = new HashSet<String>();
            this.buf = b;
        }

        public void visitActionInsertFact(ActionInsertFact action) {
            this.generateInsertCall(action, false);
        }

        public void visitActionInsertLogicalFact(ActionInsertLogicalFact action) {
            this.generateInsertCall(action, true);
        }

        public void visitFreeFormLine(FreeFormLine ffl) {
            String[] lines;
            for (String line : lines = ffl.text.split("\\n|\\r\\n")) {
                this.buf.append(this.indentation);
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                this.buf.append(line + "\n");
            }
        }

        private void generateInsertCall(ActionInsertFact action, boolean isLogic) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (action.fieldValues.length == 0 && action.getBoundName() == null) {
                this.buf.append(isLogic ? "insertLogical( new " : "insert( new ");
                this.buf.append(action.factType);
                this.buf.append("() );\n");
            } else {
                this.buf.append(action.factType);
                if (action.getBoundName() == null) {
                    this.buf.append(" fact");
                    this.buf.append(this.idx);
                } else {
                    this.buf.append(" " + action.getBoundName());
                }
                this.buf.append(" = new ");
                this.buf.append(action.factType);
                this.buf.append("();\n");
                if (action.getBoundName() == null) {
                    this.generateSetMethodCalls("fact" + this.idx, action.fieldValues);
                } else {
                    this.generateSetMethodCalls(action.getBoundName(), action.fieldValues);
                }
                this.buf.append(this.indentation);
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                if (isLogic) {
                    this.buf.append("insertLogical( ");
                    if (action.getBoundName() == null) {
                        this.buf.append("fact");
                        this.buf.append(this.idx++);
                    } else {
                        this.buf.append(action.getBoundName());
                    }
                    this.buf.append(" );\n");
                } else {
                    this.buf.append("insert( ");
                    if (action.getBoundName() == null) {
                        this.buf.append("fact");
                        this.buf.append(this.idx++);
                    } else {
                        this.buf.append(action.getBoundName());
                    }
                    this.buf.append(" );\n");
                }
            }
        }

        public void visitActionUpdateField(ActionUpdateField action) {
            this.visitActionSetField(action);
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("update( ");
            this.buf.append(action.variable);
            this.buf.append(" );\n");
        }

        public void visitActionGlobalCollectionAdd(ActionGlobalCollectionAdd add) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(add.globalName + ".add(" + add.factName + ");\n");
        }

        public void visitActionRetractFact(ActionRetractFact action) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append("retract( ");
            this.buf.append(action.variableName);
            this.buf.append(" );\n");
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append(this.indentation);
            this.buf.append(sentence.interpolate());
            this.buf.append("\n");
        }

        public void visitActionExecuteWorkItem(ActionExecuteWorkItem action) {
            String wiName = action.getWorkDefinition().getName();
            String wiImplName = BRDRLPersistence.WORKITEM_PREFIX + wiName;
            this.instantiatedWorkItems.add(wiName);
            this.buf.append(this.indentation);
            this.buf.append("org.drools.process.instance.impl.WorkItemImpl ");
            this.buf.append(wiImplName);
            this.buf.append(" = new org.drools.process.instance.impl.WorkItemImpl();\n");
            this.buf.append(this.indentation);
            this.buf.append(wiImplName);
            this.buf.append(".setName( \"");
            this.buf.append(wiName);
            this.buf.append("\" );\n");
            for (PortableParameterDefinition ppd : action.getWorkDefinition().getParameters()) {
                this.makeWorkItemParameterDRL(ppd, wiImplName);
            }
            this.buf.append(this.indentation);
            this.buf.append("wim.internalExecuteWorkItem( ");
            this.buf.append(wiImplName);
            this.buf.append(" );\n");
        }

        private void makeWorkItemParameterDRL(PortableParameterDefinition ppd, String wiImplName) {
            HasBinding hb;
            boolean makeParameter = true;
            if (ppd instanceof HasBinding && (hb = (HasBinding)((Object)ppd)).isBound()) {
                String binding = hb.getBinding();
                makeParameter = this.isBindingValid(binding);
            }
            if (makeParameter) {
                this.buf.append(this.indentation);
                this.buf.append(wiImplName);
                this.buf.append(".getParameters().put( \"");
                this.buf.append(ppd.getName());
                this.buf.append("\", ");
                this.buf.append(ppd.asString());
                this.buf.append(" );\n");
            }
        }

        private boolean isBindingValid(String binding) {
            if (this.bindingsPatterns.containsKey(binding)) {
                return true;
            }
            return this.bindingsFields.containsKey(binding);
        }

        public void visitActionSetField(ActionSetField action) {
            if (action instanceof ActionCallMethod) {
                this.generateSetMethodCallsMethod((ActionCallMethod)action, action.fieldValues);
            } else {
                this.generateSetMethodCalls(action.variable, action.fieldValues);
            }
        }

        private void generateSetMethodCalls(String variableName, ActionFieldValue[] fieldValues) {
            for (int i = 0; i < fieldValues.length; ++i) {
                this.buf.append(this.indentation);
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                this.buf.append(variableName);
                ActionFieldValue fieldValue = fieldValues[i];
                if (fieldValue instanceof ActionFieldFunction) {
                    this.buf.append(".");
                    this.buf.append(fieldValue.field);
                } else {
                    this.buf.append(".set");
                    this.buf.append(Character.toUpperCase(fieldValues[i].field.charAt(0)));
                    this.buf.append(fieldValues[i].field.substring(1));
                }
                this.buf.append("( ");
                this.generateSetMethodCallParameterValue(this.buf, fieldValue);
                this.buf.append(" );\n");
            }
        }

        private void generateSetMethodCallParameterValue(StringBuilder buf, ActionFieldValue fieldValue) {
            if (fieldValue.isFormula()) {
                this.buildFormulaFieldValue(fieldValue, buf);
            } else if (fieldValue.nature == 7L) {
                this.buildTemplateFieldValue(fieldValue, buf);
            } else if (fieldValue instanceof ActionWorkItemFieldValue) {
                this.buildWorkItemFieldValue((ActionWorkItemFieldValue)fieldValue, buf);
            } else {
                this.buildDefaultFieldValue(fieldValue, buf);
            }
        }

        protected void buildFormulaFieldValue(ActionFieldValue fieldValue, StringBuilder buf) {
            buf.append(fieldValue.value.substring(1));
        }

        protected void buildTemplateFieldValue(ActionFieldValue fieldValue, StringBuilder buf) {
            this.constraintValueBuilder.buildRHSFieldValue(buf, fieldValue.type, "@{" + fieldValue.value + "}");
        }

        protected void buildWorkItemFieldValue(ActionWorkItemFieldValue afv, StringBuilder buf) {
            if (this.instantiatedWorkItems.contains(afv.getWorkItemName())) {
                buf.append("(");
                buf.append(afv.getWorkItemParameterClassName());
                buf.append(") ");
                buf.append(BRDRLPersistence.WORKITEM_PREFIX);
                buf.append(afv.getWorkItemName());
                buf.append(".getResult( \"");
                buf.append(afv.getWorkItemParameterName());
                buf.append("\" )");
            } else {
                buf.append("null");
            }
        }

        protected void buildDefaultFieldValue(ActionFieldValue fieldValue, StringBuilder buf) {
            this.constraintValueBuilder.buildRHSFieldValue(buf, fieldValue.type, fieldValue.value);
        }

        private void generateSetMethodCallsMethod(ActionCallMethod action, FieldNature[] fieldValues) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.buf.append(action.variable);
            this.buf.append(".");
            this.buf.append(action.methodName);
            this.buf.append("( ");
            boolean isFirst = true;
            for (int i = 0; i < fieldValues.length; ++i) {
                ActionFieldFunction valueFunction = (ActionFieldFunction)fieldValues[i];
                if (isFirst) {
                    isFirst = false;
                } else {
                    this.buf.append(", ");
                }
                this.constraintValueBuilder.buildRHSFieldValue(this.buf, valueFunction.type, valueFunction.value);
            }
            this.buf.append(" );\n");
        }
    }

    public static class LHSPatternVisitor
    extends ReflectiveVisitor {
        private StringBuilder buf;
        private boolean isDSLEnhanced;
        private boolean isPatternNegated;
        private String indentation;
        private Map<String, IFactPattern> bindingsPatterns;
        private Map<String, FieldConstraint> bindingsFields;
        protected DRLConstraintValueBuilder constraintValueBuilder;

        public LHSPatternVisitor(boolean isDSLEnhanced, Map<String, IFactPattern> bindingsPatterns, Map<String, FieldConstraint> bindingsFields, DRLConstraintValueBuilder constraintValueBuilder, StringBuilder b, String indentation, boolean isPatternNegated) {
            this.isDSLEnhanced = isDSLEnhanced;
            this.bindingsPatterns = bindingsPatterns;
            this.bindingsFields = bindingsFields;
            this.constraintValueBuilder = constraintValueBuilder;
            this.indentation = indentation;
            this.isPatternNegated = isPatternNegated;
            this.buf = b;
        }

        public void visitFactPattern(FactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            this.generateFactPattern(pattern);
            if (this.isPatternNegated) {
                this.buf.append(" and ");
            }
            this.buf.append("\n");
        }

        public void visitFreeFormLine(FreeFormLine ffl) {
            String[] lines;
            for (String line : lines = ffl.text.split("\\n|\\r\\n")) {
                this.buf.append(this.indentation);
                if (this.isDSLEnhanced) {
                    this.buf.append(">");
                }
                this.buf.append(line + "\n");
            }
        }

        public void visitCompositeFactPattern(CompositeFactPattern pattern) {
            this.buf.append(this.indentation);
            if (this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if ("exists".equals(pattern.type)) {
                this.renderCompositeFOL(pattern);
            } else if ("not".equals(pattern.type)) {
                this.renderCompositeFOL(pattern);
            } else if ("or".equals(pattern.type)) {
                this.buf.append("( ");
                if (pattern.getPatterns() != null) {
                    for (int i = 0; i < pattern.getPatterns().length; ++i) {
                        if (i > 0) {
                            this.buf.append(" ");
                            this.buf.append(pattern.type);
                            this.buf.append(" ");
                        }
                        this.renderSubPattern(pattern, i);
                    }
                }
                this.buf.append(" )\n");
            }
        }

        public void visitFromCompositeFactPattern(FromCompositeFactPattern pattern) {
            this.visitFromCompositeFactPattern(pattern, false);
        }

        public void visitFromCompositeFactPattern(FromCompositeFactPattern pattern, boolean isSubPattern) {
            this.buf.append(this.indentation);
            if (!isSubPattern && this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from ");
            this.renderExpression(pattern.getExpression());
            this.buf.append("\n");
        }

        public void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern) {
            this.visitFromCollectCompositeFactPattern(pattern, false);
        }

        public void visitFromCollectCompositeFactPattern(FromCollectCompositeFactPattern pattern, boolean isSubPattern) {
            this.buf.append(this.indentation);
            if (!isSubPattern && this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from collect ( ");
            if (pattern.getRightPattern() != null) {
                if (pattern.getRightPattern() instanceof FactPattern) {
                    this.generateFactPattern((FactPattern)pattern.getRightPattern());
                } else if (pattern.getRightPattern() instanceof FromAccumulateCompositeFactPattern) {
                    this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)pattern.getRightPattern(), isSubPattern);
                } else if (pattern.getRightPattern() instanceof FromCollectCompositeFactPattern) {
                    this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)pattern.getRightPattern(), isSubPattern);
                } else if (pattern.getRightPattern() instanceof FromEntryPointFactPattern) {
                    this.visitFromEntryPointFactPattern((FromEntryPointFactPattern)pattern.getRightPattern(), isSubPattern);
                } else if (pattern.getRightPattern() instanceof FromCompositeFactPattern) {
                    this.visitFromCompositeFactPattern((FromCompositeFactPattern)pattern.getRightPattern(), isSubPattern);
                } else if (pattern.getRightPattern() instanceof FreeFormLine) {
                    this.visitFreeFormLine((FreeFormLine)pattern.getRightPattern());
                } else {
                    throw new IllegalArgumentException("Unsupported pattern " + pattern.getRightPattern() + " for FROM COLLECT");
                }
            }
            this.buf.append(") \n");
        }

        public void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern) {
            this.visitFromAccumulateCompositeFactPattern(pattern, false);
        }

        public void visitFromAccumulateCompositeFactPattern(FromAccumulateCompositeFactPattern pattern, boolean isSubPattern) {
            this.buf.append(this.indentation);
            if (!isSubPattern && this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from accumulate ( ");
            if (pattern.getSourcePattern() != null) {
                if (pattern.getSourcePattern() instanceof FactPattern) {
                    this.generateFactPattern((FactPattern)pattern.getSourcePattern());
                } else if (pattern.getSourcePattern() instanceof FromAccumulateCompositeFactPattern) {
                    this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)pattern.getSourcePattern(), isSubPattern);
                } else if (pattern.getSourcePattern() instanceof FromCollectCompositeFactPattern) {
                    this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)pattern.getSourcePattern(), isSubPattern);
                } else if (pattern.getSourcePattern() instanceof FromEntryPointFactPattern) {
                    this.visitFromEntryPointFactPattern((FromEntryPointFactPattern)pattern.getSourcePattern(), isSubPattern);
                } else if (pattern.getSourcePattern() instanceof FromCompositeFactPattern) {
                    this.visitFromCompositeFactPattern((FromCompositeFactPattern)pattern.getSourcePattern(), isSubPattern);
                } else {
                    throw new IllegalArgumentException("Unsupported pattern " + pattern.getSourcePattern() + " for FROM ACCUMULATE");
                }
            }
            this.buf.append(",\n");
            if (pattern.useFunctionOrCode().equals("use_function")) {
                this.buf.append(this.indentation + "\t");
                this.buf.append(pattern.getFunction());
            } else {
                this.buf.append(this.indentation + "\tinit( ");
                this.buf.append(pattern.getInitCode());
                this.buf.append(" ),\n");
                this.buf.append(this.indentation + "\taction( ");
                this.buf.append(pattern.getActionCode());
                this.buf.append(" ),\n");
                if (pattern.getReverseCode() != null && !pattern.getReverseCode().trim().equals("")) {
                    this.buf.append(this.indentation + "\treverse( ");
                    this.buf.append(pattern.getReverseCode());
                    this.buf.append(" ),\n");
                }
                this.buf.append(this.indentation + "\tresult( ");
                this.buf.append(pattern.getResultCode());
                this.buf.append(" )\n");
            }
            this.buf.append(") \n");
        }

        public void visitFromEntryPointFactPattern(FromEntryPointFactPattern pattern) {
            this.visitFromEntryPointFactPattern(pattern, false);
        }

        public void visitFromEntryPointFactPattern(FromEntryPointFactPattern pattern, boolean isSubPattern) {
            this.buf.append(this.indentation);
            if (!isSubPattern && this.isDSLEnhanced) {
                this.buf.append(">");
            }
            if (pattern.getFactPattern() != null) {
                this.generateFactPattern(pattern.getFactPattern());
            }
            this.buf.append(" from entry-point \"" + pattern.getEntryPointName() + "\"\n");
        }

        private void renderCompositeFOL(CompositeFactPattern pattern) {
            this.buf.append(pattern.type);
            if (pattern.getPatterns() != null) {
                this.buf.append(" (");
                for (int i = 0; i < pattern.getPatterns().length; ++i) {
                    this.renderSubPattern(pattern, i);
                    if (i == pattern.getPatterns().length - 1) continue;
                    this.buf.append(" and ");
                }
                this.buf.append(") \n");
            }
        }

        private void renderSubPattern(CompositeFactPattern pattern, int subIndex) {
            if (pattern.getPatterns() == null || pattern.getPatterns().length == 0) {
                return;
            }
            IFactPattern subPattern = pattern.getPatterns()[subIndex];
            if (subPattern instanceof FactPattern) {
                this.generateFactPattern((FactPattern)subPattern);
            } else if (subPattern instanceof FromAccumulateCompositeFactPattern) {
                this.visitFromAccumulateCompositeFactPattern((FromAccumulateCompositeFactPattern)subPattern, true);
            } else if (subPattern instanceof FromCollectCompositeFactPattern) {
                this.visitFromCollectCompositeFactPattern((FromCollectCompositeFactPattern)subPattern, true);
            } else if (subPattern instanceof FromCompositeFactPattern) {
                this.visitFromCompositeFactPattern((FromCompositeFactPattern)subPattern, true);
            } else {
                throw new IllegalStateException("Unsupported Pattern: " + subPattern.getClass().getName());
            }
        }

        private void renderExpression(ExpressionFormLine expression) {
            this.buf.append(expression.getText());
        }

        public void visitDSLSentence(DSLSentence sentence) {
            this.buf.append(this.indentation);
            this.buf.append(sentence.interpolate());
            this.buf.append("\n");
        }

        private void generateFactPattern(FactPattern pattern) {
            if (pattern.isNegated()) {
                this.buf.append("not ");
            } else if (pattern.isBound()) {
                this.bindingsPatterns.put(pattern.getBoundName(), pattern);
                this.buf.append(pattern.getBoundName());
                this.buf.append(" : ");
            }
            if (pattern.getFactType() != null) {
                this.buf.append(pattern.getFactType());
            }
            this.buf.append("( ");
            if (pattern.constraintList != null) {
                this.generateConstraints(pattern);
            }
            this.buf.append(")");
            CEPWindow window = pattern.getWindow();
            if (window.isDefined()) {
                this.buf.append(" ");
                this.buf.append(window.getOperator());
                this.buf.append((CharSequence)this.buildOperatorParameterDRL(window.getParameters()));
            }
        }

        private void generateConstraints(FactPattern pattern) {
            int printedCount = 0;
            for (int i = 0; i < pattern.getFieldConstraints().length; ++i) {
                StringBuilder buffer = new StringBuilder();
                this.generateConstraint(pattern.constraintList.constraints[i], false, buffer);
                if (buffer.length() <= 0) continue;
                if (printedCount > 0) {
                    this.buf.append(", ");
                }
                this.buf.append((CharSequence)buffer);
                ++printedCount;
            }
        }

        private void generateConstraint(FieldConstraint con, boolean nested, StringBuilder buf) {
            if (con instanceof CompositeFieldConstraint) {
                FieldConstraint[] nestedConstraints;
                CompositeFieldConstraint cfc = (CompositeFieldConstraint)con;
                if (nested) {
                    buf.append("( ");
                }
                if ((nestedConstraints = cfc.constraints) != null) {
                    for (int i = 0; i < nestedConstraints.length; ++i) {
                        this.generateConstraint(nestedConstraints[i], true, buf);
                        if (i >= nestedConstraints.length - 1) continue;
                        buf.append(cfc.compositeJunctionType + " ");
                    }
                }
                if (nested) {
                    buf.append(")");
                }
            } else {
                this.generateSingleFieldConstraint((SingleFieldConstraint)con, buf);
            }
        }

        private void generateSingleFieldConstraint(SingleFieldConstraint constr, StringBuilder buf) {
            if (constr.getConstraintValueType() == 5) {
                buf.append("eval( ");
                buf.append(constr.getValue());
                buf.append(" )");
            } else {
                if (constr.isBound()) {
                    this.bindingsFields.put(constr.getFieldBinding(), constr);
                    buf.append(constr.getFieldBinding());
                    buf.append(" : ");
                }
                if (constr.getOperator() != null && (constr.getValue() != null || constr.getOperator().equals("== null") || constr.getOperator().equals("!= null")) || constr.getFieldBinding() != null || constr.getConstraintValueType() == 6 || constr instanceof SingleFieldConstraintEBLeftSide) {
                    String fieldName;
                    StringBuilder parentBuf = new StringBuilder();
                    for (SingleFieldConstraint parent = (SingleFieldConstraint)constr.getParent(); parent != null; parent = (SingleFieldConstraint)parent.getParent()) {
                        fieldName = parent.getFieldName();
                        parentBuf.insert(0, fieldName + ".");
                    }
                    buf.append((CharSequence)parentBuf);
                    if (constr instanceof SingleFieldConstraintEBLeftSide) {
                        buf.append(((SingleFieldConstraintEBLeftSide)constr).getExpressionLeftSide().getText());
                    } else {
                        fieldName = constr.getFieldName();
                        buf.append(fieldName);
                    }
                }
                Map<String, String> parameters = null;
                if (constr instanceof HasParameterizedOperator) {
                    SingleFieldConstraint hop = constr;
                    parameters = hop.getParameters();
                }
                if (constr instanceof SingleFieldConstraintEBLeftSide) {
                    SingleFieldConstraintEBLeftSide sfexp = (SingleFieldConstraintEBLeftSide)constr;
                    this.addFieldRestriction(buf, sfexp.getConstraintValueType(), sfexp.getExpressionLeftSide().getGenericType(), sfexp.getOperator(), parameters, sfexp.getValue(), sfexp.getExpressionValue());
                } else {
                    this.addFieldRestriction(buf, constr.getConstraintValueType(), constr.getFieldType(), constr.getOperator(), parameters, constr.getValue(), constr.getExpressionValue());
                }
                if (constr.connectives != null) {
                    for (int j = 0; j < constr.connectives.length; ++j) {
                        ConnectiveConstraint conn = constr.connectives[j];
                        parameters = null;
                        if (conn instanceof HasParameterizedOperator) {
                            ConnectiveConstraint hop = conn;
                            parameters = hop.getParameters();
                        }
                        this.addFieldRestriction(buf, conn.getConstraintValueType(), conn.getFieldType(), conn.getOperator(), parameters, conn.getValue(), conn.getExpressionValue());
                    }
                }
            }
        }

        private void addFieldRestriction(StringBuilder buf, int type, String fieldType, String operator, Map<String, String> parameters, String value, ExpressionFormLine expression) {
            if (operator == null) {
                return;
            }
            buf.append(" ");
            buf.append(operator);
            if (parameters != null && parameters.size() > 0) {
                buf.append((CharSequence)this.buildOperatorParameterDRL(parameters));
            }
            switch (type) {
                case 3: {
                    this.buildReturnValueFieldValue(value, buf);
                    break;
                }
                case 1: {
                    this.buildLiteralFieldValue(operator, type, fieldType, value, buf);
                    break;
                }
                case 6: {
                    this.buildExpressionFieldValue(expression, buf);
                    break;
                }
                case 7: {
                    this.buildTemplateFieldValue(type, fieldType, value, buf);
                    break;
                }
                case 4: {
                    this.buildEnumFieldValue(operator, type, fieldType, value, buf);
                    break;
                }
                default: {
                    this.buildDefaultFieldValue(operator, value, buf);
                }
            }
        }

        protected void buildReturnValueFieldValue(String value, StringBuilder buf) {
            buf.append(" ");
            buf.append("( ");
            buf.append(value);
            buf.append(" )");
            buf.append(" ");
        }

        protected StringBuilder buildOperatorParameterDRL(Map<String, String> parameters) {
            String className = parameters.get("org.drools.ide.common.server.util.BRDRLPersistence.operatorParameterGenerator");
            if (className == null) {
                throw new IllegalStateException("Implementation of 'org.drools.ide.common.server.util.OperatorParameterDRLBuilder' undefined. Unable to build Operator Parameter DRL.");
            }
            try {
                OperatorParameterDRLBuilder builder = (OperatorParameterDRLBuilder)Class.forName(className).newInstance();
                return builder.buildDRL(parameters);
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalStateException("Unable to generate Operator DRL using class '" + className + "'.", cnfe);
            }
            catch (IllegalAccessException iae) {
                throw new IllegalStateException("Unable to generate Operator DRL using class '" + className + "'.", iae);
            }
            catch (InstantiationException ie) {
                throw new IllegalStateException("Unable to generate Operator DRL using class '" + className + "'.", ie);
            }
        }

        protected void buildLiteralFieldValue(String operator, int type, String fieldType, String value, StringBuilder buf) {
            if (SuggestionCompletionEngine.operatorRequiresList(operator)) {
                this.populateValueList(buf, type, fieldType, value);
            } else if (!operator.equals("== null") && !operator.equals("!= null")) {
                buf.append(" ");
                this.constraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, value);
            }
            buf.append(" ");
        }

        private void populateValueList(StringBuilder buf, int type, String fieldType, String value) {
            String workingValue = value.trim();
            if (workingValue.startsWith("(")) {
                workingValue = workingValue.substring(1);
            }
            if (workingValue.endsWith(")")) {
                workingValue = workingValue.substring(0, workingValue.length() - 1);
            }
            String[] values = workingValue.split(",");
            buf.append(" ( ");
            for (String v : values) {
                if ((v = v.trim()).startsWith("\"")) {
                    v = v.substring(1);
                }
                if (v.endsWith("\"")) {
                    v = v.substring(0, v.length() - 1);
                }
                this.constraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, v);
                buf.append(", ");
            }
            buf.delete(buf.length() - 2, buf.length());
            buf.append(" )");
        }

        protected void buildExpressionFieldValue(ExpressionFormLine expression, StringBuilder buf) {
            if (expression != null) {
                buf.append(" ");
                buf.append(expression.getText());
                buf.append(" ");
            }
        }

        protected void buildTemplateFieldValue(int type, String fieldType, String value, StringBuilder buf) {
            buf.append(" ");
            this.constraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, "@{" + value + "}");
            buf.append(" ");
        }

        private void buildEnumFieldValue(String operator, int type, String fieldType, String value, StringBuilder buf) {
            if (SuggestionCompletionEngine.operatorRequiresList(operator)) {
                this.populateValueList(buf, type, fieldType, value);
            } else if (!operator.equals("== null") && !operator.equals("!= null")) {
                buf.append(" ");
                this.constraintValueBuilder.buildLHSFieldValue(buf, type, fieldType, value);
            }
            buf.append(" ");
        }

        protected void buildDefaultFieldValue(String operator, String value, StringBuilder buf) {
            if (!operator.equals("== null") && !operator.equals("!= null")) {
                buf.append(" ");
                buf.append(value);
            }
            buf.append(" ");
        }
    }
}

