/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.asseteditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.IFrameElement;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Frame;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.asseteditor.EditorWidget;
import org.drools.guvnor.client.asseteditor.RuleViewer;
import org.drools.guvnor.client.asseteditor.SaveCommand;
import org.drools.guvnor.client.asseteditor.SaveEventListener;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.configurations.ApplicationPreferences;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;

public class BusinessProcessEditor
extends DirtyableComposite
implements SaveEventListener,
EditorWidget {
    private String modelUUID;
    private Asset asset;
    private Frame frame;

    public BusinessProcessEditor(Asset asset, RuleViewer viewer, ClientFactory clientFactory, EventBus eventBus) {
        this.asset = asset;
        this.modelUUID = asset.getUuid();
        this.initWidgets();
    }

    private void initWidgets() {
        String name = "/" + ApplicationPreferences.getDesignerContext() + "/editor/?uuid=" + this.modelUUID + "&profile=" + ApplicationPreferences.getDesignerProfile();
        this.frame = new Frame(name);
        this.frame.getElement().setAttribute("domain", Document.get().getDomain());
        this.frame.setWidth("100%");
        this.frame.setHeight("580px");
        this.initWidget((Widget)this.frame);
        this.setWidth("100%");
        this.setHeight("580px");
    }

    private final native String callSave(Document var1);

    private final native String callPreprocessingData(Document var1);

    private final native String callCheckParsingErrors(Document var1);

    private final native void callShowParsingErrors(Document var1);

    public boolean hasErrors() {
        String errors = this.callCheckParsingErrors(((IFrameElement)this.frame.getElement()).getContentDocument());
        if (errors != null && errors.equals("false")) {
            return false;
        }
        this.callShowParsingErrors(((IFrameElement)this.frame.getElement()).getContentDocument());
        return true;
    }

    @Override
    public void onSave(SaveCommand saveCommand) {
        try {
            String s = this.callSave(((IFrameElement)this.frame.getElement()).getContentDocument());
            String p = this.callPreprocessingData(((IFrameElement)this.frame.getElement()).getContentDocument());
            if (this.asset.getContent() == null) {
                this.asset.setContent(new RuleFlowContentModel());
            }
            ((RuleFlowContentModel)this.asset.getContent()).setXml(null);
            ((RuleFlowContentModel)this.asset.getContent()).setJson(s);
            ((RuleFlowContentModel)this.asset.getContent()).setPreprocessingdata(p);
        }
        catch (Exception e) {
            GWT.log((String)"JSNI method callSave() threw an exception:", (Throwable)e);
            Window.alert((String)("JSNI method callSave() threw an exception: " + e));
        }
        saveCommand.save();
    }

    @Override
    public void onAfterSave() {
    }
}

