/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import org.drools.guvnor.client.asseteditor.RefreshAssetEditorEvent;
import org.drools.guvnor.client.common.FormStyleLayout;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.GenericCallback;
import org.drools.guvnor.client.common.RulePackageSelector;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.configurations.Capability;
import org.drools.guvnor.client.configurations.UserCapabilities;
import org.drools.guvnor.client.explorer.AssetEditorPlace;
import org.drools.guvnor.client.explorer.ClientFactory;
import org.drools.guvnor.client.explorer.navigation.ClosePlaceEvent;
import org.drools.guvnor.client.messages.ConstantsCore;
import org.drools.guvnor.client.resources.GuvnorImages;
import org.drools.guvnor.client.resources.ImagesCore;
import org.drools.guvnor.client.rpc.Artifact;
import org.drools.guvnor.client.rpc.Asset;
import org.drools.guvnor.client.rpc.AssetService;
import org.drools.guvnor.client.rpc.AssetServiceAsync;
import org.drools.guvnor.client.rpc.MetaData;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.util.DecoratedDisclosurePanel;
import org.drools.guvnor.client.widgets.AssetCategoryEditor;
import org.drools.guvnor.client.widgets.VersionBrowser;

public class MetaDataWidget
extends Composite {
    private ConstantsCore constants = (ConstantsCore)GWT.create(ConstantsCore.class);
    private static ImagesCore images = (ImagesCore)GWT.create(ImagesCore.class);
    private final Artifact artifact;
    private final boolean readOnly;
    private final String uuid;
    private VerticalPanel layout = new VerticalPanel();
    AssetCategoryEditor ed;
    private FormStyleLayout currentSection;
    private String currentSectionName;
    private final ClientFactory clientFactory;
    private final EventBus eventBus;

    public MetaDataWidget(ClientFactory clientFactory, EventBus eventBus, Artifact artifact, boolean readOnly, String uuid) {
        this.clientFactory = clientFactory;
        this.eventBus = eventBus;
        this.uuid = uuid;
        this.artifact = artifact;
        this.readOnly = readOnly;
        this.layout.setWidth("100%");
        this.initWidget((Widget)this.layout);
        this.render();
    }

    private void render() {
        this.layout.clear();
        this.startSection(this.constants.Metadata());
        this.addHeader(images.assetVersion(), this.artifact.getName(), null);
        this.loadData();
    }

    private void addHeader(ImageResource img, String name, Image edit) {
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new SmallLabel("<b>" + name + "</b>"));
        if (edit != null) {
            hp.add((Widget)edit);
        }
        this.currentSection.addAttribute(this.constants.Title(), (Widget)hp);
    }

    private void loadData() {
        if (this.artifact instanceof Asset) {
            this.addAttribute(this.constants.CategoriesMetaData(), this.categories());
        }
        this.addAttribute(this.constants.LastModified(), this.readOnlyDate(this.artifact.getLastModified()));
        this.addAttribute(this.constants.ModifiedByMetaData(), (Widget)this.readOnlyText(this.artifact.getLastContributor()));
        this.addAttribute(this.constants.NoteMetaData(), (Widget)this.readOnlyText(this.artifact.getCheckinComment()));
        if (!this.readOnly) {
            this.addAttribute(this.constants.CreatedOnMetaData(), this.readOnlyDate(this.artifact.getDateCreated()));
        }
        if (this.artifact instanceof Asset) {
            this.addAttribute(this.constants.CreatedByMetaData(), (Widget)this.readOnlyText(((Asset)this.artifact).getMetaData().getCreator()));
            this.addAttribute(this.constants.PackageMetaData(), this.packageEditor(((Asset)this.artifact).getMetaData().getModuleName()));
            this.addAttribute(this.constants.IsDisabledMetaData(), this.editableBoolean(new FieldBooleanBinding(){

                @Override
                public boolean getValue() {
                    return ((Asset)MetaDataWidget.this.artifact).getMetaData().isDisabled();
                }

                @Override
                public void setValue(boolean val) {
                    ((Asset)MetaDataWidget.this.artifact).getMetaData().setDisabled(val);
                }
            }, this.constants.DisableTip()));
        }
        this.addAttribute(this.constants.FormatMetaData(), (Widget)this.readOnlyText(this.artifact.getFormat()));
        this.addAttribute("UUID:", (Widget)this.readOnlyText(this.uuid));
        this.endSection(false);
        if (this.artifact instanceof Asset) {
            final MetaData data = ((Asset)this.artifact).getMetaData();
            this.startSection(this.constants.OtherMetaData());
            this.addAttribute(this.constants.SubjectMetaData(), this.editableText(new FieldBinding(){

                @Override
                public String getValue() {
                    return data.subject;
                }

                @Override
                public void setValue(String val) {
                    data.subject = val;
                }
            }, this.constants.AShortDescriptionOfTheSubjectMatter()));
            this.addAttribute(this.constants.TypeMetaData(), this.editableText(new FieldBinding(){

                @Override
                public String getValue() {
                    return data.type;
                }

                @Override
                public void setValue(String val) {
                    data.type = val;
                }
            }, this.constants.TypeTip()));
            this.addAttribute(this.constants.ExternalLinkMetaData(), this.editableText(new FieldBinding(){

                @Override
                public String getValue() {
                    return data.externalRelation;
                }

                @Override
                public void setValue(String val) {
                    data.externalRelation = val;
                }
            }, this.constants.ExternalLinkTip()));
            this.addAttribute(this.constants.SourceMetaData(), this.editableText(new FieldBinding(){

                @Override
                public String getValue() {
                    return data.externalSource;
                }

                @Override
                public void setValue(String val) {
                    data.externalSource = val;
                }
            }, this.constants.SourceMetaDataTip()));
            this.endSection(true);
        }
        this.startSection(this.constants.VersionHistory());
        Image image = GuvnorImages.INSTANCE.Feed();
        image.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent arg0) {
                Window.open((String)MetaDataWidget.getVersionFeed(MetaDataWidget.this.artifact), (String)"_blank", null);
            }
        });
        this.addAttribute(this.constants.VersionFeed(), (Widget)image);
        this.addAttribute(this.constants.CurrentVersionNumber(), this.getVersionNumberLabel());
        if (!this.readOnly) {
            this.addRow((Widget)new VersionBrowser(this.clientFactory, this.eventBus, this.uuid, !(this.artifact instanceof Asset)));
        }
        this.endSection(true);
    }

    private void addRow(Widget widget) {
        this.currentSection.addRow(widget);
    }

    private void addAttribute(String string, Widget widget) {
        this.currentSection.addAttribute(string, widget);
    }

    private void endSection(boolean collapsed) {
        DecoratedDisclosurePanel advancedDisclosure = new DecoratedDisclosurePanel(this.currentSectionName);
        advancedDisclosure.setWidth("100%");
        advancedDisclosure.setOpen(!collapsed);
        advancedDisclosure.setContent((Widget)this.currentSection);
        this.layout.add((Widget)advancedDisclosure);
    }

    private void startSection(String name) {
        this.currentSection = new FormStyleLayout();
        this.currentSectionName = name;
    }

    private Widget packageEditor(final String packageName) {
        if (this.readOnly || !UserCapabilities.INSTANCE.hasCapability(Capability.SHOW_KNOWLEDGE_BASES_VIEW)) {
            return this.readOnlyText(packageName);
        }
        HorizontalPanel horiz = new HorizontalPanel();
        horiz.setStyleName("metadata-Widget");
        horiz.add((Widget)this.readOnlyText(packageName));
        Image editPackage = GuvnorImages.INSTANCE.Edit();
        editPackage.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                MetaDataWidget.this.showEditPackage(packageName, w);
            }
        });
        horiz.add((Widget)editPackage);
        return horiz;
    }

    private void showEditPackage(final String pkg, ClickEvent source) {
        Image image = new Image(images.packageLarge());
        image.setAltText(ConstantsCore.INSTANCE.Package());
        final FormStylePopup pop = new FormStylePopup(image, this.constants.MoveThisItemToAnotherPackage());
        pop.addAttribute(this.constants.CurrentPackage(), (Widget)new Label(pkg));
        final RulePackageSelector sel = new RulePackageSelector();
        pop.addAttribute(this.constants.NewPackage(), (Widget)sel);
        Button ok = new Button(this.constants.ChangePackage());
        pop.addAttribute("", (Widget)ok);
        ok.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent w) {
                if (sel.getSelectedPackage().equals(pkg)) {
                    Window.alert((String)MetaDataWidget.this.constants.YouNeedToPickADifferentPackageToMoveThisTo());
                    return;
                }
                AssetServiceAsync assetService = (AssetServiceAsync)GWT.create(AssetService.class);
                assetService.changeAssetPackage(MetaDataWidget.this.uuid, sel.getSelectedPackage(), MetaDataWidget.this.constants.MovedFromPackage(pkg), (AsyncCallback<Void>)new GenericCallback<Void>(){

                    public void onSuccess(Void v) {
                        MetaDataWidget.this.eventBus.fireEvent((GwtEvent)new RefreshAssetEditorEvent(sel.getSelectedPackage(), MetaDataWidget.this.uuid));
                        pop.hide();
                    }
                });
            }
        });
        pop.show();
    }

    private void close() {
        this.eventBus.fireEvent((GwtEvent)new ClosePlaceEvent(new AssetEditorPlace(this.uuid)));
    }

    private Widget getVersionNumberLabel() {
        if (this.artifact.getVersionNumber() == 0L) {
            return new SmallLabel(this.constants.NotCheckedInYet());
        }
        return this.readOnlyText(Long.toString(this.artifact.getVersionNumber()));
    }

    private Widget readOnlyDate(Date lastModifiedDate) {
        if (lastModifiedDate == null) {
            return null;
        }
        return new SmallLabel(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_TIME_SHORT).format(lastModifiedDate));
    }

    private Label readOnlyText(String text) {
        SmallLabel lbl = new SmallLabel(text);
        lbl.setWidth("100%");
        return lbl;
    }

    private Widget categories() {
        this.ed = new AssetCategoryEditor(((Asset)this.artifact).getMetaData(), this.readOnly);
        return this.ed;
    }

    private Widget editableBoolean(final FieldBooleanBinding bind, String toolTip) {
        if (!this.readOnly) {
            final CheckBox box = new CheckBox();
            box.setTitle(toolTip);
            box.setValue(Boolean.valueOf(bind.getValue()));
            ClickHandler listener = new ClickHandler(){

                public void onClick(ClickEvent w) {
                    boolean b = box.getValue();
                    bind.setValue(b);
                }
            };
            box.addClickHandler(listener);
            return box;
        }
        CheckBox box = new CheckBox();
        box.setValue(Boolean.valueOf(bind.getValue()));
        box.setEnabled(false);
        return box;
    }

    private Widget editableText(final FieldBinding bind, String toolTip) {
        if (!this.readOnly) {
            final TextBox tbox = new TextBox();
            tbox.setTitle(toolTip);
            tbox.setText(bind.getValue());
            tbox.setVisibleLength(10);
            ChangeHandler listener = new ChangeHandler(){

                public void onChange(ChangeEvent event) {
                    String txt = tbox.getText();
                    bind.setValue(txt);
                }
            };
            tbox.addChangeHandler(listener);
            return tbox;
        }
        return new Label(bind.getValue());
    }

    public Artifact getData() {
        return this.artifact;
    }

    public void refresh() {
        this.render();
    }

    static String getVersionFeed(Artifact artifact) {
        if (artifact instanceof Module) {
            return MetaDataWidget.getRESTBaseURL() + "packages/" + artifact.getName() + "/versions";
        }
        return MetaDataWidget.getRESTBaseURL() + "packages/" + ((Asset)artifact).getMetaData().getModuleName() + "/assets/" + artifact.getName() + "/versions";
    }

    static String getRESTBaseURL() {
        String url = GWT.getModuleBaseURL();
        return url.replaceFirst("org.drools.guvnor.Guvnor", "rest");
    }

    static interface FieldBooleanBinding {
        public void setValue(boolean var1);

        public boolean getValue();
    }

    static interface FieldBinding {
        public void setValue(String var1);

        public String getValue();
    }
}

