/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.client.rpc.SerializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.commons.io.IOUtils;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.core.util.BinaryRuleBaseLoader;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.DetailedSerializationException;
import org.drools.guvnor.client.rpc.Module;
import org.drools.guvnor.client.rpc.ModuleService;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageRequest;
import org.drools.guvnor.client.rpc.SnapshotComparisonPageResponse;
import org.drools.guvnor.client.rpc.SnapshotDiffs;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.server.ModuleFilter;
import org.drools.guvnor.server.RepositoryAssetOperations;
import org.drools.guvnor.server.RepositoryAssetService;
import org.drools.guvnor.server.RepositoryModuleOperations;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.ServiceSecurity;
import org.drools.guvnor.server.builder.ClassLoaderBuilder;
import org.drools.guvnor.server.contenthandler.ModelContentHandler;
import org.drools.guvnor.server.repository.Preferred;
import org.drools.guvnor.server.util.LoggingHelper;
import org.drools.lang.descr.PackageDescr;
import org.drools.lang.descr.TypeDeclarationDescr;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.ModuleItem;
import org.drools.repository.ModuleIterator;
import org.drools.repository.RulesRepository;
import org.drools.repository.RulesRepositoryException;
import org.jboss.seam.remoting.annotations.WebRemote;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.annotations.LoggedIn;

@ApplicationScoped
public class RepositoryModuleService
implements ModuleService {
    private static final long serialVersionUID = 901123L;
    private static final LoggingHelper log = LoggingHelper.getLogger(RepositoryAssetService.class);
    @Inject
    @Preferred
    private RulesRepository rulesRepository;
    @Inject
    private ServiceSecurity serviceSecurity;
    @Inject
    private Identity identity;
    @Inject
    private RepositoryModuleOperations repositoryModuleOperations;
    @Inject
    private RepositoryAssetOperations repositoryAssetOperations;
    @Inject
    private ServiceImplementation serviceImplementation;

    @Override
    @WebRemote
    @LoggedIn
    public Module[] listModules() {
        return this.listModules(null);
    }

    @Override
    @WebRemote
    @LoggedIn
    public Module[] listModules(String workspace) {
        ModuleFilter pf = new ModuleFilter(this.identity);
        return this.repositoryModuleOperations.listModules(false, workspace, pf);
    }

    @Override
    @WebRemote
    @LoggedIn
    public Module[] listArchivedModules() {
        return this.listArchivedModules(null);
    }

    @WebRemote
    @LoggedIn
    public Module[] listArchivedModules(String workspace) {
        return this.repositoryModuleOperations.listModules(true, workspace, new ModuleFilter(this.identity));
    }

    @Override
    public Module loadGlobalModule() {
        return this.repositoryModuleOperations.loadGlobalModule();
    }

    @Override
    @WebRemote
    @LoggedIn
    public void rebuildPackages() throws SerializationException {
        ModuleIterator pkit = this.rulesRepository.listModules();
        StringBuilder errs = new StringBuilder();
        while (pkit.hasNext()) {
            ModuleItem pkg = (ModuleItem)pkit.next();
            try {
                BuilderResult builderResult = this.buildPackage(pkg.getUUID(), true);
                if (builderResult == null) continue;
                errs.append("Unable to build package name [").append(pkg.getName()).append("]\n");
                StringBuilder buf = this.createStringBuilderFrom(builderResult);
                log.warn(buf.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                log.error("An error occurred building package [" + pkg.getName() + "]\n");
                errs.append("An error occurred building package [").append(pkg.getName()).append("]\n");
            }
        }
    }

    private StringBuilder createStringBuilderFrom(BuilderResult res) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < res.getLines().size(); ++i) {
            buf.append(res.getLines().get(i).toString());
            buf.append('\n');
        }
        return buf;
    }

    @Override
    @WebRemote
    @LoggedIn
    public String buildModuleSource(String moduleUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(moduleUUID);
        return this.repositoryModuleOperations.buildModuleSource(moduleUUID);
    }

    @Override
    @WebRemote
    public String copyModule(String sourceModuleName, String destModuleName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryModuleOperations.copyModules(sourceModuleName, destModuleName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void removeModule(String uuid) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageUuid(uuid);
        this.repositoryModuleOperations.removeModule(uuid);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String renameModule(String uuid, String newName) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageUuid(uuid);
        return this.repositoryModuleOperations.renameModule(uuid, newName);
    }

    @WebRemote
    @LoggedIn
    public byte[] exportModules(String moduleName) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(moduleName);
        return this.repositoryModuleOperations.exportModules(moduleName);
    }

    @WebRemote
    @LoggedIn
    public void importPackages(byte[] byteArray, boolean importAsNew) {
        this.repositoryModuleOperations.importPackages(byteArray, importAsNew);
    }

    @Override
    @WebRemote
    public String createModule(String name, String description, String format) throws RulesRepositoryException {
        return this.repositoryModuleOperations.createModule(name, description, format);
    }

    @WebRemote
    public String createModule(String name, String description, String format, String[] workspace) throws RulesRepositoryException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryModuleOperations.createModule(name, description, format, workspace);
    }

    @Override
    @WebRemote
    public String createSubModule(String name, String description, String parentNode) throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        return this.repositoryModuleOperations.createSubModule(name, description, parentNode);
    }

    @Override
    @WebRemote
    @LoggedIn
    public Module loadModule(String uuid) {
        ModuleItem moduleItem = this.rulesRepository.loadModuleByUUID(uuid);
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName(moduleItem.getName());
        return this.repositoryModuleOperations.loadModule(moduleItem);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void saveModule(Module data) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(data.getUuid());
        this.repositoryModuleOperations.saveModule(data);
    }

    @WebRemote
    @LoggedIn
    public BuilderResult buildPackage(String packageUUID, boolean force) throws SerializationException {
        return this.buildPackage(packageUUID, force, null, null, null, false, null, null, false, null);
    }

    @Override
    @WebRemote
    @LoggedIn
    public BuilderResult buildPackage(String packageUUID, boolean force, String buildMode, String statusOperator, String statusDescriptionValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelectorName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageUuid(packageUUID);
        return this.repositoryModuleOperations.buildModule(packageUUID, force, buildMode, statusOperator, statusDescriptionValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelectorName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void createModuleSnapshot(String moduleName, String snapshotName, boolean replaceExisting, String comment, String buildMode, String statusOperator, String statusValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelector) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(moduleName);
        this.repositoryModuleOperations.createModuleSnapshot(moduleName, snapshotName, replaceExisting, comment, false, buildMode, statusOperator, statusValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelector);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void createModuleSnapshot(String moduleName, String snapshotName, boolean replaceExisting, String comment, boolean checkIsBinaryUpToDate, String buildMode, String statusOperator, String statusValue, boolean enableStatusSelector, String categoryOperator, String category, boolean enableCategorySelector, String customSelector) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(moduleName);
        this.repositoryModuleOperations.createModuleSnapshot(moduleName, snapshotName, replaceExisting, comment, checkIsBinaryUpToDate, buildMode, statusOperator, statusValue, enableStatusSelector, categoryOperator, category, enableCategorySelector, customSelector);
    }

    @Override
    @WebRemote
    @LoggedIn
    public void copyOrRemoveSnapshot(String moduleName, String snapshotName, boolean delete, String newSnapshotName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(moduleName);
        this.repositoryModuleOperations.copyOrRemoveSnapshot(moduleName, snapshotName, delete, newSnapshotName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String[] listRulesInPackage(String packageName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName(packageName);
        return this.repositoryModuleOperations.listRulesInPackage(packageName);
    }

    @Override
    @WebRemote
    @LoggedIn
    public String[] listImagesInModule(String moduleName) throws SerializationException {
        this.serviceSecurity.checkSecurityIsPackageReadOnlyWithPackageName(moduleName);
        return this.repositoryModuleOperations.listImagesInModule(moduleName);
    }

    @Override
    @WebRemote
    public void rebuildSnapshots() throws SerializationException {
        this.serviceSecurity.checkSecurityIsAdmin();
        ModuleIterator pkit = this.rulesRepository.listModules();
        while (pkit.hasNext()) {
            String[] snaps;
            ModuleItem pkg = (ModuleItem)pkit.next();
            for (String snapName : snaps = this.rulesRepository.listModuleSnapshots(pkg.getName())) {
                ModuleItem snap = this.rulesRepository.loadModuleSnapshot(pkg.getName(), snapName);
                BuilderResult builderResult = this.buildPackage(snap.getUUID(), true);
                if (!builderResult.hasLines()) continue;
                StringBuilder stringBuilder = this.createStringBuilderFrom(builderResult);
                throw new DetailedSerializationException("Unable to rebuild snapshot [" + snapName, stringBuilder.toString() + "]");
            }
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public SnapshotInfo[] listSnapshots(String moduleName) {
        this.serviceSecurity.checkSecurityIsPackageDeveloperWithPackageName(moduleName);
        String[] snaps = this.rulesRepository.listModuleSnapshots(moduleName);
        SnapshotInfo[] snapshotInfos = new SnapshotInfo[snaps.length];
        for (int i = 0; i < snaps.length; ++i) {
            ModuleItem moduleItem = this.rulesRepository.loadModuleSnapshot(moduleName, snaps[i]);
            snapshotInfos[i] = this.moduleItemToSnapshotItem(snaps[i], moduleItem);
        }
        return snapshotInfos;
    }

    @Override
    @LoggedIn
    public SnapshotInfo loadSnapshotInfo(String packageName, String snapshotName) {
        this.serviceSecurity.checkSecurityIsPackageAdminWithPackageName(packageName);
        return this.moduleItemToSnapshotItem(snapshotName, this.rulesRepository.loadModuleSnapshot(packageName, snapshotName));
    }

    private SnapshotInfo moduleItemToSnapshotItem(String snapshotName, ModuleItem packageItem) {
        SnapshotInfo snapshotInfo = new SnapshotInfo();
        snapshotInfo.setComment(packageItem.getCheckinComment());
        snapshotInfo.setName(snapshotName);
        snapshotInfo.setUuid(packageItem.getUUID());
        return snapshotInfo;
    }

    @Override
    @WebRemote
    @LoggedIn
    public String[] listTypesInPackage(String packageUUID) throws SerializationException {
        this.serviceSecurity.checkSecurityPackageReadOnlyWithPackageUuid(packageUUID);
        ModuleItem pkg = this.rulesRepository.loadModuleByUUID(packageUUID);
        ArrayList<String> res = new ArrayList<String>();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"jar", "model.drl"});
        JarInputStream jis = null;
        try {
            String[] asset;
            while (it.hasNext()) {
                asset = it.next();
                if (asset.isArchived()) continue;
                if (asset.getFormat().equals("jar")) {
                    jis = this.typesForModel(res, (AssetItem)asset);
                    continue;
                }
                this.typesForOthers(res, (AssetItem)asset);
            }
            asset = res.toArray(new String[res.size()]);
            return asset;
        }
        catch (IOException e) {
            log.error("Unable to read the jar files in the package: " + e.getMessage());
            throw new DetailedSerializationException("Unable to read the jar files in the package.", e.getMessage());
        }
        finally {
            IOUtils.closeQuietly(jis);
        }
    }

    @Override
    @WebRemote
    @LoggedIn
    public void updateDependency(String uuid, String dependencyPath) {
        ModuleItem item = this.rulesRepository.loadModuleByUUID(uuid);
        item.updateDependency(dependencyPath);
        item.checkin("Update dependency");
    }

    @Override
    public String[] getDependencies(String uuid) {
        ModuleItem item = this.rulesRepository.loadModuleByUUID(uuid);
        return item.getDependencies();
    }

    private JarInputStream typesForModel(List<String> res, AssetItem asset) throws IOException {
        if (!asset.isBinary()) {
            return null;
        }
        if (asset.getBinaryContentAttachment() == null) {
            return null;
        }
        JarInputStream jis = new JarInputStream(asset.getBinaryContentAttachment());
        JarEntry entry = null;
        while ((entry = jis.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class") || entry.getName().endsWith("package-info.class")) continue;
            res.add(ModelContentHandler.convertPathToName(entry.getName()));
        }
        return jis;
    }

    private void typesForOthers(List<String> res, AssetItem asset) {
        DrlParser parser = new DrlParser();
        try {
            PackageDescr desc = parser.parse(asset.getContent());
            List types = desc.getTypeDeclarations();
            for (TypeDeclarationDescr typeDeclarationDescr : types) {
                res.add(typeDeclarationDescr.getTypeName());
            }
        }
        catch (DroolsParserException e) {
            log.error("An error occurred parsing rule: " + e.getMessage());
        }
    }

    @Override
    @LoggedIn
    public void installSampleRepository() throws SerializationException {
        this.rulesRepository.importRepository(this.getClass().getResourceAsStream("/mortgage-sample-repository.xml"));
        this.rebuildPackages();
        this.rebuildSnapshots();
    }

    @Override
    public SnapshotDiffs compareSnapshots(String moduleName, String firstSnapshotName, String secondSnapshotName) {
        return this.repositoryModuleOperations.compareSnapshots(moduleName, firstSnapshotName, secondSnapshotName);
    }

    @Override
    public SnapshotComparisonPageResponse compareSnapshots(SnapshotComparisonPageRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        if (request.getPageSize() != null && request.getPageSize() < 0) {
            throw new IllegalArgumentException("pageSize cannot be less than zero.");
        }
        return this.repositoryModuleOperations.compareSnapshots(request);
    }

    public void ensureBinaryUpToDate(ModuleItem moduleItem) throws DetailedSerializationException {
        if (!moduleItem.isBinaryUpToDate()) {
            this.repositoryModuleOperations.buildModuleWithoutErrors(moduleItem, false);
        }
    }

    private ClassLoaderBuilder createClassLoaderBuilder(ModuleItem packageItem) {
        return new ClassLoaderBuilder(packageItem.listAssetsWithVersionsSpecifiedByDependenciesByFormat(new String[]{"jar"}));
    }

    private RuleBase deserKnowledgebase(ModuleItem item, ClassLoader classloader) throws IOException, ClassNotFoundException {
        RuleBase rulebase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)new RuleBaseConfiguration(new ClassLoader[]{classloader}));
        BinaryRuleBaseLoader rbl = new BinaryRuleBaseLoader(rulebase, classloader);
        rbl.addPackage((InputStream)new ByteArrayInputStream(item.getCompiledBinaryBytes()));
        return rulebase;
    }

    private RuleBase loadRuleBase(ModuleItem item) throws DetailedSerializationException {
        try {
            return this.deserKnowledgebase(item, (ClassLoader)this.createClassLoaderBuilder(item).buildClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error("Unable to load rule base.", e);
            throw new DetailedSerializationException("A required class was not found.", e.getMessage());
        }
        catch (Exception e) {
            log.error("Unable to load rule base.", e);
            log.info("...but trying to rebuild binaries...");
            try {
                BuilderResult builderResult = this.repositoryModuleOperations.buildModule(item, true);
                if (builderResult != null && builderResult.getLines().size() > 0) {
                    log.error("There were errors when rebuilding the knowledgebase.");
                    throw new DetailedSerializationException("There were errors when rebuilding the knowledgebase.", "");
                }
            }
            catch (Exception e1) {
                log.error("Unable to rebuild the rulebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to rebuild the rulebase.", e.getMessage());
            }
            try {
                return this.deserKnowledgebase(item, (ClassLoader)this.createClassLoaderBuilder(item).buildClassLoader());
            }
            catch (Exception e2) {
                log.error("Unable to reload knowledgebase: " + e.getMessage());
                throw new DetailedSerializationException("Unable to reload knowledgebase.", e.getMessage());
            }
        }
    }
}

