/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.widgets.drools.wizards.assets;

import com.google.gwt.place.shared.PlaceTokenizer;
import org.drools.guvnor.client.rpc.NewGuidedDecisionTableAssetConfiguration;
import org.drools.guvnor.client.widgets.drools.wizards.assets.NewAssetWizardContext;
import org.drools.guvnor.client.widgets.wizards.WizardContext;
import org.drools.guvnor.client.widgets.wizards.WizardPlace;
import org.drools.ide.common.client.modeldriven.dt52.GuidedDecisionTable52;

public class NewGuidedDecisionTableAssetWizardContext
extends NewAssetWizardContext {
    private final GuidedDecisionTable52.TableFormat tableFormat;

    public NewGuidedDecisionTableAssetWizardContext(NewGuidedDecisionTableAssetConfiguration configuration) {
        super(configuration.getAssetName(), configuration.getPackageName(), configuration.getPackageUUID(), configuration.getDescription(), configuration.getInitialCategory(), configuration.getFormat());
        this.tableFormat = ((GuidedDecisionTable52)configuration.getContent()).getTableFormat();
    }

    public GuidedDecisionTable52.TableFormat getTableFormat() {
        return this.tableFormat;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        return hash += 31 * this.tableFormat.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof NewGuidedDecisionTableAssetWizardContext)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NewGuidedDecisionTableAssetWizardContext that = (NewGuidedDecisionTableAssetWizardContext)((Object)o);
        return this.tableFormat.equals((Object)that.tableFormat);
    }

    public static class Tokenizer
    implements PlaceTokenizer<WizardPlace<NewGuidedDecisionTableAssetWizardContext>> {
        private final String ASSET_NAME = "ASSET_NAME=";
        private final String PACKAGE_NAME = "?PACKAGE_NAME=";
        private final String PACKAGE_UUID = "?PACKAGE_UUID=";
        private final String TABLE_FORMAT = "?TABLE_FORMAT=";
        private final String DESCRIPTION = "?DESCRIPTION=";
        private final String CATEGORY = "?CATEGORY=";
        private final String FORMAT = "?FORMAT=";

        public String getToken(WizardPlace<NewGuidedDecisionTableAssetWizardContext> place) {
            StringBuilder sb = new StringBuilder();
            sb.append("ASSET_NAME=");
            sb.append(this.nullSafe(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getAssetName()));
            sb.append("?PACKAGE_NAME=");
            sb.append(this.nullSafe(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getPackageName()));
            sb.append("?PACKAGE_UUID=");
            sb.append(this.nullSafe(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getPackageUUID()));
            sb.append("?TABLE_FORMAT=");
            sb.append(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getTableFormat().toString());
            sb.append("?DESCRIPTION=");
            sb.append(this.nullSafe(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getDescription()));
            sb.append("?CATEGORY=");
            sb.append(this.nullSafe(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getInitialCategory()));
            sb.append("?FORMAT=");
            sb.append(this.nullSafe(((NewGuidedDecisionTableAssetWizardContext)place.getContext()).getFormat()));
            return sb.toString();
        }

        private String nullSafe(String s) {
            return s == null ? "" : s;
        }

        public WizardPlace<NewGuidedDecisionTableAssetWizardContext> getPlace(String token) {
            String assetName = this.getAssetName(token);
            String packageName = this.getPackageName(token);
            String packageUUID = this.getPackageUUID(token);
            GuidedDecisionTable52.TableFormat tableFormat = this.getTableFormat(token);
            String description = this.getDescription(token);
            String category = this.getCategory(token);
            String format = this.getFormat(token);
            GuidedDecisionTable52 content = new GuidedDecisionTable52();
            content.setTableFormat(tableFormat);
            NewGuidedDecisionTableAssetConfiguration config = new NewGuidedDecisionTableAssetConfiguration(assetName, packageName, packageUUID, description, category, format, content);
            NewGuidedDecisionTableAssetWizardContext context = new NewGuidedDecisionTableAssetWizardContext(config);
            return new WizardPlace((WizardContext)context);
        }

        private String getAssetName(String token) {
            return token.substring(token.indexOf("ASSET_NAME=") + "ASSET_NAME=".length(), token.indexOf("?PACKAGE_NAME="));
        }

        private String getPackageName(String token) {
            return token.substring(token.indexOf("?PACKAGE_NAME=") + "?PACKAGE_NAME=".length(), token.indexOf("?PACKAGE_UUID="));
        }

        private String getPackageUUID(String token) {
            return token.substring(token.indexOf("?PACKAGE_UUID=") + "?PACKAGE_UUID=".length(), token.indexOf("?TABLE_FORMAT="));
        }

        private GuidedDecisionTable52.TableFormat getTableFormat(String token) {
            String tableFormat = token.substring(token.indexOf("?TABLE_FORMAT=") + "?TABLE_FORMAT=".length(), token.indexOf("?DESCRIPTION="));
            return GuidedDecisionTable52.TableFormat.valueOf((String)tableFormat);
        }

        private String getDescription(String token) {
            return token.substring(token.indexOf("?DESCRIPTION=") + "?DESCRIPTION=".length(), token.indexOf("?CATEGORY="));
        }

        private String getCategory(String token) {
            return token.substring(token.indexOf("?CATEGORY=") + "?CATEGORY=".length(), token.indexOf("?FORMAT="));
        }

        private String getFormat(String token) {
            return token.substring(token.indexOf("?FORMAT=") + "?FORMAT=".length());
        }
    }
}

